Attribute VB_Name = "ZonasMesas"
Option Explicit

Private Type Rango
  MesaInicial As Integer
  MesaFinal As Integer
End Type

Private CodigosZona() As String
Private RangosZona() As String
Private isInit As Boolean
Private nZonas As Integer

Private Sub init()
  If isInit Then Exit Sub
  isInit = True: nZonas = 0
  On Error GoTo ErrHandler
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT * FROM mesasZonas")
  Do While Not rs.EOF
    ReDim Preserve CodigosZona(nZonas)
    CodigosZona(nZonas) = rs(0)
    ReDim Preserve RangosZona(nZonas)
    RangosZona(nZonas) = rs(1)
    nZonas = nZonas + 1
    rs.MoveNext
  Loop
  rs.Close
  Exit Sub

ErrHandler:
  Err.Clear
  nZonas = 0
  ReDim CodigosZona(0)
  ReDim RangosZona(0)
End Sub

Private Function Rangos(s As String) As Rango()
Dim retArray() As Rango, rex As RegExp, Matches As MatchCollection
Dim v As Variant, copia As String, nextR As Integer
Dim i As Integer
  Set rex = New RegExp ' CreateObject("VBScript.RegExp")
  rex.Global = True
  rex.Pattern = "\d+"
  copia = right(s, Len(s) - 1)
  v = Split(s, ",")
  For i = LBound(v) To UBound(v)
    copia = v(i)
    Set Matches = rex.Execute(copia)
    If Matches.Count > 0 Then
      ReDim Preserve retArray(nextR)
      Dim isFirst As Boolean, m As Object
      With retArray(nextR)
        For Each m In Matches
          If Not isFirst Then .MesaInicial = CInt(Matches(0).value)
          .MesaFinal = CInt(m.value)
          isFirst = True
        Next
      End With
      nextR = nextR + 1
    End If
  Next
  Rangos = retArray
End Function

Public Function PuedeAtender(Mesonero As String, Mesa As String) As Boolean
Dim s As String, v As clsVendedores
  init
  
  If nZonas = 0 Then    ' no hay zonas definidas
    PuedeAtender = True
    Exit Function
  End If
  
  Set v = AlmacenVendedores.Vendedor(Mesonero)
  If v Is Nothing Then
    mAdvertencia "Codigo de mesonero invalido: " & Mesonero
    PuedeAtender = False
    Exit Function
  End If

  s = v.ValorAtributo("ZONA")
  If s = "" Then
    PuedeAtender = False
    Exit Function
  End If

  If s = "*" Then
    PuedeAtender = True
    Exit Function
  End If
  
  Dim i As Integer, j As Integer
  j = -1
  For i = 0 To nZonas - 1
    If CodigosZona(i) = s Then
      j = i
      Exit For
    End If
  Next
  
  If j = -1 Then
    mAdvertencia "El mesonero " & Mesonero & " tiene asignada una zona inexistente"
    PuedeAtender = False
    Exit Function
  End If

  If UCase(left(Mesa, 1)) <> UCase(left(RangosZona(j), 1)) Then
    PuedeAtender = False
    Exit Function
  End If
  Dim r() As Rango, nMesa As Integer
  
  r = Rangos(RangosZona(j))
  nMesa = Val(Mid(Mesa, 2))
  For i = 0 To UBound(r)
    If nMesa >= r(i).MesaInicial And nMesa <= r(i).MesaFinal Then
      PuedeAtender = True
      Exit Function
    End If
  Next
  
  PuedeAtender = False

End Function
