' ***********************************************
' ** ADVERTENCIA:                              **
' ** Este cdigo no forma parte del sistema    **
' ** ClearLight, y se entrega "como est", sin **
' ** ningn tipo de garanta de correccin,    **
' ** utilidad o conveniencia.                  **
' ***********************************************

Public Sub Dump(s)
  dim t
  t = s & " = " & eval(s)
End Sub

Dim OutDev

Const PRINTER_NAME = "FRM:LPT1"
' LPT1 accede directamente al puerto. Otras opciones son COM1, LPT2, etctera.
' Si se necesita imprimir hacia una impresora de Windows, se puede escribir "LPT:<NombreImpresora>",
' por ejemplo "LPT:PrinterCaja"
' Si se desea hacer una "vista previa" del documento antes de la impresin, se puede asignar
' "FRM:Titulo de la Foma" (ejemplo: "FRM:Vista previa de la factura"). En este caso, habra que eliminar
' el salto de lnea que se agrega al argumento de la rutina LPrint.

Const IMPRESION_CONDICIONAL = False
' Si se coloca a True, el script pedir confirmacin antes de imprimir la factura

Const CONSOLIDAR_PRODUCTOS = True
' Determina si dos detalles con la misma descripcin y precio unitario debern acumularse en 
' una sola lnea de salida.

Const PEDIR_DATOS_CLIENTE = False
' Si se coloca a true, se abrirn dos inputBox, pidiendo el nombre y RIF del cliente

Const MOSTRAR_DESCUENTOS = 2
' 0: No mostrar descuentos
' 1: Especificar descuentos por renglon
' 2: Especificar descuentos al final

Const INDICE_REFERENCIA = 1
' Indice del precio de referencia para determinar descuentos

Const LIMITE_PORCENTAJE_DESCUENTO = 2
' Cualquier porcentaje de dscuento inferior a este valor, ser tratado como NO-descuento

' ------------------------------------------------
Class Linea
	Public Codigo
	Public Descripcion
	Public Precio
	Public Cantidad
	Public Total
	Public COdigoImpuesto
	Public PrecioReferencia

  Public Function PorcentajeDescuento()
    Dim dif
    dif = PrecioReferencia - Precio
    dif = dif / Precioreferencia * 100
    If dif <= LIMITE_PORCENTAJE_DESCUENTO Then
      dif = 0
    End If
    PorcentajeDescuento = Dif
  End Function

  Public Function MontoDescuento()
    If PorcentajeDescuento = 0 Then
      MontoDescuento = 0
      Exit Function
    End If
    MontoDescuento = (PrecioReferencia - Precio) * Cantidad
  End Function

End Class

Dim Lineas(), nDetalles

' -------------------------------------------------
' PasarDetalle: Acumula el producto en una de las 
' lineas de salida. 
' -------------------------------------------------
Sub PasarDetalle(sCodigo, sDescripcion, vmPrecio, dCantidad, cImpuesto, vmPrecioLista)
Dim i, pLinea

  If CONSOLIDAR_PRODUCTOS Then
    For i = 1 To nDetalles
      Set pLinea = Lineas(i)
      If pLinea.Descripcion = sDescripcion And pLinea.Precio = vmPrecio Then
	    pLinea.Cantidad = pLinea.Cantidad + dCantidad
	Exit Sub
      End If
    Next
  End If

  Set pLinea = New Linea
  With pLinea
  .Codigo = sCodigo
  .Descripcion = sDescripcion
  .Precio = vmPrecio
  .Cantidad = dCantidad
  .CodigoImpuesto = cImpuesto
  .PrecioReferencia = vmPrecioLista
  End With

  nDetalles = nDetalles + 1
  Redim Preserve Lineas(nDetalles)
  Set Lineas(nDetalles) = pLinea
End Sub

' ------------------------------------------------------
' Transmite el argumento hacia el dispositivo de salida,
' agregndole un salto de lnea al final.
' NOTA: Si se utiliza un dispositivo de vista previa
' (FRM:xxx), se debe eliminar la terminacin "& vbCrLf"
' (es decir, dejar slo "OutDev.Send s"
' ------------------------------------------------------
Sub LPrint(s)
	OutDev.Send s & vbCrlf
End Sub

' ------------------------------------------------------
' Rutina principal...
' ------------------------------------------------------
Sub ImprimirTicket
Dim pOutDev, isPorAbajo, i, pLib, pEmpresa
Dim dbHandle, rs, sDescripcion, vmPrecio, dCantidad, sCodigo
Dim Cuenta
'  Dim ip
'  ip = Factoria.FormByName("frmPOS").cbxPrecio.ListIndex + 1
'  Factoria.CrearObjeto("Database").Execute "UPDATE FacturasPOS SET indicePrecio = " & ip & " WHERE NumeroTicket = " & Factura.NumeroTicket & " AND idMaquina = " & Factura.MachID
  
    If IMPRESION_CONDICIONAL Then
      If msgbox("Imprimir Ticket?",  vbYesno) = vbNo Then
        Exit Sub
      End If
    End If
  
    stOut = "": PrecioTotal = 0: sParte2 = ""
    MontoImpuesto = Factura.Impuesto
    Total = Factura.MontoVenta + MontoImpuesto + Factura.Servicio

    Set pLib = Factoria.CrearObjeto("VSLIB")
    Set OutDev = CreateObject("OutDevice.COutDev")
    OutDev.DeviceName = PRINTER_NAME

    Set pEmpresa = Factoria.CrearObjeto("EMPRESA")

    sParte1 = pEmpresa.NombreEmpresa
    ' Si la longitud del nombre de la empresa es superior a 39 caracteres (uno menos que el ancho del papel)
    ' la parte en dos segmentos.
    If Len(sParte1) > 39 Then
      n = 20
      Do While Mid(sParte1, n, 1) <> " " And n < Len(sParte1)
        n = n + 1
      Loop
      If (n = Len(sParte1)) Then n = 20
      sParte2 = Trim(Right(sParte1, Len(sParte1) - n))
      sParte1 = Trim(Left(sParte1, n))
    End If

    nDetalles = 0	' Inicialmente, la matriz de Lineas() est vaca
  
    ' Comienzo del encabezado

    lPrint ""
'	lPrint stMidAlign("FASHION WORLD 26, c.a.", 39)
'	lPrint stMidAlign("Dr. Paul a Salvador de Leon, 18/1", 39)
'	lPrint "Tlf. 541.2191 / 542.2041  Fax: 542.2442"
'	lPrint stMidAlign("RIF J-31271996-6", 39)
	lPrint "Factura No. " & Factoria.Format(Factura.NumeroTicket, "000000")
	lPrint "Fecha: " & Factoria.Format(Date, "Short Date")
'    lPrint ""
'    lPrint pLib.stMidAlign(sParte1, 39)
'    If sParte2 <> "" Then lPrint pLib.stMidAlign(sParte2, 39)
'    lPrint "RIF " & pEmpresa.RIF
'    lPrint "                  Factura: " & Impresora.Formatear(Factura.NumeroTicket, "000000")
'    lPrint "                  " & pEmpresa.Ciudad & ", " & Impresora.Formatear(Factura.Hora, "Short Date")

    Dim sNombreCliente, sRifCliente, sql, pCliente, pMedio, pCaja, sDirCliente
	
'   sNombreCliente = "": sRifCliente = ""

    If Factura.CodigoCliente <> "" Then
		Set pCliente = Factoria.CrearObjeto("ClientePOS")
		If pCliente.Load(CStr(Factura.CodigoCliente)) Then
			sNombreCliente = pCliente.Nombre
			sRifCliente = pCliente.RIF
			sDirCliente = pCliente.Direccion
		End If
    End If

    If PEDIR_DATOS_CLIENTE Then
      If sNombreCliente = "" Then
        sNombreCliente = InputBox("Nombre", "DATOS DEL CLIENTE")
        If sNombreCLiente <> "" Then
          sRifCliente = InputBox("RIF", "DATOS DEL CLIENTE")
        End If
        If sNombreCLiente <> "" Then
          sDirCliente = InputBox("Direccion", "DATOS DEL CLIENTE")
        End If
      End If
    End If
    
    If sNombreCliente <> "" Then
'		lprint "Hemos Recibido de: " & pCliente.Nombre
		lprint "Cliente: " & sNombreCliente
		If sRifCliente <> "" THen
			lprint "Rif o CI: " & pCliente.Rif
		End If
		If sDirCliente <> "" THen
			lprint "Direccion: " & pCliente.Direccion
		End If
	Else
		lprint "Cliente: Cliente Contado"
    End If

' --------------
    On Error Resume Next
    Dim codigoV, shObj
    set shObj = CreateObject("WScript.Shell")
    codigoV = shObj.RegRead("HKCU\Software\VB And VBA Program Settings\ClearLight\Cochinadas\Mesonero")
    If Err.Number <> 0 Then
      codigoV = "N/A"
    End If
    On Error goto 0
    
    If Trim(codigoV) = "" Then CodigoV = "N/A"
    if CodigoV <> "N/A" Then
 '     lPrint "MESA:" & stFullLength(shObj.RegRead("HKCU\Software\VB And VBA Program Settings\ClearLight\Cochinadas\Mesa"), 8) &  ". Mesonero: " & codigoV
      shObj.RegDelete("HKCU\Software\VB And VBA Program Settings\ClearLight\Cochinadas\Mesonero")
    End If
    Set shObj = Nothing
' --------------

	lprint String(39, "-")
	lprint "Codigo         Descripcion"
	lprint " Cant.         Precio             Total"
	lprint String(39, "-")
'           XXXXXXXXXXXXXXXXXXXXXXXX 999 99.999,99E

    Set colDetalles = Factura.Detalles
    For Each pDetalle In colDetalles
      Dim sti
	  sCodigo = pDetalle.CodigoItem
      sDescripcion = pDetalle.Descripcion
      dCantidad = pDetalle.Cantidad
'      If Factoria.FormByName("frmPOS").Controls("cbxPrecio").ListIndex <> 3 Then
        vmPrecio = pDetalle.PrecioTotal
'      Else
'        vmPrecio = pDetalle.PrecioTotalConIVA
'      End If
      vmPrecio = vmPrecio / dCantidad
      If pDetalle.PorcentajeImpuesto < 0.1 Then
        sti = "E"
      Else
        sti = "G"
      End If
      PasarDetalle sCodigo, sDescripcion, vmPrecio, dCantidad, sti, pDetalle.ItemVenta.Precio(INDICE_REFERENCIA)
    Next

    Dim TotalPrecioLista
    TotalPrecioLista = 0
    For i = 1 To nDetalles
	
      stOut = pLib.stFullLength(Lineas(i).Codigo, 12) 
	    stOut = stOut & pLib.stFullLength(Lineas(i).Descripcion, 24)
      lPrint stOut
    

 	     stOut = pLib.FormatNumero(Lineas(i).Cantidad, "##0", 3) & "       "

      Lineas(i).Total = Lineas(i).Cantidad * Lineas(i).Precio

      stOut = stOut & pLib.FormatNumero(Lineas(i).Precio, "##,##0.00", 9)
      TotalPrecioLista = TotalPrecioLista + (Lineas(i).Precio * Lineas(i).Cantidad)
      stOut = stOut & "    " & pLib.FormatNumero(TotalPrecioLista, "##,##0.00", 9)

      lPrint stOut

    Next

    lPrint    "---------------------------------------"
 
 Set Cuenta = Factoria.CrearObjeto("CuentaPOS")   
 
 If Total > 0 Then
      lPrint "SUB-TOTAL           " & pLib.FormatNumero(Factura.MontoVenta, "#,###,###,##0.00", 16)
      If Factura.Impuesto > 0 Then
      lPrint "IVA (15%)           " & pLib.FormatNumero(Factura.Impuesto, "#,###,###,##0.00", 16)
      End If
  
      If Factura.Servicio > 0 Then
        lPrint  "Servicio " & pLib.FormatNumero(Factura.Servicio, "#,###,###,##0.00", 16)
      End If
    
      lPrint "*** TOTAL ***       " & pLib.FormatNumero(Total, "#,###,###,##0.00", 16)
     Dim Recibido, Cambio
      Factura.EvalVar "RECIBIDO", Recibido, sParte1
        Cambio = 0
      lprint String(39, "-")
      lPrint "Monto Recibido      " & pLib.FormatNumero(Recibido, "#,###,###,##0.00", 16)
      Vuelto = Recibido - Total
      If Vuelto <> 0 Then
      lPrint "Vuelto              " & pLib.FormatNumero(Vuelto, "#,###,###,##0.00", 16)
      End If
    Else
    End If
	Lprint " "
	Lprint " "
	Lprint " "
	Lprint " "
	Lprint " "
    LPrint "-"
    OutDev.Cerrar
    Set pEmpresa = Nothing
    Set pLib = Nothing
    Set pOutDev = Nothing
End Sub
