VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form FIECuentas 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Cuentas"
   ClientHeight    =   4725
   ClientLeft      =   3180
   ClientTop       =   2895
   ClientWidth     =   7380
   ControlBox      =   0   'False
   HelpContextID   =   47
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4725
   ScaleWidth      =   7380
   Visible         =   0   'False
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   5070
      Top             =   3420
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin SimplexW.acCodeBox txCodigo 
      Height          =   315
      Left            =   840
      TabIndex        =   11
      Top             =   120
      Width           =   2655
      _ExtentX        =   4683
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Timer Timer1 
      Interval        =   30000
      Left            =   3480
      Top             =   2130
   End
   Begin VB.Frame Frame1 
      Height          =   825
      Left            =   4260
      TabIndex        =   9
      Top             =   1410
      Width           =   3075
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Height          =   525
         Left            =   90
         TabIndex        =   10
         Top             =   210
         Width           =   2955
         WordWrap        =   -1  'True
      End
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   555
      Left            =   5670
      TabIndex        =   8
      Top             =   4020
      Width           =   1665
   End
   Begin VB.CommandButton cbEliminar 
      Caption         =   "Eli&minar"
      Height          =   525
      Left            =   5670
      TabIndex        =   7
      Top             =   3450
      Width           =   1665
   End
   Begin VB.CommandButton cbEditar 
      Caption         =   "&Editar"
      Height          =   525
      Left            =   5670
      TabIndex        =   6
      Top             =   2880
      Width           =   1665
   End
   Begin MSFlexGridLib.MSFlexGrid flxSaldos 
      Height          =   3135
      Left            =   180
      TabIndex        =   5
      Top             =   1500
      Width           =   3975
      _ExtentX        =   7011
      _ExtentY        =   5530
      _Version        =   393216
      Rows            =   13
      Cols            =   3
      BackColorBkg    =   -2147483643
      AllowBigSelection=   0   'False
      Enabled         =   -1  'True
      BorderStyle     =   0
   End
   Begin VB.TextBox txSaldo 
      Enabled         =   0   'False
      Height          =   315
      Left            =   840
      TabIndex        =   4
      Top             =   1020
      Width           =   1725
   End
   Begin VB.TextBox txTitulo 
      Height          =   315
      Left            =   840
      MaxLength       =   50
      TabIndex        =   1
      Top             =   570
      Width           =   6495
   End
   Begin ucGraphLabel.ucGraphicLabel tglConsultas 
      Height          =   525
      Left            =   5670
      TabIndex        =   12
      ToolTipText     =   "Haga clic para obtener listados de movimientos"
      Top             =   2310
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      LabelX          =   330
      LabelY          =   150
      Picture         =   "FIECuentas.frx":0000
      Caption         =   "Con&sultas"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Image imgAnterior 
      Height          =   555
      Left            =   4410
      Picture         =   "FIECuentas.frx":0452
      Stretch         =   -1  'True
      Top             =   4020
      Width           =   585
   End
   Begin VB.Image imgSiguiente 
      Height          =   555
      Left            =   5010
      Picture         =   "FIECuentas.frx":0894
      Stretch         =   -1  'True
      Top             =   4020
      Width           =   585
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Saldo:"
      Height          =   195
      Left            =   120
      TabIndex        =   3
      Top             =   1050
      Width           =   450
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Titulo:"
      Height          =   195
      Left            =   90
      TabIndex        =   2
      Top             =   600
      Width           =   435
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   540
   End
End
Attribute VB_Name = "FIECuentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit
Public Contexto As Integer
Private bSoloUno As Boolean
Public usrDLL As CusrDLL

Private Sub UpdateSaldos(Codigo As String)
Dim cCuenta As clsCuenta, i As Integer
    Set cCuenta = New clsCuenta
    If cCuenta.Load(Codigo) Then
        txSaldo.Text = Format(cCuenta.Saldo * cCuenta.Factor, Empresa.MascaraMonetarios)
        For i = 1 To 12
            If i <= Empresa.PeriodoActual Then
                flxSaldos.TextMatrix(i, 1) = Format(cCuenta.SaldoPeriodo(Empresa.AnhoActual, i) * cCuenta.Factor, "#,###,###,###,##0.00")
            Else
                flxSaldos.TextMatrix(i, 1) = ""
            End If
            flxSaldos.TextMatrix(i, 2) = Format(cCuenta.SaldoPeriodo(Empresa.AnhoActual - 1, i) * cCuenta.Factor, "#,###,###,###,##0.00")
        Next
    End If
    Set cCuenta = Nothing
End Sub

Private Sub FillFromCuenta(cCuenta As clsCuenta)
Dim i As Integer
    txCodigo.Text = cCuenta.Codigo
    txTitulo.Text = cCuenta.Titulo
    txSaldo.Text = Format(cCuenta.Saldo, Empresa.MascaraMonetarios)
    UpdateSaldos cCuenta.Codigo
    Me.Caption = "Cuentas: " & cCuenta.Titulo & " (" & cCuenta.Codigo & ")"
End Sub

Public Sub SetCodigo(sCodigo As String)
Dim pInstance As clsCuenta

    bSoloUno = True
    txCodigo.Text = sCodigo
    Set pInstance = txCodigo.instance
    If Not pInstance Is Nothing Then FillFromCuenta pInstance
    Set pInstance = Nothing

End Sub

Private Sub cbCancelar_Click()
Dim lCuenta As clsCuenta
    
    If Me.Visible Then cbCancelar.SetFocus
    
    Select Case Contexto
        Case 0, 3:          ' Seleccin, o creacin de nuevo registro
            Me.Hide
        Case 1:             ' Seleccin de nuevo item
            If bSoloUno Then
                Me.Hide
                Exit Sub
            End If
            SetContexto 0
            Exit Sub
        Case 2:             ' Si estaba editando el registro
            Set lCuenta = New clsCuenta
            If lCuenta.Load(txCodigo.Text) Then
                FillFromCuenta lCuenta
                SetContexto 1
            Else
                mAdvertencia "Imposible recargar datos...Registro eliminado"
                SetContexto 0
            End If
            Set lCuenta = Nothing
            Exit Sub
    End Select
End Sub

Private Sub cbEditar_Click()
Dim bTipoP As Byte
Dim lCuenta As clsCuenta

    Select Case Contexto
        Case 1
            SetContexto 2
            Exit Sub
        Case 2
            If Not usrDLL.usrEvent(Me, Me, "Validate") Then Exit Sub
            If txTitulo.Text = "" Then
                mAdvertencia "No puede dejar el ttulo en blanco"
                txTitulo.SetFocus
                Exit Sub
            End If
            Set lCuenta = New clsCuenta
            lCuenta.Load txCodigo.Text
            lCuenta.CambiarTitulo txTitulo.Text
            SetContexto 1
            Set lCuenta = Nothing
            Exit Sub
        Case 3
            If Not usrDLL.usrEvent(Me, Me, "Validate") Then Exit Sub
            If txTitulo.Text = "" Then
                mAdvertencia "No puede dejar el ttulo en blanco"
                txTitulo.SetFocus
                Exit Sub
            End If
            Set lCuenta = New clsCuenta
            lCuenta.CreateNew txCodigo.Text, txTitulo.Text
            Set lCuenta = Nothing
            Me.Hide
            Exit Sub
    End Select
End Sub

Private Sub cbEliminar_Click()
Dim lCuenta As clsCuenta
    If Contexto <> 1 Then
        Exit Sub
    End If
    
    If Not usrDLL.usrEvent(Me, Me, "Eliminar") Then Exit Sub

'    If VerificarUsuario("Eliminar Cuenta") < 5 Then Exit Sub
    Set lCuenta = New clsCuenta
    If lCuenta.Load(txCodigo.Text) Then
        
        If Not Confirmar("Esta seguro de que desea eliminar esta cuenta", True, "Eliminar Cuenta") Then Exit Sub
        If lCuenta.Eliminar Then
            SetContexto 0
        End If
    
    End If
End Sub

Private Sub Form_Activate()
  If txCodigo.Enabled Then txCodigo.SetFocus
  If (Contexto > 0 And Contexto < 3) Then
    UpdateSaldos txCodigo.Text
  End If
End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "FIECuentas.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Terminate()
  Set usrDLL = Nothing
End Sub

#If IsNotMain = 0 Then
Private Sub tglConsultas_Click()
Dim f As lfPopupMenu, res As Integer, sFileName As String
Dim f2 As fselParmsListaMovsCta, rMovsCta As clsListaMovsCta, bResult As Boolean

  Set f = New lfPopupMenu
  f.AddOption "Lista de Movimientos", True
  f.AddOption "Atributos", True
  f.AddOption "VBScript", True

  f.SetSpot Me.left + tglConsultas.left, Me.top + tglConsultas.top + 960
  f.Show 1
  res = f.mnuResult
  Unload f
  Set f = Nothing

  If res = 0 Then Exit Sub

  Select Case res
  Case 1
    Set f2 = New fselParmsListaMovsCta
    f2.SetRangoCuentas txCodigo.Text, txCodigo.Text
    ShowNonModal f2
    
    bResult = f2.txAnhoFinal.Text <> ""
    If bResult Then
        Set rMovsCta = New clsListaMovsCta
        rMovsCta.SetParametros txCodigo.Text, txCodigo.Text, f2.RefInicio, f2.RefFinal, f2.TipoLista
        rMovsCta.Generar
        Set rMovsCta = Nothing
    End If
    Unload f2
    Set f2 = Nothing
  Case 2
    Dim f7 As frmEditAtributosEntidad
    Set f7 = New frmEditAtributosEntidad
    f7.SetEntidad txCodigo.instance
    ShowNonModal f7
    Unload f7
    Set f7 = Nothing
  Case 3
    ScriptsEntidad txCodigo.instance, Me
  End Select

End Sub

#End If

Private Sub imgSiguiente_Click()
Dim lCuenta As clsCuenta
    If Contexto <> 1 Then Exit Sub
    Set lCuenta = New clsCuenta
    lCuenta.Codigo = txCodigo.Text
    If Not lCuenta.LoadSiguiente Then
        mAdvertencia "Este es el ltimo registro"
    Else
        FillFromCuenta lCuenta
    End If
    Set lCuenta = Nothing
End Sub

Private Sub imgAnterior_Click()
Dim lCuenta As clsCuenta
    If Contexto <> 1 Then Exit Sub
    Set lCuenta = New clsCuenta
    lCuenta.Codigo = txCodigo.Text
    If Not lCuenta.LoadAnterior Then
        mAdvertencia "Este es el primer registro"
    Else
        FillFromCuenta lCuenta
    End If
    Set lCuenta = Nothing
End Sub

Private Sub Timer1_Timer()
    If Contexto > 0 And Contexto < 3 Then UpdateSaldos txCodigo.Text
    Timer1.Interval = 30000
End Sub

Private Sub txCodigo_KeyDown(KeyCode As Integer, Shift As Integer)
    
    If KeyCode = vbKeyReturn Then
        KeyCode = 0
        flxSaldos.SetFocus
    End If

End Sub

Private Sub txCodigo_LostFocus()
Dim sTemp As String
Dim lCuenta As clsCuenta
Dim i As Integer
    
    If Not txCodigo.Enabled Then Exit Sub
    If Not Me.Enabled Then
        Exit Sub
    End If
    If Me.ActiveControl Is txCodigo Then Exit Sub
    If Not Me.Visible Then Exit Sub
    If Not txCodigo.Enabled Then Exit Sub
    
    If Contexto = 3 Then Exit Sub
    
    If ActiveControl.Name = "cbCancelar" Then Exit Sub
    If txCodigo.Text = "" Then
      mAdvertencia "Por favor, introduzca un cdigo, o pulse 'Esc' para salir"
      txCodigo.SetFocus
      Exit Sub
    End If
    
    While txCodigo.Validando: DoEvents: Wend
    
    Set lCuenta = txCodigo.instance
    
    If lCuenta Is Nothing Then
        txCodigo.Enabled = True
        txCodigo.SetFocus
    End If
    
    FillFromCuenta lCuenta
    Set lCuenta = Nothing
    SetContexto 1

End Sub

Public Sub SetContexto(newContexto As Integer)
Dim i As Integer
    Contexto = newContexto
    cbEditar.Default = False
    Select Case Contexto
        Case 0          ' Seleccin de nuevo item
            For i = 1 To 12
                flxSaldos.TextMatrix(i, 1) = ""
                flxSaldos.TextMatrix(i, 2) = ""
            Next i
            Me.Caption = "Cuentas: Seleccionar"
            With txCodigo
                .Enabled = True
                .Text = ""
                .SelStart = 0
                .SelLength = Len(.Text)
            End With
            Disable cbEditar: cbEditar.Caption = "&Editar"
            Disable cbEliminar: cbEliminar.Caption = "Eli&minar"
            Enable cbCancelar: cbCancelar.Caption = "Terminar"
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = True
            Disable tglConsultas
            txTitulo.Enabled = False: txTitulo = ""
            If Me.Visible Then txCodigo.SetFocus
            Exit Sub
        Case 1:         ' Item seleccionado: Operaciones posibles
            lblStatus.Caption = "Seleccione la operacin deseada"
            Disable txCodigo     ' Seleccionada
            cbEditar.Caption = "&Editar"
            cbEditar.Enabled = True
            cbEliminar.Caption = "Eli&minar"
            cbEliminar.Enabled = True
            If bSoloUno Then
                cbCancelar.Caption = "Cerrar"
            Else
                cbCancelar.Caption = "Otro"
            End If
            cbCancelar.Enabled = True
            imgAnterior.Enabled = True
            imgSiguiente.Enabled = True
            Enable txTitulo
            Enable tglConsultas
            cbCancelar.SetFocus
            Exit Sub
        Case 2:         ' Edicin de los datos descriptivos
            Disable txCodigo
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            cbEditar.Caption = "&Guardar"
            cbEditar.Enabled = True
            cbEliminar.Enabled = False
            cbEliminar.Caption = "Eli&minar"
            cbCancelar.Caption = "Cancelar"
            cbCancelar.Enabled = True
            Disable tglConsultas
            txTitulo.Enabled = True
            txTitulo.SetFocus
            Exit Sub
        Case 3:         ' Modo de "creacion" de nueva entidad
            txCodigo.Enabled = False
            cbEditar.Caption = "Crear"
            cbEditar.Enabled = True
            cbEliminar.Enabled = False
            cbEliminar.Caption = "Eliminar"
            cbCancelar.Caption = "Cancelar"
            cbCancelar.Enabled = True
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            Enable txTitulo
            Disable tglConsultas
            Contexto = 3
            If Not Me.Visible Then Me.Show
            Exit Sub
    End Select
End Sub

Private Sub Form_Load()
Dim i As Integer
  flxSaldos.TextMatrix(0, 1) = Str(Empresa.AnhoActual)
  flxSaldos.TextMatrix(0, 2) = Str(Empresa.AnhoActual - 1)
  flxSaldos.ColWidth(1) = 1500: flxSaldos.ColWidth(2) = 1500
  For i = 1 To 12
      flxSaldos.TextMatrix(i, 0) = NombreMes(Empresa.Periodo2Mes(i))
  Next
  Set txCodigo.ParentForm = Me
  scaleForm Me
  Centrar Me
  usrDLL.usrEvent Me, Me, "Load"
End Sub
