Attribute VB_Name = "localGlobals"
Option Explicit

Public AlmacenItemsVenta As Object
Public pMenu As clsItemMenu

Private Type aMenu
  MenuID As String
  Numero As String
  Descripcion As String
End Type

Private MenuesRaiz() As aMenu
Private nMenuesRaiz As Integer
Private bLoaded As Boolean

Public Sub DeleteMainMenu(sMenuID As String)
Dim i As Integer

  i = 1
  Do While i < nMenuesRaiz And MenuesRaiz(i).MenuID <> sMenuID
    i = i + 1
  Loop
  
  If MenuesRaiz(i).MenuID = sMenuID Then
    Do While i < nMenuesRaiz
      MenuesRaiz(i) = MenuesRaiz(i + 1)
      i = i + 1
    Loop
    nMenuesRaiz = nMenuesRaiz - 1
    ReDim Preserve MenuesRaiz(nMenuesRaiz)
    WriteMenues
  End If

End Sub

Private Sub WriteMenues()
Dim i As Integer

  DeleteSetting "ClearLight", "General\Menues"
  For i = 1 To nMenuesRaiz
    SaveSetting "ClearLight", "General\Menues", "Menu" & Format(i - 1, "000"), MenuesRaiz(i).MenuID
    SaveSetting "ClearLight", "General\Menues", "Descripcion" & Format(i - 1, "000"), MenuesRaiz(i).Descripcion
  Next
  SaveSetting "ClearLight", "General", "nMenus", Trim(Str(nMenuesRaiz))

End Sub

Public Sub LoadMenues()
Dim sMenuID As String
Dim s As String, d As String, n As Integer, i As Integer
  
  If bLoaded Then Exit Sub
  
  i = 1
  Do
    s = GetSetting("ClearLight", "General\Menues", "Menu" & Format(i - 1, "000"))
    If (s <> "") Then
      ReDim Preserve MenuesRaiz(i)
      MenuesRaiz(i).MenuID = s
      s = GetSetting("ClearLight", "General\Menues", "Descripcion" & Format(i - 1, "000"))
      MenuesRaiz(i).Descripcion = s
      i = i + 1
    End If
  Loop While s <> ""

  nMenuesRaiz = i - 1
  bLoaded = True

End Sub

Public Function IsMainMenu(sMenuID As String) As Boolean
Dim i As Integer, bResult As Boolean

  LoadMenues
  bResult = False
  For i = 1 To nMenuesRaiz
    If MenuesRaiz(i).MenuID = sMenuID Then
      bResult = True
      Exit For
    End If
  Next
  
  IsMainMenu = bResult

End Function

Public Function MainMenuNumber(sMenuID As String) As Integer
Dim i As Integer

  For i = 1 To nMenuesRaiz
    If MenuesRaiz(i).MenuID = sMenuID Then
      MainMenuNumber = i
      Exit Function
    End If
  Next
  
  MainMenuNumber = 0

End Function

Public Function MainMenuDescripcion(sMenuID As String) As String
Dim i As Integer

  LoadMenues
  For i = 1 To nMenuesRaiz
    If MenuesRaiz(i).MenuID = sMenuID Then
      MainMenuDescripcion = MenuesRaiz(i).Descripcion
      Exit Function
    End If
  Next
  
  MainMenuDescripcion = "INCONSISTENCIA!!!"

End Function

Public Function SetMainMenu(sMenuID As String, sDescripcion As String, nNumero As Integer) As Boolean
Dim i As Integer, j As Integer

  If nNumero = 0 Or nNumero > nMenuesRaiz Then
    nMenuesRaiz = nMenuesRaiz + 1
    ReDim Preserve MenuesRaiz(nMenuesRaiz)
    nNumero = nMenuesRaiz
  End If
  
  With MenuesRaiz(nNumero)
  .Descripcion = sDescripcion
  .MenuID = sMenuID
  End With

  WriteMenues

  SetMainMenu = True

End Function
