Attribute VB_Name = "mScriptExecute"
Option Explicit

Public pScript As Object

Public Function GetByName(theObject As Object, PropertyName As String)
Dim v

  On Error GoTo TryNext
  v = CallByName(theObject, PropertyName, VbGet)
  GetByName = v
  Exit Function

TryNext:
  On Error GoTo Failure
  v = CallByName(theObject, PropertyName, VbMethod)
  GetByName = v
  
Failure:
  Exit Function
End Function

Public Function LoadScriptFile(sFileName As String, Optional pDest As Object = Nothing, Optional bNotifyErrors As Boolean = True) As Boolean
Dim s As String, isOk As Boolean, lpScript As Object

  Set lpScript = pDest
  If lpScript Is Nothing Then
    If pScript Is Nothing Then
      On Error Resume Next
      Set pScript = CreateObject("ScriptControl")
      If Err.Number Then
        Err.Clear
        LoadScriptFile = False
        Exit Function
      End If
    End If    ' pScript is Nothing
    Set lpScript = pScript
  End If

  On Error GoTo ErrHandler
  
  lpScript.Language = "VBScript"
  lpScript.Reset
  
  s = sFileName
  If Dir(Trim(s), vbHidden) = "" Then s = BuildDataPath(sFileName, "ClearLight")
  If Dir(Trim(s), vbHidden) = "" Then
    s = GetSetting("ClearLight", "General", "UbicacionScripts", "")
    If Right(s, 1) <> "\" Then s = s & "\"
    s = s & sFileName
  End If
  If Dir(s, vbHidden) = "" Then
    LoadScriptFile = False
    Exit Function
  End If
  s = File2String(s)
  If (s <> "") Then
    isOk = True
    lpScript.AddObject "vsLib", vslib.VSLRTLIB, True
    lpScript.AddCode s
    lpScript.Timeout = -1
    LoadScriptFile = True
  Else
    isOk = False
  End If

ResumePoint:
  LoadScriptFile = isOk
  Exit Function

ErrHandler:
  If bNotifyErrors Then
    If lpScript.Error.Number Then
      mAdvertencia "ERROR EN ARCHIVO DE SCRIPT" & vbCrLf & _
                   "Archivo: " & sFileName & vbCrLf & _
                   "Error: " & lpScript.Error.Description & vbCrLf & _
                   "Linea: " & lpScript.Error.Line & vbCrLf & _
                   "Texto: " & lpScript.Error.Text
    Else
      ReportarError False, Err.Number, Err.Description, "mScriptExecute::LoadScriptFile"
    End If
  End If
  Err.Clear
  isOk = False
  Resume ResumePoint
End Function

Public Sub ExecuteScript(sFileName As String, Optional Caller As Object = Nothing, Optional bNotifyErrors As Boolean = True)
Dim s As String
  
  On Error GoTo ErrHandler
  
  If LoadScriptFile(sFileName, pScript, bNotifyErrors) Then
    pScript.AddObject "Factoria", mGlobales.Factoria
    If Not Caller Is Nothing Then
      pScript.AddObject "OwnerObject", Caller
    End If
    pScript.Run "Main"
    pScript.Reset
  End If

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, lErrN As Long
  sErrD = Err.Description: lErrN = Err.Number
  If bNotifyErrors Then
    If pScript.Error.Number <> 0 Then
      MsgBox "ERROR EN ARCHIVO DE SCRIPT:" & vbCrLf & _
             "Numero: " & pScript.Error.Number & vbCrLf & _
             "Descripcion: " & pScript.Error.Description & vbCrLf & _
             "Linea: " & pScript.Error.Line & vbCrLf & _
             "Texto: " & pScript.Error.Text, vbCritical, sFileName & ": ERROR EN SCRIPT"
    Else
      ReportarError False, lErrN, sErrD, "mScriptExecute::ExecuteScript::VB exec Error"
    End If
  End If
  pScript.Reset
  Resume ResumePoint
End Sub

Public Function ExtendEval(pObject As Object, sFileName As String, sVarId, vRetBuffer) As Boolean
Dim bRetVal As Boolean
    
  On Error GoTo ErrHandler
  If LoadScriptFile(sFileName, bNotifyErrors:=False) Then
    pScript.AddObject "OwnerObject", pObject
    pScript.AddObject "Factoria", mGlobales.Factoria
    On Error Resume Next
    vRetBuffer = pScript.Eval(sVarId)
    
    If VBA.IsEmpty(vRetBuffer) Then
        bRetVal = False
    Else
        bRetVal = True
    End If
    pScript.Reset
  Else
    bRetVal = False
  End If

ResumePoint:
  ExtendEval = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "mScriptExecute.ExtendEval::" & TypeName(pObject)
  bRetVal = False
  Exit Function
End Function

Public Function ExisteProcedimiento(pScript As Object, sProcName As String)
Dim p As Object

  On Error GoTo ErrHandler
  For Each p In pScript.Procedures
    If UCase(p.Name) = UCase(sProcName) Then
      ExisteProcedimiento = True
      Exit Function
    End If
  Next
  ExisteProcedimiento = False
  Exit Function
ErrHandler:
  Err.Clear
  ExisteProcedimiento = False
End Function
