VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CLibroVentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const AnchoReporte = 255
Private Const TipoProveedor = ""
Private Const NumComprobante = ""
Private Const PlanillaImportacion = ""
Private Const ExpedienteImportacion = ""

Private NumeroOperacion As Integer

Private TotalBase1 As Currency, TotalImpuesto1 As Currency, TotalBase2 As Currency, _
        TotalImpuesto2 As Currency, TotalExento As Currency, TotalRetenido As Currency
Private Alicuota1 As Double, Alicuota2 As Double
Private fView As lfQuickView
Private finic As Date, ffinal As Date
'                                                                       Planilla                Numero      Nota de      Nota de   Tipo Nro. Factura Total de Compras  Ventas internas             Base % Ali                                                IVA
' Nro.   Fecha    RIF          Nombre del Cliente                       Import.  Factura Nro.  Control  Debito Nro. Credito Nro. Trans.     Afectada   Incluyendo IVA      no gravadas        Imponible cuota     Impuesto IVA     IVA Retenido       Percibible
'99999 99-99-9999 XXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99999999 XXXXXXXXXXXX 99999999 XXXXXXXXXXXX XXXXXXXXXXXX XXXXXX XXXXXXXXXXXX 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 99,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99

Private Sub DisplayResumen()

  If fView.Linea > fView.LineasPagina - 9 Then
    fView.Add "... resumen en la pagina siguiente ..."
    Encabezado
  End If
  fView.Add "--------------------------------------------------------------------------"
  fView.Add "RESUMEN (Art. 72):"
  fView.Add "--------------------------------------------------------------------------"
  fView.Add "Total de Compras, incluyendo IVA: " & FormatNumero(TotalBase1 + TotalBase2 + TotalExento + TotalImpuesto1 + TotalImpuesto2, Empresa.MascaraMonetarios, 16)
  fView.Add "Ventas exentas                  : " & FormatNumero(TotalExento, Empresa.MascaraMonetarios, 16)
  fView.Add stFullLength("Ventas gravables al " & Format(Alicuota1, "0.00") & "%", 32) & ": " & FormatNumero(TotalBase1, Empresa.MascaraMonetarios, 16)
  fView.Add stFullLength("IVA cobrado al " & Format(Alicuota1, "0.00") & "%", 32) & ": " & FormatNumero(TotalImpuesto1, Empresa.MascaraMonetarios, 16)
  fView.Add stFullLength("Ventas gravables al " & Format(Alicuota2, "0.00") & "%", 32) & ": " & FormatNumero(TotalBase2, Empresa.MascaraMonetarios, 16)
  fView.Add stFullLength("IVA cobrado al " & Format(Alicuota2, "0.00") & "%", 32) & ": " & FormatNumero(TotalImpuesto2, Empresa.MascaraMonetarios, 16)
  fView.Add "Total de IVA cobrado            : " & FormatNumero(TotalImpuesto1 + TotalImpuesto2, Empresa.MascaraMonetarios, 16)
  If TotalRetenido <> 0 Then
    fView.Add "Total retenido                  : " & FormatNumero(TotalRetenido, Empresa.MascaraMonetarios, 16)
    fView.Add "Saldo neto a pagar              : " & FormatNumero(TotalImpuesto1 + TotalImpuesto2 - TotalRetenido, Empresa.MascaraMonetarios, 16)
  End If

End Sub

Private Sub TirarTotales(Titulo As String)
Dim sOut As String
  sOut = stFullLength(Titulo, 148)
  sOut = sOut & FormatNumero(TotalExento + TotalBase1 + TotalBase2 + TotalImpuesto1 + TotalImpuesto2, Empresa.MascaraMonetarios, 16) & " "
  sOut = sOut & FormatNumero(TotalExento, Empresa.MascaraMonetarios, 16) & " "
  If TotalBase1 <> 0 Then
    sOut = sOut & FormatNumero(TotalBase1, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(Alicuota1, "#0.00", 5) & " "
    sOut = sOut & FormatNumero(TotalImpuesto1, Empresa.MascaraMonetarios, 16) & " "
  Else
    sOut = sOut & FormatNumero(TotalBase2, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(Alicuota2, "#0.00", 5) & " "
    sOut = sOut & FormatNumero(TotalImpuesto2, Empresa.MascaraMonetarios, 16) & " "
  End If
  sOut = sOut & FormatNumero(TotalRetenido, Empresa.MascaraMonetarios, 16)
  fView.Add sOut
  
  If TotalBase1 <> 0 And TotalBase2 <> 0 Then
    sOut = Space(182)
    sOut = sOut & FormatNumero(TotalBase2, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(Alicuota2, "#0.00", 5) & " "
    sOut = sOut & FormatNumero(TotalImpuesto2, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
  End If

End Sub

Private Sub Encabezado()
  With fView
    If .Linea > 1 Then
      TirarTotales "VAN"
      .PageBreak
    End If
    .Add "Libro de Ventas"
    .Add Empresa.NombreEmpresa
    Dim v As Variant, i As Integer
    v = Convert2Lines(Empresa.Direccion, 40)
    For i = 1 To UBound(v)
      .Add CStr(v(i))
    Next
    .Add "RIF: " & Empresa.RIF
    .Add "NIT: " & Empresa.NIT
    .Add "Perido de Imposicion: " & Format(finic, "Short Date") & " al " & Format(ffinal, "Short Date")
    .Add String(AnchoReporte, "-")
    .Add "                                                                       Planilla                Numero      Nota de      Nota de   Tipo Nro. Factura Total de Compras  Ventas internas             Base % Ali                                                IVA"
    .Add " Nro.   Fecha    RIF          Nombre del Cliente                       Import.  Factura Nro.  Control  Debito Nro. Credito Nro. Trans.     Afectada   Incluyendo IVA      no gravadas        Imponible cuota     Impuesto IVA     IVA Retenido       Percibible"
    .Add String(AnchoReporte, "-")
    If .Pagina > 1 Then
      TirarTotales "VIENEN"
    End If
  End With
End Sub

Private Sub ImprimirLineaDetalle(item As CDocumentoFiscal)
Dim sOut As String
  If fView.Linea > fView.LineasPagina - 4 Then
    Encabezado
  End If
  NumeroOperacion = NumeroOperacion + 1
  With item
    sOut = FormatNumero(NumeroOperacion, "####0", 5) & " "                              ' = 6
    sOut = sOut & stFullLength(Format(item.Fecha, "Short Date"), 10) & " "              ' = 17
    sOut = sOut & stFullLength(.RifEntidad, 12) & " "                                   ' = 30
    sOut = sOut & stFullLength(.NombreEntidad, 40) & " "                                ' = 71
    sOut = sOut & stFullLength(PlanillaImportacion, 8) & " "                            ' = 80
    sOut = sOut & stFullLength(IIf(.TipoDocFiscal = "FCT", .Referencia, ""), 12) & " "  ' = 93
    sOut = sOut & Format(.NumeroControlInicial, "00000000") & " "                       ' = 102
    sOut = sOut & stRightAlign(IIf(.TipoDocFiscal = "NDB", .Referencia, ""), 12) & " "  ' = 115
    sOut = sOut & stRightAlign(IIf(.TipoDocFiscal = "NCR", .Referencia, ""), 12) & " "  ' = 128
    sOut = sOut & stFullLength(.TipoDocFiscal, 6) & " "                                 ' = 135
    sOut = sOut & stRightAlign(.FacturaRelacionada, 12) & " "                           ' = 148
    sOut = sOut & FormatNumero(.ValorTotal, Empresa.MascaraMonetarios, 16) & " "        ' = 165
    sOut = sOut & FormatNumero(.Exento, Empresa.MascaraMonetarios, 16) & " "            ' = 182
    If .Gravable1 <> 0 Then
      sOut = sOut & FormatNumero(.Gravable1, Empresa.MascaraMonetarios, 16) & " "       ' = 199
      sOut = sOut & FormatNumero(.Tasa1, "#0.00", 5) & " "                              ' = 205
      sOut = sOut & FormatNumero(.Impuesto1, Empresa.MascaraMonetarios, 16) & " "       ' = 222
      If .Gravable2 = 0 Then
        sOut = sOut & FormatNumero(.Retencion, Empresa.MascaraMonetarios, 16) & " "     ' = 239
      End If
    ElseIf .Gravable2 <> 0 Then
      sOut = sOut & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(.Tasa2, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.Impuesto2, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(.Retencion, Empresa.MascaraMonetarios, 16) & " "
    End If
    sOut = sOut & FormatNumero(.Impuesto1 + .Impuesto2 + .Retencion, Empresa.MascaraMonetarios, 16) ' = 255
    fView.Add sOut
    
    If .Gravable1 <> 0 And .Gravable2 <> 0 Then
      sOut = Space(182)
      sOut = sOut & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(.Tasa2, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.Impuesto2, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(.Retencion, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    
    Alicuota1 = .Tasa1: Alicuota2 = .Tasa2
    TotalBase1 = TotalBase1 + .Gravable1
    TotalBase2 = TotalBase2 + .Gravable2
    TotalExento = TotalExento + .Exento
    TotalImpuesto1 = TotalImpuesto1 + .Impuesto1
    TotalImpuesto2 = TotalImpuesto2 + .Impuesto2
    TotalRetenido = TotalRetenido + .Retencion
  End With

End Sub


Public Sub Go(Factoria As Object)
  Set mGlobales.Empresa = Factoria.CrearObjeto("Empresa")
  Set mGlobales.Database = Factoria.CrearObjeto("Database")
  finic = DateSerial(Year(Date), Month(Date), 1)
  ffinal = Date
  If GetRangoFechas(finic, ffinal, "Periodo a reportar") Then
    Dim rs As Recordset, Documento As New CDocumentoFiscal
    Set rs = Factoria.CrearObjeto("Database").Execute("SELECT * FROM DocumentosFiscales WHERE TipoEntidad = 'CLT' AND Fecha BETWEEN " & Factoria.FechaDB(finic) & " AND " & Factoria.FechaDB(ffinal) & " ORDER BY Fecha, Id")
    If Not rs.EOF Then
      Set fView = New lfQuickView
      fView.SetReportWidth AnchoReporte
      Encabezado
      Do While Not rs.EOF
        Documento.LoadInstance rs
        ImprimirLineaDetalle Documento
        rs.MoveNext
      Loop
      TirarTotales "TOTAL GENERAL"
      DisplayResumen
      fView.Show
    End If
  End If
End Sub


