VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDocumentoFiscal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public ID As Long
Public Fecha As Date
Public TipoDocFiscal As String
Public TipoDoc As String
Public NumeroDoc As Long
Public TipoEntidad As String
Public CodigoEntidad As String
Public RifEntidad As String
Public NombreEntidad As String
Public Referencia As String
Public NumeroControlInicial As Long
Public NumeroControlFinal As Long
Public FacturaRelacionada As String
Public Exento As Currency
Public Gravable1 As Currency
Public Tasa1 As Double
Public Gravable2 As Currency
Public Tasa2 As Double
Public Impuesto1 As Currency
Public Impuesto2 As Currency
Public Retencion As Currency
Public Relacionado As Currency

Private Function Debitos(Arg As Currency, Lado As Integer)
  If Sgn(Arg) = Sgn(Lado) Then
    Debitos = Abs(Arg)
  Else
    Debitos = 0
  End If
End Function

Private Function Creditos(Arg As Currency, Lado As Integer)
  If Sgn(Arg) = Sgn(Lado) Then
    Creditos = 0
  Else
    Creditos = Abs(Arg)
  End If
End Function


' -------------------------------------------------------------------
' Se le pasa un comprobante, y lo llena con la informacin pertinente
Public Sub FillComprobante(Empresa, Comprobante)
Dim LadoNormal As Integer, Valor As Currency
  If Me.TipoEntidad = "CLT" Then
    LadoNormal = -1
  Else
    LadoNormal = 1
  End If
  With Comprobante
    Valor = ValorImpuesto
    .AddDetalle Empresa.CuentaImpuesto1, _
      "IVA " & IIf(LadoNormal < 0, _
                  IIf(ValorImpuesto > 0, "cobrado", "anulado"), _
                  IIf(ValorImpuesto > 0, "pagado", "anulado")) & " en " & _
                  Me.TipoDocFiscal & " " & Me.Referencia, _
      Debitos(Valor, LadoNormal), Creditos(Valor, LadoNormal)
    If Retencion <> 0 Then
      .AddDetalle Empresa.CuentaImpuesto1, _
        IIf(LadoNormal < 0, _
                IIf(Retencion < 0, "IVA retenido por cliente en ", "Reversion de retencion en "), _
                IIf(Retencion < 0, "IVA retenido a proveedor en ", "Reversion de retencion en ")) & _
                Me.TipoDocFiscal & " " & Me.Referencia, _
        Debitos(Retencion, LadoNormal), Creditos(Retencion, LadoNormal)
    End If
  End With
End Sub

Public Function DBImpuestos() As Currency
Dim RetVal As Currency
  RetVal = 0
  Select Case TipoDocFiscal
  Case "FCT"  ' Factura
    If TipoEntidad = "PRV" Then RetVal = Abs(ValorImpuesto)
  Case "NDB"
    If TipoEntidad = "PRV" Then RetVal = Abs(ValorImpuesto)
  Case "NCR"
    If TipoEntidad = "CLT" Then RetVal = Abs(ValorImpuesto)
  End Select
  DBImpuestos = RetVal
End Function

Public Function CRImpuestos() As Currency
Dim RetVal As Currency
  RetVal = DBImpuestos
  If RetVal = 0 Then
    RetVal = Abs(ValorImpuesto)
  Else
    RetVal = 0
  End If
  CRImpuestos = RetVal
End Function

Public Function CRRetencion() As Currency
Dim RetVal As Currency
  RetVal = 0
  Select Case TipoDocFiscal
  Case "FCT"  ' Factura
    If TipoEntidad = "PRV" Then RetVal = Abs(Retencion)
  Case "NDB"
    If TipoEntidad = "PRV" Then RetVal = Abs(Retencion)
  Case "NCR"
    If TipoEntidad = "CLT" Then RetVal = Abs(Retencion)
  End Select
  CRRetencion = RetVal
End Function

Public Function DBRetencion() As Currency
Dim RetVal As Currency
  RetVal = CRRetencion
  If RetVal = 0 Then
    RetVal = Abs(Retencion)
  Else
    RetVal = 0
  End If
  DBRetencion = RetVal
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evDocumentoFiscal.vbs", sVarId, vRetVal)
  If bRetVal Then
      vRetBuffer = vRetVal
      sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(VarID, vBuffer, sBuffer) As Boolean
Dim RetVal As Boolean
  
  RetVal = False
  Select Case UCase(VarID)
    Case "CODIGO"
      vBuffer = CodigoEntidad
      sBuffer = CodigoEntidad
    Case "RIF"
      vBuffer = RifEntidad
      sBuffer = RifEntidad
    Case "NOMBRE"
      vBuffer = NombreEntidad
      sBuffer = NombreEntidad
    Case "FACTURA", "FACTURARELACIONADA"
      vBuffer = FacturaRelacionada
      sBuffer = FacturaRelacionada
    Case "FECHA"
      vBuffer = Fecha
      sBuffer = Format(Fecha, "Short Date")
    Case "MONTOBRUTO", "MONTO_BRUTO", "TOTAL", "MONTO_TOTAL"
      vBuffer = ValorTotal
      sBuffer = Format(ValorTotal, mGlobales.Empresa.MascaraMonetarios)
    Case "MONTOEXENTO", "EXENTO"
      vBuffer = Exento
      sBuffer = Format(Exento, mGlobales.Empresa.MascaraMonetarios)
    Case "MONTOGRAVABLE1", "GRAVABLE1"
      vBuffer = Gravable1
      sBuffer = Format(Gravable1, mGlobales.Empresa.MascaraMonetarios)
    Case "MONTOGRAVABLE2", "GRAVABLE2"
      vBuffer = Gravable2
      sBuffer = Format(Gravable2, mGlobales.Empresa.MascaraMonetarios)
    Case "PORCENTAJE1", "TASA1"
      vBuffer = Tasa1
      sBuffer = Format(Tasa1, "0.00")
      RetVal = True
    Case "PORCENTAJE2", "TASA2"
      vBuffer = Tasa2
      sBuffer = Format(Tasa2, "0.00")
      RetVal = True
    Case "IVA1"
      vBuffer = Impuesto1
      sBuffer = Format(Impuesto1, mGlobales.Empresa.MscaraMonetarios)
    Case "IVA2"
      vBuffer = Impuesto2
      sBuffer = Format(Impuesto2, mGlobales.Empresa.MscaraMonetarios)
    Case "IVA", "VALORIVA", "MONTOIVA", "IVATOTAL"
      vBuffer = Impuesto1 + Impuesto2
      sBuffer = Format(vBuffer, Empresa.MascaraMonetarios)
      RetVal = True
    Case "NUMEROCONTROL", "CONTROL"
      vBuffer = NumeroControlInicial
      sBuffer = Format(NumeroControlInicial, "0000000")
      RetVal = True
    Case "MONTORETENCION", "MONTORETENIDO", "RETENCION"
      vBuffer = Retencion
      sBuffer = Format(Retencion, Empresa.MascaraMonetarios)
      RetVal = True
  End Select

  If RetVal = False Then RetVal = ExtendEval(VarID, vBuffer, sBuffer)
  
  EvalVar = RetVal

End Function

Public Function ValorTotal() As Currency
  ValorTotal = Exento + Gravable1 + Gravable2 + Impuesto1 + Impuesto2
End Function

Public Function ValorImpuesto() As Currency
  ValorImpuesto = Impuesto1 + Impuesto2
End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As CDocumentoFiscal = Nothing)
Dim lpDest As CDocumentoFiscal
  Set lpDest = pDest
  If lpDest Is Nothing Then Set lpDest = Me
  With lpDest
    .ID = GetNumeroFromVariant(rs.Fields("Id").value)
    .Fecha = GetDateFromVariant(rs.Fields("Fecha").value)
    .TipoDocFiscal = GetStringFromVariant(rs.Fields("TipoDocFiscal").value)
    .TipoDoc = GetStringFromVariant(rs.Fields("TipoDoc").value)
    .NumeroDoc = GetNumeroFromVariant(rs.Fields("NumeroDoc").value)
    .TipoEntidad = GetStringFromVariant(rs.Fields("TipoEntidad").value)
    .CodigoEntidad = GetStringFromVariant(rs.Fields("CodigoEntidad").value)
    .Referencia = GetStringFromVariant(rs.Fields("Referencia").value)
    .NumeroControlInicial = GetNumeroFromVariant(rs.Fields("NumeroControlInicial").value)
    .NumeroControlFinal = GetNumeroFromVariant(rs.Fields("NumeroControlFinal").value)
    .FacturaRelacionada = GetStringFromVariant(rs.Fields("FacturaRelacionada").value)
    .Exento = GetNumeroFromVariant(rs.Fields("Exento").value)
    .Gravable1 = GetNumeroFromVariant(rs.Fields("Gravable1").value)
    .Tasa1 = GetNumeroFromVariant(rs.Fields("Tasa1").value)
    .Gravable2 = GetNumeroFromVariant(rs.Fields("Gravable2").value)
    .Tasa2 = GetNumeroFromVariant(rs.Fields("Tasa2").value)
    .Impuesto1 = GetNumeroFromVariant(rs.Fields("Impuesto1").value)
    .Impuesto2 = GetNumeroFromVariant(rs.Fields("Impuesto2").value)
    .Retencion = GetNumeroFromVariant(rs.Fields("Retencion").value)
    .NombreEntidad = GetStringFromVariant(rs.Fields("NombreEntidad").value)
    .RifEntidad = GetStringFromVariant(rs.Fields("RifEntidad").value)
    .Relacionado = GetNumeroFromVariant(rs.Fields("Relacionado").value)
  End With
End Sub

Public Sub Grabar(Optional Factoria As Object = Nothing)
Dim sQuery As String

  If Not Factoria Is Nothing Then
    Set mGlobales.Factoria = Factoria
    Set mGlobales.Database = Factoria.CrearObjeto("Database")
    Set dbHandle = mGlobales.Database
    Set mGlobales.Empresa = Factoria.CrearObjeto("Empresa")
  End If
  
  If Me.TipoEntidad = "PRV" And Me.TipoDoc = "RCM" Then
    sQuery = "SELECT id FROM DocumentosFiscales " & _
             "WHERE TipoDoc = 'RCM' " & _
             "AND CodigoEntidad = " & StringDB(Me.CodigoEntidad) & " " & _
             "AND Referencia = " & Factoria.StringDB(Me.Referencia)
    Dim rs As Recordset
    Set rs = dbHandle.Execute(sQuery)
    Dim DocID As Long
    If rs.EOF Then
      DocID = 0
    Else
      DocID = rs(0)
    End If
    Set rs = Nothing
    If DocID <> 0 Then
      sQuery = "UPDATE DocumentosFiscales SET " & _
               "Fecha = " & Factoria.FechaDB(Me.Fecha) & ", " & _
               "NumeroDoc = " & Factoria.NumeroDB(Me.NumeroDoc) & ", " & _
               "NumeroControlInicial = " & NumeroDB(NumeroControlInicial) & ", " & _
               "NumeroControlFinal = " & NumeroDB(NumeroControlFinal) & ", " & _
               "Exento = " & NumeroDB(Exento) & ", " & _
               "Gravable1 = " & NumeroDB(Gravable1) & ", " & _
               "Tasa1 = " & NumeroDB(Tasa1) & ", " & _
               "Gravable2 = " & NumeroDB(Gravable2) & ", " & _
               "Tasa2 = " & NumeroDB(Tasa2) & ", " & _
               "Impuesto1 = " & NumeroDB(Impuesto1) & ", " & _
               "Impuesto2 = " & NumeroDB(Impuesto2) & ", " & _
               "Retencion = " & NumeroDB(Retencion) & ", " & _
               "RifEntidad = " & StringDB(RifEntidad) & ", " & _
               "NombreEntidad = " & StringDB(NombreEntidad) & " " & _
               "WHERE Id = " & NumeroDB(DocID)
      dbHandle.Execute sQuery
      Exit Sub
    End If
  End If

  sQuery = "INSERT INTO DocumentosFiscales (Fecha, TipoDocFiscal, TipoDoc, NumeroDoc, TipoEntidad, CodigoEntidad, Referencia, NumeroControlInicial, " & _
           "NumeroControlFinal, FacturaRelacionada, Exento, Gravable1, Tasa1, Gravable2, Tasa2, Impuesto1, Impuesto2, Retencion, RifEntidad, " & _
           "NombreEntidad) VALUES ("
  sQuery = sQuery & FechaDB(Fecha) & ", "
  sQuery = sQuery & StringDB(TipoDocFiscal) & ", "
  sQuery = sQuery & StringDB(TipoDoc) & ", "
  sQuery = sQuery & NumeroDB(NumeroDoc) & ", "
  sQuery = sQuery & StringDB(TipoEntidad) & ", "
  sQuery = sQuery & StringDB(CodigoEntidad) & ", "
  sQuery = sQuery & StringDB(Referencia) & ", "
  sQuery = sQuery & NumeroDB(NumeroControlInicial) & ", "
  sQuery = sQuery & NumeroDB(NumeroControlFinal) & ", "
  sQuery = sQuery & StringDB(FacturaRelacionada) & ", "
  sQuery = sQuery & NumeroDB(Exento) & ", "
  sQuery = sQuery & NumeroDB(Gravable1) & ", "
  sQuery = sQuery & NumeroDB(Tasa1) & ", "
  sQuery = sQuery & NumeroDB(Gravable2) & ", "
  sQuery = sQuery & NumeroDB(Tasa2) & ", "
  sQuery = sQuery & NumeroDB(Impuesto1) & ", "
  sQuery = sQuery & NumeroDB(Impuesto2) & ", "
  sQuery = sQuery & NumeroDB(Retencion) & ", "
  sQuery = sQuery & StringDB(RifEntidad) & ", "
  sQuery = sQuery & StringDB(NombreEntidad) & ");"

  mGlobales.Database.Execute sQuery
  
  Set rs = Database.Execute("SELECT @@Identity")
  ID = GetNumeroFromVariant(rs(0))
  rs.Close
  If ID = 0 Then
    Err.Raise 10001, "CDocumentoFiscal::Grabar", "No se inserto el registro"
  End If

End Sub

Public Function LoadFromReferencia(Factoria As Object, db As Connection, TipoEntidad As String, CodigoEntidad As String, TipoDoc As String, Referencia As String) As Boolean
Dim Query As String, rs As Recordset, RetVal As Boolean
  Query = "SELECT * FROM DocumentosFiscales " & _
          "WHERE TipoEntidad = " & Factoria.StringDB(TipoEntidad) & " " & _
          "AND CodigoEntidad = " & Factoria.StringDB(CodigoEntidad) & " " & _
          "AND TipoDoc = " & Factoria.StringDB(TipoDoc) & " " & _
          "AND Referencia = " & Factoria.StringDB(Referencia)
  Set rs = db.Execute(Query)
  If Not rs.EOF Then
    LoadInstance rs
    RetVal = True
  Else
    RetVal = False
  End If
  rs.Close
  LoadFromReferencia = RetVal
End Function
