VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTiposCuentasPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"No"
Attribute VB_Ext_KEY = "Collection" ,"clsTiposCuentaPOS"
Attribute VB_Ext_KEY = "Member0" ,"clsTiposCuentaPOS"
Option Explicit

'local variable to hold collection
Private mCol As Collection

Public Property Get Item(vntIndexKey As Variant) As clsTiposCuentaPOS
Attribute Item.VB_UserMemId = 0
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
  
  On Error GoTo ErrHandler
  If VarType(vntIndexKey) = vbString Then
    If vntIndexKey = "" Then vntIndexKey = "*"
  End If
  Set Item = mCol(vntIndexKey)
  Exit Property

ErrHandler:
    If Err.Number = 5 Then
        Set Item = Nothing
        Exit Property
    End If
    
    On Error GoTo 0
    Resume

End Property

Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = mCol.Count
End Property

Public Property Get NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    'this property allows you to enumerate
    'this collection with the For...Each syntax
    Set NewEnum = mCol.[_NewEnum]
End Property


Private Sub Class_Initialize()
Dim rs As Recordset, pTipo As clsTiposCuentaPOS, isAsterix As Boolean

    'creates the collection when this class is created
    Set mCol = New Collection
    
    Set rs = dbHandle.OpenRecordset("SELECT * FROM TiposCuentaPOS", dbOpenForwardOnly)
    isAsterix = False
    Do While Not rs.EOF
        Set pTipo = New clsTiposCuentaPOS
        pTipo.Base = rs!Base
        pTipo.IndicePrecio = rs!IndicePrecio
        pTipo.Porcentaje = rs!Porcentaje
        pTipo.Prefijo = rs!Prefijo
        If pTipo.Prefijo = "*" Then isAsterix = True
        mCol.Add pTipo, pTipo.Prefijo
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing
    
    If Not isAsterix Then
        Set pTipo = New clsTiposCuentaPOS
        pTipo.Base = 0
        pTipo.IndicePrecio = 1
        pTipo.Porcentaje = 0
        pTipo.Prefijo = "*"
        mCol.Add pTipo, "*"
    End If

End Sub

Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
End Sub

Public Function FindPrefijo(lNumero As Long) As clsTiposCuentaPOS
Dim i As Integer, j As Integer, lGreatest As Long

    lGreatest = -1
    For i = 1 To mCol.Count
        If mCol.Item(i).Base < lNumero Then
            If mCol.Item(i).Base >= lGreatest Then
                lGreatest = mCol.Item(i).Base
                j = i
            End If
        End If
    Next
    
    Set FindPrefijo = mCol.Item(j)

End Function
