VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CSerialesRenglon"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public idRenglon As String
Public CodigoItem As String
Public SerialesProducto As Collection

Public Sub Load(istrTipoDoc As String, ByVal ilngNumDoc As Long, ByVal inRenglon As Integer)
Dim pDetalle As CSerialesProducto, sQry As String, rs As Recordset

  Set SerialesProducto = Nothing
  Set SerialesProducto = New Collection
  
  sQry = "SELECT * FROM serialesDetalles "
  sQry = sQry & "WHERE TipoDocumento = " & StringDB(istrTipoDoc) & " "
  sQry = sQry & "AND NumeroDocumento = " & NumeroDB(ilngNumDoc) & " "
  sQry = sQry & "AND Renglon = " & NumeroDB(inRenglon) & " "
  sQry = sQry & "ORDER BY CodigoItem, Serial"
  
  Set rs = dbHandle.Execute(sQry)
  
  If Not rs.EOF Then
    Set pDetalle = New CSerialesProducto
    pDetalle.CodigoItem = rs.Fields("CodigoItem")
    Do
      If rs.Fields("CodigoItem") <> pDetalle.CodigoItem Then
        SerialesProducto.Add pDetalle, pDetalle.CodigoItem
        Set pDetalle = Nothing: Set pDetalle = New CSerialesProducto
        pDetalle.CodigoItem = rs.Fields("CodigoItem")
      End If
      pDetalle.ColSeriales.Add GetStringFromVariant(rs.Fields("Serial")), GetStringFromVariant(rs.Fields("Serial"))
      rs.MoveNext
    Loop While Not rs.EOF
    SerialesProducto.Add pDetalle, pDetalle.CodigoItem
  End If
  
  rs.Close
  Set rs = Nothing

End Sub

Public Function SerialesArticulo(istrCodigoArticulo As String) As CSerialesProducto
Dim pRetSerial As CSerialesProducto

  On Error GoTo NoSuchItem
  Set pRetSerial = SerialesProducto.Item(istrCodigoArticulo)

ResumePoint:
  Set SerialesArticulo = pRetSerial
  Exit Function

NoSuchItem:

  Set pRetSerial = Nothing
  Resume ResumePoint

End Function

Public Sub AddSerialesArticulo(pSerialesItem As CSerialesProducto)
Dim pOriginal As CSerialesProducto
  
  Set pOriginal = SerialesArticulo(pSerialesItem.CodigoItem)
  If Not pOriginal Is Nothing Then
    SerialesProducto.Remove pOriginal.CodigoItem
  End If
  SerialesProducto.Add pSerialesItem, pSerialesItem.CodigoItem
  
End Sub

Public Sub AddSerial(CodigoItem As String, Serial As String)
Dim pOriginal As CSerialesProducto
  Set pOriginal = SerialesArticulo(CodigoItem)
  If pOriginal Is Nothing Then
    Set pOriginal = New CSerialesProducto
    pOriginal.CantidadRequerida = 1
    pOriginal.CodigoItem = CodigoItem
    pOriginal.ColSeriales.Add Serial
    SerialesProducto.Add pOriginal, CodigoItem
  Else
    pOriginal.CantidadRequerida = pOriginal.CantidadRequerida + 1
    pOriginal.ColSeriales.Add Serial
  End If
End Sub

Private Sub Class_Initialize()

  Set SerialesProducto = New Collection
  idRenglon = ""

End Sub

Public Function Validar(strCodigoItem As String, strTipoItem As String, dblQty As Double) As Boolean
Dim pInstancer As clsInstanciadorEntidad, _
    pComponente As clsComponenteItemVenta, _
    pItem As Object
Dim pItemInventario As clsItemInventario, _
    pSerialesArticulo As CSerialesProducto
Dim dblCantidadRequerida As Double

  Set pInstancer = New clsInstanciadorEntidad
  Set pItem = pInstancer.EntidadITEM(strTipoItem, strCodigoItem)
  Set pInstancer = Nothing
  
  For Each pComponente In pItem.Composicion
    Set pItemInventario = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
    If pItemInventario.UsaSeriales Then
      Set pSerialesArticulo = Me.SerialesArticulo(pItemInventario.Codigo)
      If pSerialesArticulo Is Nothing Then
        Validar = False
        Exit Function
      End If
      dblCantidadRequerida = dblQty * pComponente.Cantidad
      If dblCantidadRequerida <> pSerialesArticulo.ColSeriales.Count Then
        Validar = False
        Exit Function
      End If
    End If
  Next
  
  Set pItem = Nothing
  Set pItemInventario = Nothing
  
  Validar = True

End Function

Public Function ToStrings(ByVal inColWidth) As Variant
Dim v() As String, pSerialesP As CSerialesProducto
Dim sTemp As String, s2 As String, index As Integer, s3 As Variant

  ReDim v(0)
  If Me.SerialesProducto.Count = 0 Then
    ToStrings = v
    Exit Function
  End If
  
  If Me.SerialesProducto.Count = 1 Then
    s2 = ""
    index = 0
    Set pSerialesP = SerialesProducto.Item(1)
    For Each s3 In pSerialesP.ColSeriales
      If s2 <> "" Then
        s2 = s2 & ", "
        If Len(s2) + Len(s3) > inColWidth Then
          index = index + 1
          ReDim Preserve v(index)
          v(index) = s2
          s2 = s3
        Else
          s2 = s2 & s3
        End If
      Else
        s2 = s3
      End If
    Next
    index = index + 1
    ReDim Preserve v(index)
    v(index) = s2
  Else
    index = 0
    s2 = ""
    For Each pSerialesP In Me.SerialesProducto
      If s2 <> "" Then
        index = index + 1
        ReDim Preserve v(index)
        v(index) = s2
        s2 = ""
      End If
      s2 = pSerialesP.CodigoItem & ": "
      For Each s3 In pSerialesP.ColSeriales
        If Len(s2) + Len(s3) + 2 > inColWidth Then
          index = index + 1
          ReDim Preserve v(index)
          v(index) = s2
          s2 = s3
        Else
          s2 = s2 & s3 & ", "
        End If
      Next
    Next
    index = index + 1
    ReDim Preserve v(index)
    s2 = left(s2, Len(s2) - 2)  ' elimina ", " al final del ultimo
    v(index) = s2
  End If
  
  ToStrings = v

End Function
