VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CSerialesDocumento"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Estructura "en memoria", para almacenar los detalles de edicin

Public mSerialesRenglon As Collection
Private ProximoRenglon As Long

'Revierte el efecto de los renglones previamente almacenados Temporalmente,
'previo a la actualizacin del documento.
Public Sub Revertir(istTipoDocumento As String, ByVal ilngNumDoc As Long)
Dim pDetalle As clsDetalleSerial, pItem As clsDetalleSerial

  Set pDetalle = New clsDetalleSerial
  pDetalle.StartIteradorDocumento istTipoDocumento, ilngNumDoc
  Do
    Set pItem = pDetalle.NextDetalle
    If Not pItem Is Nothing Then
        pItem.Revertir
    End If
  Loop While Not pItem Is Nothing
  pDetalle.EndIterador
  Set pDetalle = Nothing

End Sub

' Devuelve el identificador del proximo renglon con seriales
Public Function LoadSerialesRenglon(istrCodigoItem As String, istrTipoDoc As String, ByVal ilngDocumento As Long, ByVal inRenglon As Integer) As String
Dim pSerialC As CSerialesRenglon
Dim sRetVal As String
    
    Set pSerialC = New CSerialesRenglon
    
    pSerialC.CodigoItem = istrCodigoItem
    pSerialC.Load istrTipoDoc, ilngDocumento, inRenglon
    If pSerialC.SerialesProducto.Count > 0 Then
        pSerialC.idRenglon = ClaveProximoRenglon
        Me.Add pSerialC
        sRetVal = pSerialC.idRenglon
    Else
        sRetVal = ""
    End If
    
    Set pSerialC = Nothing
    
    LoadSerialesRenglon = sRetVal

End Function

Public Function SerialesRenglon(strCodigo As String) As CSerialesRenglon
Dim pRetVal As CSerialesRenglon

    On Error GoTo NoSuchItem
    Set pRetVal = mSerialesRenglon.Item(strCodigo)

ResumePoint:
    Set SerialesRenglon = pRetVal
    Exit Function

NoSuchItem:
    Set pRetVal = Nothing
    Resume ResumePoint

End Function

Private Function ClaveProximoRenglon() As String

    ClaveProximoRenglon = Format(ProximoRenglon, "00000")
    ProximoRenglon = ProximoRenglon + 1

End Function

Public Sub Add(pRenglon As CSerialesRenglon)

    pRenglon.idRenglon = ClaveProximoRenglon
    mSerialesRenglon.Add pRenglon, pRenglon.idRenglon

End Sub

Public Sub Update(strClave As String, pRenglon As CSerialesRenglon)

    mSerialesRenglon.Remove strClave
    pRenglon.idRenglon = strClave
    mSerialesRenglon.Add pRenglon, pRenglon.idRenglon
    
End Sub

Private Sub Class_Initialize()

    Set mSerialesRenglon = New Collection
    ProximoRenglon = 1

End Sub

Private Sub Class_Terminate()

    Set mSerialesRenglon = Nothing

End Sub

Public Sub RemoveRenglon(istrIdRenglon As String)

    On Error Resume Next
    mSerialesRenglon.Remove istrIdRenglon
    Exit Sub

End Sub
