VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CRelacionIvaRetenido"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Currency, _
       Fecha As Date, _
       Operador As String, _
       AnhoFiscal As Integer, _
       Mes As Integer, _
       RifProveedor As String, _
       NombreProveedor As String

Public Function Load(iNumero As Currency) As Boolean
Dim rs As Recordset, s As String, retVal As Boolean
  s = "SELECT * FROM RelacionesIVARetenido WHERE NumeroRetencion = " & NumeroDB(iNumero)
  Set rs = dbHandle.Execute(s)
  If rs.EOF Then
    rs.Close
    s = "SELECT * FROM RelacionesIVARetenido WHERE Numero = " & NumeroDB(iNumero)
    On Error Resume Next
    Set rs = dbHandle.Execute(s)
    If Err.Number <> 0 Then
      Load = False
      Exit Function
    End If
  End If
  
  If Not rs.EOF Then
    retVal = True
    With Me
    .Numero = rs!NumeroRetencion
    .Fecha = rs!Fecha
    .Operador = rs!Operador
    .AnhoFiscal = rs!AnhoFiscal
    .Mes = rs!Mes
    .RifProveedor = rs!RifProveedor
    .NombreProveedor = rs!NombreProveedor
    End With
  End If
  rs.Close
  Load = retVal
End Function

Public Sub AgregarElemento(ID As Long)
  dbHandle.Execute "UPDATE IVARetenido SET Relacionado = " & NumeroDB(Numero) & " WHERE id = " & NumeroDB(ID)
End Sub

Public Sub StartProcess(iFecha As Date, iAnhoFiscal As Integer, iMes As Integer, iRifProveedor As String, iNombreProveedor As String)
Dim s As String, min As Currency, max As Currency, rs As Recordset
  Do
    min = iAnhoFiscal * 10000000000# + iMes * 100000000
    max = min + 99999999
    min = min + 1
    s = "SELECT Max(NumeroRetencion) FROM RelacionesIVARetenido WHERE NumeroRetencion BETWEEN " & NumeroDB(min) & " AND " & NumeroDB(max)
    Set rs = dbHandle.Execute(s)
    Numero = GetNumeroFromVariant(rs(0))
    rs.Close
    If Numero = 0 Then Numero = min Else Numero = Numero + 1
    On Error Resume Next
    s = "INSERT INTO RelacionesIVARetenido (NumeroRetencion, Fecha, Operador, AnhoFiscal, Mes, RifProveedor, NombreProveedor) VALUES ("
    s = s & NumeroDB(Numero) & ", "
    s = s & FechaDB(Date) & ", "
    s = s & StringDB(UsuarioActivo.Codigo) & ", "
    s = s & NumeroDB(iAnhoFiscal) & ", "
    s = s & NumeroDB(iMes) & ", "
    s = s & StringDB(iRifProveedor) & ", "
    s = s & StringDB(iNombreProveedor) & ")"
    dbHandle.Execute s
    If Err.Number Then
      If Err.Number = -2147467259 Or Err.Number = -2147217873 Then
        Numero = 0
      Else
        On Error GoTo 0
        Err.Raise Err.Number, Err.Source, Err.Description
      End If
    End If
    On Error GoTo 0
  Loop Until Numero <> 0
  Me.AnhoFiscal = iAnhoFiscal
  Me.Mes = iMes
  Me.RifProveedor = iRifProveedor
  Me.Fecha = Date
  Me.Operador = UsuarioActivo.Codigo
  Me.NombreProveedor = iNombreProveedor
End Sub

' ----------------------------------------------
' ISDOC:
' ----------------------------------------------

Public Function Detalles() As Collection
Dim rs As Recordset, retCol As New Collection, Retencion As CDocumentoFiscal

  Set rs = dbHandle.Execute("SELECT * FROM DocumentosFiscales WHERE Relacionado = " & NumeroDB(Me.Numero) & "ORDER BY Fecha, Id")
  Do While Not rs.EOF
    Set Retencion = New CDocumentoFiscal
    Retencion.LoadInstance rs
    retCol.Add Retencion
    rs.MoveNext
  Loop
  rs.Close
  Set Detalles = retCol

End Function

Public Property Get TipoEntidad() As String
  TipoEntidad = "RET"
End Property

Public Property Let TipoEntidad(value As String)
' no hace nada, pero debe estar aqu
End Property

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evRelacionRetenido.vbs", sVarId, vRetVal)
  If bRetVal Then
      vRetBuffer = vRetVal
      sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(VarID, vBuffer, sBuffer) As Boolean
Dim retVal As Boolean
  Select Case UCase(VarID)
    Case "NUMERO"
      retVal = True
      vBuffer = Me.Numero
      sBuffer = Format(Numero, "00000000000000")
    Case "FECHA"
      retVal = True
      vBuffer = Me.Fecha
      sBuffer = Format(vBuffer, "Short Date")
    Case "OPERADOR"
      retVal = True
      vBuffer = Me.Operador
      sBuffer = vBuffer
    Case "AO", "AO", "ANHO", "AOFISCAL", "AO_FISCAL"
      retVal = True
      vBuffer = AnhoFiscal
      sBuffer = Format(AnhoFiscal, "0000")
    Case "MES"
      retVal = True
      vBuffer = Mes
      sBuffer = Trim(CStr(Mes))
    Case "RIF", "RIFPROVEEDOR", "RIF_PROVEEDOR"
      retVal = True
      sBuffer = RifProveedor
      vBuffer = sBuffer
    Case "NOMBR", "NOMBRE_PROVEEDOR", "NOMBREPROVEEDOR"
      retVal = True
      sBuffer = NombreProveedor
      vBuffer = sBuffer
  End Select
  
  If retVal = False Then
    retVal = ExtendEval(VarID, vBuffer, sBuffer)
  End If
  
  If retVal = False Then
    retVal = Empresa.EvalVar(VarID, vBuffer, sBuffer)
  End If
  
  EvalVar = retVal
End Function

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
  Set cFormato = New CFormatoDocumento
  cFormato.SetDocumento Me, Not AutoPrint
  Set cFormato = Nothing
End Sub

Public Function NombreArchivoFormato() As String
  NombreArchivoFormato = DeterminarFormato("FormatoRelacionIVA", "FormatosRelacionIVA", BuildDataPath("FormatoRelacionIVA.txt", AppName), Me)
End Function

