VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CProcesarConteo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Sub ProcesarDiferencias(Contrapartida As String, Descripcion As String, Almacen As String, Fecha As String, Usuario As String, col As Collection)
  Dim inAjuste As clsAjuste
  Dim hayEntradas As Boolean, haySalidas As Boolean
  Dim pDetalle As clsExistenciaUbicacion, pExistencia As clsExistenciaUbicacion
  Dim isOk As Boolean, Dif As Double

  On Error GoTo ErrHandler

  If SetGlobalLock("MC_AJUSTE_DIF") Then
    Set inAjuste = New clsAjuste
    inAjuste.Tipo = False
    inAjuste.Contrapartida = Contrapartida
    inAjuste.Descripcion = Descripcion
    inAjuste.Almacen = Almacen
    inAjuste.FechaTransaccion = Fecha
    inAjuste.Operador = Usuario
    hayEntradas = False

    Set pExistencia = New clsExistenciaUbicacion

    isOk = inAjuste.StartProcess
    
    If isOk Then
      For Each pDetalle In col
        If Not AlmacenExUbic.Load(pExistencia, pDetalle.CodigoItem, inAjuste.Almacen, 0) Then
          pExistencia.m_Existencia = 0
        End If
        Dif = pDetalle.m_Existencia - pExistencia.m_Existencia
        
        If Abs(Dif) > 0.01 Then
          hayEntradas = True
          isOk = inAjuste.AddDetalle(pDetalle.CodigoItem, Dif)
        End If
        
        If Not isOk Then Exit For
      Next
    End If
    
    If isOk Then
      If hayEntradas Then
        inAjuste.Commit
      Else
        inAjuste.Abort
      End If
    End If
    
    FreeGlobalLock
  End If
' Actualizar existencias almacen

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  FreeGlobalLock
  ReportarError False, nErrN, sErrD, "frmPasarExistencia::ProcesarDiferencias"
  On Error GoTo 0
  Err.Raise nErrN, "ProcesarDiferencias", sErrD
End Sub
