VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CProcesadorOrden"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private pOrden As clsOrdenesCompra
Private colDetalles As Collection

Private Sub Class_Initialize()
    Set pOrden = New clsOrdenesCompra
    Set colDetalles = New Collection
End Sub

Private Sub Class_Terminate()
    Set pOrden = Nothing
    Set colDetalles = Nothing
    Screen.MousePointer = vbDefault
End Sub

Private Sub PasarDetalle(istrCodigo As String, istrDescripcion As String, istrPresentacion As String, idblCantidad As Double, ivmPrecioRequerido As Currency)
    pOrden.AddDetalle istrCodigo, istrDescripcion, istrPresentacion, idblCantidad, ivmPrecioRequerido
End Sub


' ****************************************
' * Funciones de interfaz con el cliente *
' ****************************************

Public Function StartProcess(ipOrden As clsOrdenesCompra, iqRows As Integer, isNew As Boolean) As Boolean
  If Not SetGlobalLock("CProcesadorOrden::StartProcess") Then
    StartProcess = False
    Exit Function
  End If
  Set pOrden = ipOrden
  StartProcess = True
End Function

Public Function AddDetalle(istrCodigo As String, istrDescripcion As String, istrPresentacion As String, idblCantidad As Double, ivmPrecioRequerido As Currency) As Boolean
Dim pDetalle As clsDetalleOrdenCompra, isOk As Boolean

    On Error GoTo ErrHandler

    isOk = True
    Set pDetalle = New clsDetalleOrdenCompra
    With pDetalle
    .CodigoItem = istrCodigo
    .Descripcion = istrDescripcion
    .Presentacion = istrPresentacion
    .Cantidad = idblCantidad
    .PrecioRequerido = ivmPrecioRequerido
    End With
    colDetalles.Add pDetalle
    
ResumePoint:
    Set pDetalle = Nothing
    AddDetalle = isOk
    
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, Err.Source & " desde CProcesadorOrden::AddDetalle"
    isOk = False
    Exit Function

End Function

Public Function TerminarProceso() As Boolean
Dim pDetalle As clsDetalleOrdenCompra, isOk As Boolean

    On Error GoTo ErrHandler
    
    isOk = True
    StartTransaction
    pOrden.StartProcess
    pOrden.Update
    For Each pDetalle In colDetalles
        pOrden.AddDetalle _
            pDetalle.CodigoItem, _
            pDetalle.Descripcion, _
            pDetalle.Presentacion, _
            pDetalle.Cantidad, _
            pDetalle.PrecioRequerido
    Next
    pOrden.EndProcess
    CommitTransaction
    ExecuteScript "postOrdenCompra.vbs", pOrden
    FreeGlobalLock
'    pOrden.ViewPrint True

ResumePoint:
    TerminarProceso = isOk
    Exit Function

ErrHandler:
Dim nErrN As Long, sErrDesc As String, sErrSource As String

    nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
    On Error Resume Next
    AbortTransaction
    FreeGlobalLock
    isOk = False
    ReportarError False, nErrN, sErrDesc, sErrSource & " en CProcesadorOrden::TerminarProceso"
    Resume ResumePoint

End Function
