VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CProcesadorNNEE"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private pNNEE As clsNNEE
Private bDespachar As Boolean, stAlmacen As String

Public Function StartProcess(ipNNEE As clsNNEE, iqRows As Integer, isNew As Boolean, Optional istrAlmacen As String = "") As Boolean
Dim isOk As Boolean

  If Not Almacenes.ValidarAlmacen(istrAlmacen) Then
    mAdvertencia "Cdigo de almacen invlido"
    StartProcess = False
    Exit Function
  End If
    
  stAlmacen = istrAlmacen

  Select Case MsgBox("Si procede con el despacho inmediato de esta nota, no podr modificarla directamente" & vbCrLf & "Desea despacharla de inmediato?", vbYesNoCancel + vbDefaultButton2, "Advertencia")
  Case vbYes
    bDespachar = True
  Case vbNo
    bDespachar = False
    stAlmacen = ""
  Case vbCancel
    StartProcess = False
    Exit Function
  End Select

  If Not SetGlobalLock("CProcesadorNNEE::StartProcess") Then
    StartProcess = False
    Exit Function
  End If
  
  Set pNNEE = ipNNEE
    
  Screen.MousePointer = vbHourglass
  isOk = True
  pNNEE.StartProcess stAlmacen

  On Error GoTo ErrHandler
  pNNEE.Update isNew

ResumePoint:
  StartProcess = isOk
  Exit Function

ErrHandler:
  FreeGlobalLock
  ReportarError False, Err.Number, Err.Description, Err.Source
  isOk = False
  Err.Clear
  Resume ResumePoint

End Function

Public Function AddDetalle(istrCodigo As String, istrDescripcion As String, istrUnidad As String, idblCantidad As Double, ivmPrecioLista As Currency, ivmPrecioUnitario As Currency, pSeriales As CSerialesRenglon) As Boolean
Dim lRetVal As Long, isOk As Boolean
Dim pSerial As clsSeriales, pSerialesP As CSerialesProducto, vSerial As Variant
    
    On Error GoTo ErrHandler
    
    lRetVal = pNNEE.AddDetalle(istrCodigo, istrDescripcion, istrUnidad, idblCantidad, ivmPrecioLista, ivmPrecioUnitario)
        
    If lRetVal Then
      isOk = True
      If Not pSeriales Is Nothing Then
        Set pSerial = New clsSeriales
        For Each pSerialesP In pSeriales.SerialesProducto
          For Each vSerial In pSerialesP.colSeriales
            isOk = pSerial.RegistrarSalida(pSerialesP.CodigoItem, CStr(vSerial), pNNEE.Numero, pNNEE.TipoEntidad, lRetVal, pNNEE.FechaTransaccion, False)
            If Not isOk Then Exit For
          Next
          If Not isOk Then Exit For
        Next
      End If
    Else
      isOk = False
    End If

ResumePoint:
    AddDetalle = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, Err.Source
    isOk = False
    Resume ResumePoint

End Function

Public Sub TerminarProceso()

    pNNEE.EndProcess
    If bDespachar Then
      pNNEE.Despachar stAlmacen
    End If
    Screen.MousePointer = vbDefault
    FreeGlobalLock

End Sub

Public Sub AbortarProceso()

    pNNEE.AbortProcess
    Screen.MousePointer = vbDefault
    FreeGlobalLock

End Sub

Private Sub Class_Initialize()

    Set pNNEE = New clsNNEE

End Sub

Private Sub Class_Terminate()

    Set pNNEE = Nothing

End Sub

Public Function ActualizarCotizaciones(pColPedidos As clsCotizacionesLista) As Boolean
Dim colItemsPedido As Collection
Dim pDetFact As clsNNEEDetalles
Dim dblToGo As Double
Dim pDetalleCotizacion As clsDetalleCotizacion
Dim pCotizacion As clsCotizacion
Dim colDetalles As Collection

    If pColPedidos.colPedidos.Count = 0 Then
        ActualizarCotizaciones = True
        Exit Function
    End If

    Set colDetalles = pNNEE.Detalles
    
    For Each pDetFact In colDetalles
        If pDetFact.CodigoItem <> "" Then
            dblToGo = pDetFact.Cantidad
            Set colItemsPedido = pColPedidos.RenglonesPedidoCodigo(pDetFact.CodigoItem, pDetFact.PrecioEfectivoUnitario)
            For Each pDetalleCotizacion In colItemsPedido
                pDetalleCotizacion.RegistrarEntrega dblToGo, pDetFact.PrecioEfectivoUnitario, pNNEE.TipoEntidad, pNNEE.Numero, pDetFact.Presentacion, pDetFact.FactorEmpaque, pNNEE.FechaTransaccion
                If dblToGo <= 0 Then Exit For
            Next
        End If
    Next

    For Each pCotizacion In pColPedidos.colPedidos
        pCotizacion.ActualizarStatus
    Next

    ActualizarCotizaciones = True

End Function

