VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CProcesadorFacturas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private mCreditoAplicable As Currency
Private TipoProceso As StatDespacho, _
        doAdmin As Boolean, _
        nDetalles As Long
Private Almacen As String, _
        Transporte As String
Private bAplicar As Boolean
Private vmFalta As Currency, _
        vmAplicar As Currency
Private vmIngresoTotal As Currency, _
        vmImpuesto As Currency, _
        vmPrecio As Currency
Private vmEfectivo As Currency, _
        vmVisa As Currency, _
        vmMaster As Currency, _
        vmOtrasTC As Currency, _
        vmTDebito As Currency, _
        vmCheques As Currency

Private fProgress As lfProgresoOperacion

Private pCliente As clsClientes
Private pComprobante As clsBufferComprobante
Private pDetalle As clsDetalleCuentaEntidad
Private pDoc As clsDocumentosISPC
Private colDocs As Collection
Private instFactura As clsFacturas
Private colDetalles As Collection   ' Coleccion de Detalles
Private colSeriales As CSerialesDocumento
Private SerialesDetalles As Collection
Private pColPedidos As clsCotizacionesLista

Private Sub Class_Terminate()
' Elimina todas las instancias
    Set colDocs = Nothing
    Set instFactura = Nothing
    Set colDetalles = Nothing
    Set colSeriales = Nothing
    Set pDetalle = Nothing
    Set pComprobante = Nothing
    Set pCliente = Nothing
    Set pDoc = Nothing
    Set SerialesDetalles = Nothing
    Set pColPedidos = Nothing
    If Not fProgress Is Nothing Then
        If fProgress.Visible Then
            fProgress.Hide
        End If
        Unload fProgress
        Set fProgress = Nothing
    End If
    
    On Error Resume Next    ' Por si acaso
    AbortTransaction        ' Si la transaccin no fue procesada, se aborta y listo!

End Sub

' Funciones Pblicas (interfaz original)

Public Function AddDetalle(sCodigo As String, _
                sDescripcion As String, _
                sUnidad As String, _
                dCantidad As Double, _
                vmPrecioLista As Currency, _
                vmPrecioUnitario As Currency, _
                Optional pSeriales As CSerialesRenglon = Nothing) As Boolean
Dim isOk As Boolean, pDetalle As clsDetallesFactura

    On Error GoTo ErrHandler
    
    isOk = True
    Set pDetalle = New clsDetallesFactura
    With pDetalle
    .CodigoItem = sCodigo
    .Descripcion = sDescripcion
    .Presentacion = sUnidad
    .Cantidad = dCantidad
    .PrecioLista = vmPrecioLista
    .PrecioVenta = vmPrecioUnitario
    End With
    
    colDetalles.Add pDetalle
    SerialesDetalles.Add pSeriales
    
ResumePoint:
    Set pDetalle = Nothing
    AddDetalle = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, Err.Source & " en CProcesadorFacturas::AddDetalle"
    isOk = False
    Resume ResumePoint

End Function


' A la salida de StartProcess deben cumplirse las siguientes condiciones:
'   1: instFactura se refiere a la factura a procesar
'   2: colSeriales se refiere a los seriales de la factura.
'   3: nDetalles es igual a la cantidad de detalles de la factura.
'   4: TipoProceso contiene el tipo de proceso del inventario (actualizar o diferir)
'   5: doAdmin indica si se deber realizar el proceso administrativo de la factura.
'   6: Cualesquiera reglas de congruencia entre TipoProceso y doAdmin sern respetadas.
'   7: instFactura.Impuesto1 contiene el impuesto verificado
'   8: Las variables adicionales (???) estarn correctamente condicionadas.

Public Function StartProcess(pFactura As clsFacturas, ByVal qDetalles As Long, Optional pSeriales As CSerialesDocumento = Nothing, Optional AceptarDiferidosInventario As Boolean = False) As Boolean
Dim f As fDefinirProcesoFactura, i As Integer, isOk As Boolean, bResult As Boolean

    On Error GoTo ErrHandler
    isOk = True

    Set instFactura = pFactura
    Set colSeriales = pSeriales
    nDetalles = qDetalles       ' Se almacenan los argumentos de entrada

    With instFactura            ' <<<<<<<<<<<<<<<
    
    If .ErrorValidacion Then
        StartProcess = False
        Exit Function
    End If

    vmPrecio = .PrecioEfectivo
    vmImpuesto = .Impuesto1 + .Impuesto2
    vmIngresoTotal = vmPrecio + vmImpuesto

    ' -------- DEFINIR PROCESO ------------
    Set f = New fDefinirProcesoFactura
        f.AceptarDiferidoInventario = AceptarDiferidosInventario
        f.numMontoIVA.Text = .Impuesto1 + .Impuesto2
        
        f.Show vbModal
    
        bResult = f.Result
        
        If bResult Then
            TipoProceso = f.TipoProcesoInventario
            doAdmin = f.bDoAdmin
            bAplicar = (f.chkAplicarCreditos.Value = vbChecked)
            instFactura.Impuesto1 = f.numMontoIVA.Value
            Almacen = f.cbxAlmacen.Text
            Transporte = "" ' f.cbxTransporte.Text
            If (.Condicion = "CONTADO") And Not doAdmin Then
                mAdvertencia "Las facturas de contado deben ser procesadas de inmediato"
                bResult = False
            End If
        End If  ' bResult
    Unload f
    Set f = Nothing
    ' -------- END DEFINIR PROCESO ----------
    If Not bResult Then
        StartProcess = False
        Exit Function ' Cancelado requerimiento de proceso...
    End If

    ' -------- INGRESO DE CAJA --------------
    ' Inicializa en Cero, por si acaso.
    vmEfectivo = 0
    vmVisa = 0
    vmMaster = 0
    vmOtrasTC = 0
    vmTDebito = 0
    vmCheques = 0

    ' Si se va a ejecutar el proceso administrativo ... porque si no no hay que hacer nada
    If doAdmin Then
    ' Calcular credito aplicable
        If bAplicar Then
            Set pCliente = New clsClientes
            If Not pCliente.Load(.CodigoCliente) Then
                mAdvertencia "CProcesadorFacturas::StartProcess: imposible leer cliente"
                StartProcess = False
                Exit Function
            End If
            mCreditoAplicable = Abs(pCliente.ValorCreditos)
            Set pCliente = Nothing
    
            If mCreditoAplicable > vmIngresoTotal Then
                mCreditoAplicable = vmIngresoTotal
            End If
        Else
            mCreditoAplicable = 0
        End If
        
        ' Si es una factura de contado, tomar los datos de caja
        If instFactura.Condicion = "CONTADO" Then
            Dim fIngCaja As frmIngresoCaja
            ' Si el saldo en crditos del cliente es mayor que el monto de la factura, tampoco hay nada que pedir...
            If mCreditoAplicable < vmIngresoTotal Then
                Set fIngCaja = New frmIngresoCaja
                fIngCaja.SetValores vmImpuesto, 0, vmPrecio
                fIngCaja.txNotasCredito.Value = mCreditoAplicable
        
                fIngCaja.Show vbModal
        
                If Not fIngCaja.Result Then
                    Unload fIngCaja
                    Set fIngCaja = Nothing
                    StartProcess = False
                    Exit Function
                End If
        
                vmEfectivo = fIngCaja.txEfectivo.Value
                vmVisa = fIngCaja.txTCVisa.Value
                vmMaster = fIngCaja.txTCMaster.Value
                vmOtrasTC = fIngCaja.txOtrasTC.Value
                vmTDebito = fIngCaja.txTDebito.Value
                vmCheques = fIngCaja.txCheques.Value
            
                Unload fIngCaja
                Set fIngCaja = Nothing
            End If
        End If
    End If  ' doAdmin
    End With                ' <<<<<<<<<<<<<<<<<<<<<<<<<<

    Set fProgress = New lfProgresoOperacion
    fProgress.Caption = "Procesando la Factura"
    fProgress.SetMax nDetalles
    fProgress.Reset
    fProgress.Show
    Set colDetalles = New Collection
    Set SerialesDetalles = New Collection


ResumePoint:
    StartProcess = isOk
    Exit Function
    
ErrHandler:
    ReportarError False, Err.Number, Err.Description, Err.Source & " desde CProcesadorFacuras::StartProcess"
    isOk = False
    If Not fProgress Is Nothing Then
        If fProgress.Visible Then
            fProgress.Hide
        End If
        Unload fProgress
        Set fProgress = Nothing
    End If
    Resume ResumePoint

End Function

Public Sub ActualizarCotizaciones(pListaCots As clsCotizacionesLista)
    Set pColPedidos = pListaCots
End Sub

Public Function TerminarProceso(doPrint As Boolean) As Boolean
Dim pDetalle As clsDetallesFactura, pSerial As CSerialesRenglon
Dim i As Long, isOk As Boolean, lDoc As clsDocumentosISPC
Dim pDetalleCE As clsDetalleCuentaEntidad
Dim bInTransaction As Boolean, bIsNew As Boolean

  isOk = True
  
  ' Inicia LA transaccion
  On Error GoTo ErrHandler
  
  StartTransaction

  ' Revertir efecto previo de seriales temporales
  If instFactura.Numero <> 0 Then
    bIsNew = False
    If Not colSeriales Is Nothing Then
      colSeriales.Revertir instFactura.TipoEntidad, instFactura.Numero
    End If
  Else
    bIsNew = True
  End If
  

  ' Inicio del proceso en s de la factura
  
  instFactura.StartProcess TipoProceso, doAdmin, Almacen, Transporte
  For i = 1 To colDetalles.Count
    Set pDetalle = colDetalles.Item(i)
    PasarDetalle pDetalle.CodigoItem, pDetalle.Descripcion, pDetalle.Presentacion, pDetalle.Cantidad, pDetalle.PrecioLista, pDetalle.PrecioVenta, SerialesDetalles.Item(i)
  Next
  
  instFactura.EndProcess False, fProgress
  
  Set pComprobante = instFactura.instComprobante

  If instFactura.Condicion = "CONTADO" And doAdmin Then
    ' Proceso del ingreso de caja...
    If mCreditoAplicable < vmIngresoTotal Then    ' JODER!! esta secuencia genera un comprobante independiente...
      With SesionActiva                           ' y este mdulo "cuenta con que no se procesar...
        .IniciarProcesoCobranza _
          instFactura.FechaTransaccion, _
          vmIngresoTotal - mCreditoAplicable, _
          vmEfectivo, _
          vmVisa, _
          vmMaster, _
          vmOtrasTC, _
          vmTDebito, _
          vmCheques                           ' Tremenda cagada!
        .PasarCobro instFactura.CodigoCliente, 0, "Factura " & instFactura.Referencia & ", cobro de contado.", vmIngresoTotal - mCreditoAplicable, 0, 0
        .CerrarProcesoCobranza
      End With
      pComprobante.AddDetalle Empresa.CuentaCaja, "Pago de contado. Fact. " & instFactura.Referencia, vmIngresoTotal - mCreditoAplicable, 0
    End If
    'Aplicar Notas de Crdito
    If mCreditoAplicable > 0 Then
      Set pCliente = New clsClientes
      pCliente.Load instFactura.CodigoCliente
      Set colDocs = AlmacenDocumentosISPC.DocumentosSQL("TipoEntidad = " & StringDB(pCliente.TipoEntidad) & " AND CodigoEntidad = " & StringDB(pCliente.Codigo) & " AND Saldo < 0 ORDER BY FechaDoc, Numero")
      vmFalta = mCreditoAplicable
      
      Set pDetalleCE = New clsDetalleCuentaEntidad
      For Each pDoc In colDocs
        vmAplicar = Abs(pDoc.Saldo)
        If vmAplicar > vmFalta Then vmAplicar = vmFalta
        pDetalleCE.Add pDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abonado a Fact." & instFactura.Referencia, vmAplicar, pComprobante
        vmFalta = vmFalta - vmAplicar
        If vmFalta <= 0 Then Exit For
      Next
      
      Set pDetalleCE = Nothing
      Set colDocs = Nothing
      Set pCliente = Nothing
      
      If vmFalta > 0 Then
        Err.Raise 10001, "self", "El credito asignado fue consumido"
      End If
    End If
  End If
      
  If instFactura.Condicion <> "CONTADO" And mCreditoAplicable > 0 Then
    Set lDoc = New clsDocumentosISPC
    If lDoc.LoadFromDocumento(instFactura.TipoEntidad, instFactura.Numero) Then
      Set pCliente = New clsClientes
      pCliente.Load instFactura.CodigoCliente
      Set colDocs = AlmacenDocumentosISPC.DocumentosSQL("TipoEntidad = " & StringDB(pCliente.TipoEntidad) & " AND CodigoEntidad = " & StringDB(pCliente.Codigo) & " AND Saldo < 0 ORDER BY FechaDoc, Numero")
      vmFalta = mCreditoAplicable

      Set pComprobante = New clsBufferComprobante
      Set pDetalleCE = New clsDetalleCuentaEntidad

      For Each pDoc In colDocs
        vmAplicar = Abs(pDoc.Saldo)
        If vmAplicar > vmFalta Then vmAplicar = vmFalta
        pDetalleCE.Add pDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abonado a Fact." & instFactura.Referencia, vmAplicar, pComprobante
        pDetalleCE.Add lDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abono de " & pDoc.Documento.Referencia, -vmAplicar, pComprobante
        vmFalta = vmFalta - vmAplicar
        If vmFalta <= 0 Then Exit For
      Next

      Set pDetalleCE = Nothing
      Set pDoc = Nothing
      Set colDocs = Nothing
      Set pCliente = Nothing
    End If
  End If
  pComprobante.Procesar
  Set pComprobante = Nothing
  PasarCotizaciones
  
  CommitTransaction

  If instFactura.Load(instFactura.Numero) Then
    ExecuteScript "postFactura.vbs", instFactura
    instFactura.ViewPrint doPrint
  End If
  
ResumePoint:
  CerrarFProgress
  TerminarProceso = isOk
  Exit Function

ErrHandler:
Dim nErrN As Long, sErrDesc As String, sErrSource As String

  nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
  SesionActiva.AbortProcesoCobranza
  instFactura.AbortProcess
  If bIsNew Then
    instFactura.Numero = 0
  End If
  On Error Resume Next
  AbortTransaction
  Err.Raise nErrN, "CProcesadorFacturas::TerminarProceso", sErrDesc
  isOk = False
  Resume ResumePoint

End Function

Private Sub CerrarFProgress()
    
    If Not fProgress Is Nothing Then
        If fProgress.Visible Then
            fProgress.Hide
        End If
        Unload fProgress
        Set fProgress = Nothing
    End If

End Sub

Private Sub PasarDetalle(sCodigo As String, _
                sDescripcion As String, _
                sUnidad As String, _
                dCantidad As Double, _
                vmPrecioLista As Currency, _
                vmPrecioUnitario As Currency, _
                Optional pSeriales As CSerialesRenglon = Nothing)
Dim NumDetalle As Integer, pSerial As clsSeriales, pSerialesP As CSerialesProducto, vSerial As Variant

    NumDetalle = instFactura.NextDetalle
    
    instFactura.AddDetalle sCodigo, sDescripcion, sUnidad, dCantidad, (vmPrecioLista), (vmPrecioUnitario), fProgress
    
    If Not pSeriales Is Nothing Then
        Set pSerial = New clsSeriales
        For Each pSerialesP In pSeriales.SerialesProducto
            For Each vSerial In pSerialesP.colSeriales
                pSerial.RegistrarSalida pSerialesP.CodigoItem, CStr(vSerial), instFactura.Numero, instFactura.TipoEntidad, instFactura.NextDetalle - 1, instFactura.FechaTransaccion, (instFactura.EstadoDespacho <> SD_FACTURA_ENTREGADA)
            Next
        Next
    End If

End Sub

Public Sub AbortarProceso()

    instFactura.AbortProcess
    lmdbHandle.AbortTransaction
    If Not fProgress Is Nothing Then
        fProgress.Cerrar
        Unload fProgress
        Set fProgress = Nothing
    End If

End Sub

Private Sub PasarCotizaciones()
Dim colItemsPedido As Collection
Dim pDetFact As clsDetallesFactura
Dim dblToGo As Double
Dim pDetalleCotizacion As clsDetalleCotizacion
Dim pCotizacion As clsCotizacion
Dim colDetalles As Collection

    If pColPedidos Is Nothing Then
        Exit Sub
    End If

    If pColPedidos.colPedidos.Count = 0 Then
        Exit Sub
    End If

    fProgress.Caption = "Actualizando Pedidos"
    Set colDetalles = instFactura.Detalles
    
    fProgress.Reset
    fProgress.SetMax colDetalles.Count
    
    For Each pDetFact In colDetalles
    
        fProgress.NextPoint

        If pDetFact.CodigoItem <> "" Then

            dblToGo = pDetFact.Cantidad
            Set colItemsPedido = pColPedidos.RenglonesPedidoCodigo(pDetFact.CodigoItem, pDetFact.PrecioEfectivoUnitario)
            
            For Each pDetalleCotizacion In colItemsPedido
            
                pDetalleCotizacion.RegistrarEntrega dblToGo, pDetFact.PrecioEfectivoUnitario, instFactura.TipoEntidad, instFactura.Numero, pDetFact.Presentacion, pDetFact.FactorEmpaque, instFactura.FechaTransaccion
                If dblToGo <= 0 Then Exit For

            Next
        
        End If
        
    Next

    For Each pCotizacion In pColPedidos.colPedidos

        pCotizacion.ActualizarStatus

    Next

End Sub

