VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CProcesadorFacturas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private mCreditoAplicable As Currency
Private TipoProceso As StatDespacho, _
        doAdmin As Boolean, _
        nDetalles As Long
Private Almacen As String, _
        Transporte As String
Private bAplicar As Boolean
Private vmFalta As Currency, _
        vmAplicar As Currency
Private vmIngresoTotal As Currency, _
        vmImpuesto As Currency, _
        vmPrecio As Currency
Public CIngreso As CIngresoCaja
Public pComprobante As clsBufferComprobante

Private fProgress As lfProgresoOperacion
Private Doc As CDocumentoFiscal
Private pCliente As clsClientes
Private pDetalle As clsDetalleCuentaEntidad
Private pDoc As clsDocumentosISPC
Private colDocs As Collection
Private instFactura As clsFacturas
Private colDetalles As Collection   ' Coleccion de Detalles
Private ColSeriales As CSerialesDocumento
Private SerialesDetalles As Collection
Private pColPedidos As clsCotizacionesLista
Private DescuentosExternos As Currency

Private Sub Class_Terminate()
' Elimina todas las instancias
  Set colDocs = Nothing
  Set instFactura = Nothing
  Set colDetalles = Nothing
  Set ColSeriales = Nothing
  Set pDetalle = Nothing
  Set pComprobante = Nothing
  Set pCliente = Nothing
  Set pDoc = Nothing
  Set SerialesDetalles = Nothing
  Set pColPedidos = Nothing
  If Not fProgress Is Nothing Then
    If fProgress.Visible Then
      fProgress.Hide
    End If
    Unload fProgress
    Set fProgress = Nothing
  End If
End Sub

' Funciones Pblicas (interfaz original)

Public Function AddDetalle(sCodigo As String, _
                sDescripcion As String, _
                sUnidad As String, _
                dCantidad As Double, _
                vmPrecioLista As Currency, _
                vmPrecioUnitario As Currency, _
                Optional pSeriales As CSerialesRenglon = Nothing) As Boolean
Dim isOk As Boolean, pDetalle As clsDetallesFactura

    isOk = True
    Set pDetalle = New clsDetallesFactura
    With pDetalle
    .CodigoItem = sCodigo
    .Descripcion = sDescripcion
    .Presentacion = sUnidad
    .Cantidad = dCantidad
    .PrecioLista = vmPrecioLista
    .PrecioVenta = vmPrecioUnitario
    End With
    
    colDetalles.Add pDetalle
    SerialesDetalles.Add pSeriales
    
    Set pDetalle = Nothing
    AddDetalle = isOk

End Function


' A la salida de StartProcess deben cumplirse las siguientes condiciones:
'   1: instFactura se refiere a la factura a procesar
'   2: colSeriales se refiere a los seriales de la factura.
'   3: nDetalles es igual a la cantidad de detalles de la factura.
'   4: TipoProceso contiene el tipo de proceso del inventario (actualizar o diferir)
'   5: doAdmin indica si se deber realizar el proceso administrativo de la factura.
'   6: Cualesquiera reglas de congruencia entre TipoProceso y doAdmin sern respetadas.
'   7: instFactura.Impuesto1 contiene el impuesto verificado
'   8: Las variables adicionales (???) estarn correctamente condicionadas.
' 05/04/2003: Se agreg 'Descuentos' con el fin *EXCLUSIVO* de permitir un ingreso de
'             caja por un monto inferior al monto de la factura.
Public Function StartProcess(pFactura As clsFacturas, ByVal qDetalles As Long, Optional pSeriales As CSerialesDocumento = Nothing, Optional AceptarDiferidosInventario As Boolean = False, Optional Descuentos As Currency = 0, Optional stAlmacen As String = "", Optional bProcesar As Boolean = True, Optional DocFis As CDocumentoFiscal = Nothing, Optional AplicarNotas As Boolean = False) As Boolean
Dim f As fDefinirProcesoFactura, i As Integer, isOk As Boolean, bResult As Boolean
Dim ret As Currency
        
  If Not DocFis Is Nothing Then ret = DocFis.Retencion Else ret = 0
  isOk = True

  Set instFactura = pFactura
  Set ColSeriales = pSeriales
  nDetalles = qDetalles       ' Se almacenan los argumentos de entrada

  With instFactura            ' <<<<<<<<<<<<<<<
    
    If .ErrorValidacion Then
      Err.Raise 10001 + vbObjectError, "CProcesadorFacturas:StarProcess", "Error de validacion"
      StartProcess = False
      Exit Function
    End If
    If Not DocFis Is Nothing Then
      DocFis.Fecha = .FechaTransaccion
    End If
    DescuentosExternos = Descuentos
    vmPrecio = .PrecioEfectivo
    vmImpuesto = .Impuesto1 + .Impuesto2
    vmIngresoTotal = vmPrecio + vmImpuesto
  
    ' -------- DEFINIR PROCESO ------------
    TipoProceso = SD_FACTURA_ABIERTA
    If bProcesar And Not AceptarDiferidosInventario Then TipoProceso = SD_FACTURA_ENTREGADA
    doAdmin = bProcesar
    bAplicar = AplicarNotas
    Almacen = stAlmacen
    Transporte = "" ' f.cbxTransporte.Text
    If (.Condicion = "CONTADO") And Not doAdmin Then
      mAdvertencia "Las facturas de contado deben ser procesadas de inmediato"
      bResult = False
    End If
    ' -------- END DEFINIR PROCESO ----------
  
    ' Si se va a ejecutar el proceso administrativo ... porque si no no hay que hacer nada
    If doAdmin Then
    ' Calcular credito aplicable
      If bAplicar Then
        Set pCliente = New clsClientes
        If Not pCliente.Load(.CodigoCliente) Then
          mAdvertencia "CProcesadorFacturas::StartProcess: imposible leer cliente"
          StartProcess = False
          Exit Function
        End If
        mCreditoAplicable = Abs(pCliente.ValorCreditos)
        Set pCliente = Nothing
  
        If mCreditoAplicable > (vmIngresoTotal + ret) Then
          mCreditoAplicable = vmIngresoTotal + ret
        End If
      Else
          mCreditoAplicable = 0
      End If
        
        ' Si es una factura de contado, tomar los datos de caja
      If instFactura.Condicion = "CONTADO" Then
        If mCreditoAplicable < vmIngresoTotal + ret Then
          Set CIngreso = ServiciosCaja.IngresoCaja(vmPrecio - Descuentos, vmImpuesto + ret, mCreditoAplicable, "Medios de pago")
          If CIngreso Is Nothing Then
            StartProcess = False
            Exit Function
          End If
        End If
      End If
    End If  ' doAdmin
  End With                ' <<<<<<<<<<<<<<<<<<<<<<<<<<

  Set fProgress = New lfProgresoOperacion
  fProgress.Caption = "Procesando la Factura"
  fProgress.SetMax nDetalles
  fProgress.Reset
  fProgress.Show
  Set colDetalles = New Collection
  Set SerialesDetalles = New Collection

  StartProcess = isOk

End Function

Public Sub ActualizarCotizaciones(pListaCots As clsCotizacionesLista)
    Set pColPedidos = pListaCots
End Sub

' =======================================================
' Devuelve la base para una determinada categoria de
' imuesto.
' =======================================================
Private Function BaseImponible(TipoImpuesto As String) As Currency
Dim pDetalle As clsDetallesFactura, Acumulador As Currency

  For Each pDetalle In colDetalles
    Dim Item As clsItemVenta
    If pDetalle.CodigoItem <> "" Then
      Set Item = AlmacenItemsVenta.ItemVenta(pDetalle.CodigoItem)
      If Item Is Nothing Then
        Err.Raise 10001, "CProcesadorVentas.BaseImponible", "Codigo " & pDetalle.CodigoItem & " no localizado durante proceso de retencion de IVA"
      End If
      If Item.TipoImpuesto1 = TipoImpuesto Then
        Acumulador = pDetalle.PrecioVenta * pDetalle.Cantidad * (1# - instFactura.Descuento1 / 100) * (1# - instFactura.Descuento2 / 100)
      End If
    End If
  Next
  BaseImponible = Acumulador
End Function

Public Function TerminarProceso(doPrint As Boolean, Optional doImprimir As Boolean = False, Optional inhibirComprobante As Boolean = False, Optional DocFis As CDocumentoFiscal = Nothing) As Boolean
Dim pDetalle As clsDetallesFactura, pSerial As CSerialesRenglon
Dim i As Long, isOk As Boolean, lDoc As clsDocumentosISPC
Dim pDetalleCE As clsDetalleCuentaEntidad, IvaRetenido As Currency
Dim bInTransaction As Boolean, bIsNew As Boolean

  On Error GoTo ErrHandler
  
  isOk = True

  ' Inicia LA transaccion
  If Not SetGlobalLock("CProcesadorFactura::TerminarProceso") Then
    TerminarProceso = False
    Exit Function
  End If

  StartTransaction

  IvaRetenido = 0
  If Not DocFis Is Nothing Then IvaRetenido = Abs(DocFis.Retencion)
  mCreditoAplicable = mCreditoAplicable + IvaRetenido
  ' Revertir efecto previo de seriales temporales
  If instFactura.Numero <> 0 Then
    bIsNew = False
    If Not ColSeriales Is Nothing Then
      ColSeriales.Revertir instFactura.TipoEntidad, instFactura.Numero
    End If
  Else
    bIsNew = True
  End If

  ' Inicio del proceso en s de la factura
  
  instFactura.StartProcess TipoProceso, doAdmin, Almacen, Transporte
  For i = 1 To colDetalles.Count
    Set pDetalle = colDetalles.Item(i)
    PasarDetalle pDetalle.CodigoItem, pDetalle.Descripcion, pDetalle.Presentacion, pDetalle.Cantidad, pDetalle.PrecioLista, pDetalle.PrecioVenta, SerialesDetalles.Item(i)
  Next
  
  If inhibirComprobante Then
    instFactura.instComprobante.SetError
  End If
  instFactura.EndProcess doPrint, fProgress, DocFis
  
  Set pComprobante = instFactura.instComprobante

  If instFactura.Condicion = "CONTADO" And doAdmin Then
    ' Proceso del ingreso de caja...
    If mCreditoAplicable < vmIngresoTotal Then    ' JODER!! esta secuencia genera un comprobante independiente...
      With SesionActiva                           ' y este mdulo "cuenta con que no se procesar...
        .IniciarProcesoCobranza _
          instFactura.FechaTransaccion, _
          vmIngresoTotal - mCreditoAplicable, _
          CIngreso.Efectivo, _
          CIngreso.TCVisa, _
          CIngreso.TCMaster, _
          CIngreso.OtrasTC, _
          CIngreso.TDebito, _
          CIngreso.Cheques, _
          CIngreso.TCAmex, _
          CIngreso.OtrosMedios

        .PasarCobro instFactura.CodigoCliente, 0, "Factura " & instFactura.Referencia & ", cobro de contado.", vmIngresoTotal - mCreditoAplicable, 0, 0
        .CerrarProcesoCobranza
        CIngreso.Save SesionActiva.SessionID, UsuarioActivo.Codigo, "FCT", instFactura.Numero, "CLT", instFactura.CodigoCliente, "Factura " & instFactura.Referencia, instFactura.FechaTransaccion
      End With
      pComprobante.AddDetalle Empresa.CuentaCaja, "Pago de contado. Fact. " & instFactura.Referencia, vmIngresoTotal - mCreditoAplicable, 0
    End If
    'Aplicar Notas de Crdito
    If mCreditoAplicable > 0 Then
      Set pCliente = New clsClientes
      pCliente.Load instFactura.CodigoCliente
      Set colDocs = AlmacenDocumentosISPC.DocumentosSQL("TipoEntidad = " & StringDB(pCliente.TipoEntidad) & " AND CodigoEntidad = " & StringDB(pCliente.Codigo) & " AND Saldo < 0 ORDER BY FechaDoc, Numero")
      vmFalta = mCreditoAplicable
      
      Set pDetalleCE = New clsDetalleCuentaEntidad
      For Each pDoc In colDocs
        vmAplicar = Abs(pDoc.Saldo)
        If vmAplicar > vmFalta Then vmAplicar = vmFalta
        pDetalleCE.Add pDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abonado a Fact." & instFactura.Referencia, vmAplicar, pComprobante
        vmFalta = vmFalta - vmAplicar
        If vmFalta <= 0 Then Exit For
      Next
      
      Set pDetalleCE = Nothing
      Set colDocs = Nothing
      Set pCliente = Nothing
      
      If vmFalta > 0 Then
        Err.Raise 10001, "self", "El credito asignado fue consumido"
      End If
    End If
  End If

  If instFactura.Condicion <> "CONTADO" And doAdmin Then
    
    If mCreditoAplicable > 0 Then
      Set lDoc = New clsDocumentosISPC
      If lDoc.LoadFromDocumento(instFactura.TipoEntidad, instFactura.Numero) Then
        Set pCliente = New clsClientes
        pCliente.Load instFactura.CodigoCliente
        Set colDocs = AlmacenDocumentosISPC.DocumentosSQL("TipoEntidad = " & StringDB(pCliente.TipoEntidad) & " AND CodigoEntidad = " & StringDB(pCliente.Codigo) & " AND Saldo < 0 ORDER BY FechaDoc, Numero")
        vmFalta = mCreditoAplicable
  
        Set pDetalleCE = New clsDetalleCuentaEntidad
  
        For Each pDoc In colDocs
          vmAplicar = Abs(pDoc.Saldo)
          If vmAplicar > vmFalta Then vmAplicar = vmFalta
          pDetalleCE.Add pDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abonado a Fact." & instFactura.Referencia, vmAplicar, pComprobante
          pDetalleCE.Add lDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abono de " & pDoc.ReferenciaDocumento, -vmAplicar, pComprobante
          vmFalta = vmFalta - vmAplicar
          If vmFalta <= 0 Then Exit For
        Next
  
        Set pDetalleCE = Nothing
        Set pDoc = Nothing
        Set colDocs = Nothing
        Set pCliente = Nothing
      End If
    End If
    
    If DescuentosExternos > 0 Then
    ' Genera una nota de crdito, y la aplica inmediatamente a la factura.
      Dim pNota As clsNotasDCCP
      Set pNota = New clsNotasDCCP

      pNota.StartProcess "CLT", instFactura.CodigoCliente, instFactura.FechaTransaccion, GetSetting("ClearLight", "Extensiones", "DescripcionDescuentoExterno", "Descuento externo en factura ") & instFactura.Referencia, -DescuentosExternos, False
      pNota.pComprobante.Transferir Me.pComprobante
      pNota.pComprobante.SetError
      pNota.EndProcess  ' Generada la nota por descuento.../comprobante transferido a comprobante de la factura.
      
      Set lDoc = New clsDocumentosISPC
      If lDoc.LoadFromDocumento(instFactura.TipoEntidad, instFactura.Numero) Then
        Set pCliente = New clsClientes
        pCliente.Load instFactura.CodigoCliente
        Set pDoc = New clsDocumentosISPC
        If pDoc.LoadFromDocumento(pNota.TipoEntidad, pNota.Numero) Then
          Set pDetalleCE = New clsDetalleCuentaEntidad
          pDetalleCE.Add pDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abonado a Fact." & instFactura.Referencia, DescuentosExternos, pComprobante
          pDetalleCE.Add lDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, instFactura.FechaTransaccion, "Abono de " & pDoc.ReferenciaDocumento, -DescuentosExternos, pComprobante
        End If
        Set pDoc = Nothing
      End If
      Set lDoc = Nothing
      Set pNota = Nothing
    End If
  End If
  pComprobante.Procesar
  Set pComprobante = Nothing
  PasarCotizaciones

  CommitTransaction
  
  If instFactura.Load(instFactura.Numero) Then
    ExecuteScript "postFactura.vbs", instFactura
'    If doPrint Then instFactura.ViewPrint doPrint
  End If

  FreeGlobalLock

  TerminarProceso = True
  Exit Function

ErrHandler:
Dim nErrN As Long, sErrDesc As String, sErrSource As String
  nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
  Err.Clear
  Err.Raise nErrN, "CProcesadorFacturas::TerminarProceso", sErrDesc
End Function

Private Sub CerrarFProgress()
  If Not fProgress Is Nothing Then
    If fProgress.Visible Then
      fProgress.Hide
    End If
    Unload fProgress
    Set fProgress = Nothing
  End If
End Sub

Private Sub PasarDetalle(sCodigo As String, _
                sDescripcion As String, _
                sUnidad As String, _
                dCantidad As Double, _
                vmPrecioLista As Currency, _
                vmPrecioUnitario As Currency, _
                Optional pSeriales As CSerialesRenglon = Nothing)
Dim NumDetalle As Integer, pSerial As clsSeriales, pSerialesP As CSerialesProducto, vSerial As Variant
  NumDetalle = instFactura.NextDetalle
  instFactura.AddDetalle sCodigo, sDescripcion, sUnidad, dCantidad, (vmPrecioLista), (vmPrecioUnitario), fProgress
  If Not pSeriales Is Nothing Then
    Set pSerial = New clsSeriales
    For Each pSerialesP In pSeriales.SerialesProducto
      For Each vSerial In pSerialesP.ColSeriales
        pSerial.RegistrarSalida pSerialesP.CodigoItem, CStr(vSerial), instFactura.Numero, instFactura.TipoEntidad, instFactura.NextDetalle - 1, instFactura.FechaTransaccion, (instFactura.EstadoDespacho <> SD_FACTURA_ENTREGADA)
      Next
    Next
  End If
End Sub

Public Sub AbortarProceso()
  instFactura.AbortProcess
  AbortTransaction
  If Not fProgress Is Nothing Then
    fProgress.Cerrar
    Unload fProgress
    Set fProgress = Nothing
  End If
  FreeGlobalLock
End Sub

Private Sub PasarCotizaciones()
Dim colItemsPedido As Collection
Dim pDetFact As clsDetallesFactura
Dim dblToGo As Double
Dim pDetalleCotizacion As clsDetalleCotizacion
Dim pCotizacion As clsCotizacion
Dim colDetalles As Collection

  If pColPedidos Is Nothing Then
    Exit Sub
  End If
  
  If pColPedidos.colPedidos.Count = 0 Then
    Exit Sub
  End If
  
  fProgress.Caption = "Actualizando Pedidos"
  Set colDetalles = instFactura.Detalles
  
  fProgress.Reset
  fProgress.SetMax colDetalles.Count
  
  For Each pDetFact In colDetalles
    fProgress.NextPoint
    If pDetFact.CodigoItem <> "" Then
      dblToGo = pDetFact.Cantidad
      Set colItemsPedido = pColPedidos.RenglonesPedidoCodigo(pDetFact.CodigoItem, pDetFact.PrecioEfectivoUnitario)
      For Each pDetalleCotizacion In colItemsPedido
        pDetalleCotizacion.RegistrarEntrega dblToGo, pDetFact.PrecioEfectivoUnitario, instFactura.TipoEntidad, instFactura.Numero, pDetFact.Presentacion, pDetFact.FactorEmpaque, instFactura.FechaTransaccion
        If dblToGo <= 0 Then Exit For
      Next
    End If
  Next
  
  For Each pCotizacion In pColPedidos.colPedidos
    pCotizacion.ActualizarStatus
  Next
  
End Sub

