VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CProcesadorDescuentoFacturas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Sub Go(MontoDescuento As Currency, laFactura As clsFacturas, DocFis As CDocumentoFiscal, RebajarComision As Boolean)
Dim DocFactura As New clsDocumentosISPC, DocNota As New clsDocumentosISPC
Dim NotaCredito As New clsNotasDCCP
Dim pComprobante As clsBufferComprobante

  If Not DocFactura.LoadFromDocumento(laFactura.TipoEntidad, laFactura.Numero) Then
    Err.Raise 10001, "CProcesadorDescuentoFacturas", "No se encuentra el DocISPC relacionado con la factura"
  End If
  With NotaCredito
    .StartProcess "CLT", laFactura.CodigoCliente, Date, "Descuento sobre factura " & laFactura.Referencia, -MontoDescuento, False
    Set pComprobante = .pComprobante
    .EndProcess DocFis
  End With
  If Not DocNota.LoadFromDocumento(NotaCredito.TipoEntidad, NotaCredito.Numero) Then
    Err.Raise 10001, "CProcesadorDescuentoFacturas", "No se encontro DocISPC relacionado con la Nota de Credito"
  End If
  DocFactura.AplicarDocumento DocNota, pComprobante
  If RebajarComision Then
    If laFactura.Comision > 0 Then
      Dim ComisionDescontada As Currency
      ComisionDescontada = laFactura.Comision * MontoDescuento / (laFactura.PrecioEfectivo + laFactura.Impuesto1 + laFactura.Impuesto2)
      Dim NotaVendedor As New clsNotasDCCP
      NotaVendedor.StartProcess "VND", laFactura.CodigoVendedor, Date, "Descuento en factura " & laFactura.Referencia, ComisionDescontada, False
      NotaVendedor.pComprobante.Transferir pComprobante
      pComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Comision revertida en descuento a factura " & laFactura.Referencia, 0, ComisionDescontada
    End If
  End If
  pComprobante.Procesar
  laFactura.DescuentosProntoPago = laFactura.DescuentosProntoPago + MontoDescuento
  dbHandle.Execute "UPDATE Facturas SET DescuentosProntoPAgo = DescuentosProntoPago + " & NumeroDB(MontoDescuento) & " " & _
    "WHERE Numero = " & NumeroDB(laFactura.Numero)
End Sub
