VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CProcesadorCotizacion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private pCotizacion As clsCotizacion

Public Function StartProcess(ipCotizacion As clsCotizacion, iqRows As Integer, isNew As Boolean) As Boolean
Dim isOk As Boolean
    
    Set pCotizacion = ipCotizacion
    Screen.MousePointer = vbHourglass
    isOk = True
    If Not SetGlobalLock("CProcesadorCotizacion::StartProcess") Then
      StartProcess = False
      Exit Function
    End If
    
    pCotizacion.StartProcess
    On Error GoTo ErrHandler
    pCotizacion.UpdateCotizacion pCotizacion, isNew

ResumePoint:
    StartProcess = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, Err.Source
    ReleaseGlobalLock
    isOk = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function AddDetalle(istrCodigo As String, istrDescripcion As String, istrUnidad As String, idblCantidad As Double, ivmPrecioLista As Currency, ivmPrecioUnitario As Currency) As Boolean
Dim isOk As Boolean

    On Error GoTo ErrHandler
    isOk = True
    pCotizacion.AddDetalle pCotizacion, istrCodigo, istrDescripcion, istrUnidad, idblCantidad, ivmPrecioLista, ivmPrecioUnitario

ResumePoint:
    AddDetalle = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, Err.Source
    isOk = False
    Resume ResumePoint

End Function

Public Sub TerminarProceso()

    pCotizacion.EndProcess
    Screen.MousePointer = vbDefault
    FreeGlobalLock
    ExecuteScript "postCotizacion.vbs", pCotizacion
'    pCotizacion.ViewPrint True

End Sub

Public Sub AbortarProceso()

    pCotizacion.AbortProcess
    FreeGlobalLock
    Screen.MousePointer = vbDefault

End Sub

Private Sub Class_Initialize()

    Set pCotizacion = New clsCotizacion

End Sub

Private Sub Class_Terminate()

    Set pCotizacion = Nothing

End Sub
