VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CProcesadorCompras"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Objetos Locales
    Private pComprobante As clsBufferComprobante
    Public instRecibo As clsReciboMercancia
    Private SerialesDocumento As CSerialesDocumento
    Private fProgress As lfProgresoOperacion
    Private vmNoInventario As Currency
    
' Variables locales para almacenar el contenido de la Forma de Definicin de Proceso
    Private _
        doAdmin As Boolean, _
        bEntregaInmediata As Boolean, _
        strAlmacen As String, _
        bDiferirCompleto As Boolean, _
        strCondiciones As String, _
        vmMontoIVA As Currency, _
        vmRecargos As Currency, _
        strContraRecargos As String, _
        bEfectivo As Boolean, _
        bCheque As Boolean, _
        strCodigoBanco As String, _
        strNumeroCheque As String, _
        dtFechaPresentacion As Date, _
        vmMontoPagado As Currency, _
        nDetalles As Long, _
        TipoProceso As StatDespacho
    Private NumeroControl As Long
    Private bRetenerIVA As Boolean
    Private MontoIVARetenido
  
' Colecciones para almacenar los detalles enviados desde la interfaz
    Private _
        colDetalles As Collection, _
        ColSeriales As Collection, _
        colOrdenes As clsOrdenesCompraLista
    Public DocumentoFiscal As CDocumentoFiscal
  
' ********************************
' * Funciones de Proceso Locales *
' ********************************

Private Sub PasarOrdenes()
Dim colItemsOrden As Collection
Dim pDetFact As clsDetallesCompra
Dim dblToGo As Double
Dim pDetalleOrden As clsDetalleOrdenCompra
Dim pOrden As clsOrdenesCompra
Dim colDetalles As Collection

    If colOrdenes Is Nothing Then Exit Sub
    
    If colOrdenes.colOrdenes.Count = 0 Then
        Exit Sub
    End If

    Set colDetalles = instRecibo.Detalles
    fProgress.Caption = "Actualizando Ordenes de Compra"
    fProgress.Reset
    fProgress.SetMax colDetalles.Count
    
    For Each pDetFact In colDetalles
        fProgress.NextPoint

        If pDetFact.CodigoItem <> "" Then
            dblToGo = pDetFact.Cantidad
            Set colItemsOrden = colOrdenes.RenglonesOrdenCodigo(pDetFact.CodigoItem, pDetFact.PrecioEfectivo)
            For Each pDetalleOrden In colItemsOrden
                pDetalleOrden.RegistrarEntrada dblToGo, pDetFact.PrecioEfectivo, instRecibo.TipoEntidad, instRecibo.Numero, pDetFact.Presentacion, pDetFact.FactorEmpaque, instRecibo.FechaTransaccion
                If dblToGo <= 0 Then Exit For
            Next
        End If
    Next

    For Each pOrden In colOrdenes.colOrdenes
        pOrden.ActualizarStatus
    Next

End Sub

Private Sub PasarRenglon(ipDetalle As clsDetallesCompra, SerialesRenglon As CSerialesRenglon)
Dim isOk As Boolean, NumDetalle As Integer, pSerial As clsSeriales, pSerialesP As CSerialesProducto, vSerial As Variant

  NumDetalle = instRecibo.NextDetalle
  
  instRecibo.AddDetalle ipDetalle.CodigoItem, ipDetalle.Descripcion, ipDetalle.Presentacion, ipDetalle.CantidadFacturada, ipDetalle.CantidadPromocion, ipDetalle.PrecioNominal, fProgress
  
  If Not SerialesRenglon Is Nothing Then
    Set pSerial = New clsSeriales
    For Each pSerialesP In SerialesRenglon.SerialesProducto
      For Each vSerial In pSerialesP.ColSeriales
        isOk = pSerial.RegistrarEntrada(pSerialesP.CodigoItem, CStr(vSerial), instRecibo.Numero, instRecibo.TipoEntidad, instRecibo.NextDetalle - 1, instRecibo.FechaTransaccion, (TipoProceso = 0))
        If Not isOk Then Exit For
      Next
      If Not isOk Then Exit For
    Next
    Set pSerial = Nothing
  End If

End Sub

' =======================================================
' Devuelve la base para una determinada categoria de
' imuesto.
' =======================================================
Private Function BaseImponible(TipoImpuesto As String) As Currency
Dim pDetalle As clsDetallesCompra, Acumulador As Currency
  For Each pDetalle In colDetalles
    Dim Item As clsItemInventario
    If pDetalle.CodigoItem <> "" Then
      Set Item = AlmacenItemsInventario.itemInventario(pDetalle.CodigoItem)
      If Item Is Nothing Then
        Err.Raise 10001, "CProcesadorCompras.BaseImponible", "Codigo " & pDetalle.CodigoItem & " no localizado durante proceso de retencion de IVA"
      End If
      If Item.claseImpuesto1 = TipoImpuesto Then
        Acumulador = pDetalle.PrecioNominal * pDetalle.CantidadFacturada * (1# - instRecibo.Descuento1 / 100) * (1# - instRecibo.Descuento2 / 100)
      End If
    End If
  Next
  BaseImponible = Acumulador
End Function


' ****************************************
' * Funciones de Interfaz con el Cliente *
' ****************************************

Public Function Terminar(DocFis As CDocumentoFiscal) As Boolean
Dim pBanco As clsBancos, vmDebitos As Currency, vmCreditos As Currency
Dim i As Long, isOk As Boolean, Retencion As Currency
Dim pDetalle As clsDetallesCompra, pSerial As CSerialesRenglon

  instRecibo.Impuesto1 = vmMontoIVA
  instRecibo.Condicion = strCondiciones

  Dim IVA1 As Currency, IVA2 As Currency, Exento As Currency
  Dim PRet1 As Double, PRet2 As Double, Base As Currency
  Dim prv As clsProveedores, rifProv As String
  Set prv = AlmacenProveedores.Proveedor(instRecibo.CodigoProveedor)

  Set fProgress = New lfProgresoOperacion
  fProgress.Caption = "Procesando la Compra"
  fProgress.SetMax nDetalles
  fProgress.ProgressBar1.value = 0
  fProgress.Show
  
  If Not SetGlobalLock("cProcesadorCompras") Then
    Terminar = False
    Exit Function
  End If

  On Error GoTo ErrHandler

  StartTransaction

  isOk = True

  ' 1.- Revertir informacion original sobre seriales
  If Not instRecibo.isNew Then
    If Not SerialesDocumento Is Nothing Then
      SerialesDocumento.Revertir instRecibo.TipoEntidad, instRecibo.Numero
    End If
  End If
  
  ' 2.- Iniciar el proceso.
  instRecibo.StartProcess TipoProceso, doAdmin, strAlmacen, vmRecargos, strContraRecargos, vmNoInventario
  Set pComprobante = instRecibo.instComprobante

  Dim CreditoRetencion As Currency
  If doAdmin And instRecibo.Condicion = "CONTADO" Then
    If bCheque Then
      Set pBanco = New clsBancos
      pBanco.Load strCodigoBanco
      pBanco.StartProcess
      pBanco.RegistrarMovimiento TMB_CHEQUE, instRecibo.FechaTransaccion, "Compra " & instRecibo.Referencia, instRecibo.NombreProveedor, vmMontoPagado, strNumeroCheque, dtFechaPresentacion, pComprobante
      pBanco.EndProcess
      Set pBanco = Nothing
    Else
      SesionActiva.RegistrarRetiro TR_PAGO, vmMontoPagado, "Pago de contado R.M. " & instRecibo.Referencia, Nothing, "PRV", instRecibo.CodigoProveedor, instRecibo.TipoEntidad, instRecibo.Numero
      pComprobante.AddDetalle Empresa.CuentaCaja, "Pago de contado R.M. " & instRecibo.Referencia, 0, vmMontoPagado
    End If

    ' Cancelar nota de debito originada en la retencion previa del IVA
    Retencion = 0: If Not DocFis Is Nothing Then Retencion = DocFis.Retencion
    If vmMontoPagado <> (instRecibo.CostoMercancia + instRecibo.Impuesto1 + vmNoInventario + Retencion) Then
      vmCreditos = instRecibo.CostoMercancia + instRecibo.Impuesto1 + vmNoInventario + Retencion - vmMontoPagado
      vmDebitos = 0
      If vmCreditos < 0 Then ' i.e. si se pago ms de lo establecido
        vmDebitos = -vmCreditos
        vmCreditos = 0
      End If
      pComprobante.AddDetalle Empresa.CuentaDescuentosPagos, "Diferencia en RM " & instRecibo.Referencia, vmDebitos, vmCreditos
    End If
  End If  ' Despachado proceso de contado

  For i = 1 To colDetalles.Count
    Set pDetalle = colDetalles.Item(i)
    Set pSerial = ColSeriales.Item(i)
    PasarRenglon pDetalle, pSerial
  Next

  PasarOrdenes

  instRecibo.EndProcess True, fProgress, DocFis

  CommitTransaction
  ExecuteScript "postCompra.vbs", instRecibo, False
'  instRecibo.ViewPrint False
  FreeGlobalLock

  
ResumePoint:
  Terminar = isOk
  Exit Function

ErrHandler:
Dim nErrN As Long, sErrDesc As String, sErrSource As String
 
  nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
  On Error Resume Next
  AbortTransaction
  On Error GoTo 0
  FreeGlobalLock
  isOk = False
  instRecibo.Numero = 0
  ReportarError False, nErrN, sErrDesc, sErrSource & " desde CProcesadorCompras::Terminar"
  Resume ResumePoint

End Function

Public Sub ActualizarOrdenes(pColOrdenes As clsOrdenesCompraLista)
    Set colOrdenes = pColOrdenes
End Sub

Public Function StartProcess(pRecibo As clsReciboMercancia, ByVal qDetalles As Long, pSeriales As CSerialesDocumento, ValorNoInventario As Currency, _
        iTipoProceso As StatDespacho, idoAdmin As Boolean, iEntregaInmediata As Boolean, istrAlmacen As String, istrCondiciones As String, _
        ivmRecargos As Currency, ivmMontoPagado As Currency, istrContraRecargos As String, iMedioPago As Boolean, iDocFis As CDocumentoFiscal, _
        Optional DatosPago As clsMovimientoBanco = Nothing) As Boolean
Dim isOk As Boolean
  isOk = True
  On Error GoTo ErrHandler

  Set instRecibo = pRecibo
  Set SerialesDocumento = pSeriales
  vmNoInventario = ValorNoInventario

  TipoProceso = iTipoProceso
  doAdmin = idoAdmin
  bEntregaInmediata = iEntregaInmediata
  strAlmacen = istrAlmacen
  bDiferirCompleto = (iTipoProceso <> SD_FACTURA_ENTREGADA) And (Not doAdmin)
  strCondiciones = istrCondiciones
  
  If Not iDocFis Is Nothing Then vmMontoIVA = iDocFis.ValorImpuesto Else vmMontoIVA = 0
  vmRecargos = ivmRecargos
  strContraRecargos = istrContraRecargos
  bEfectivo = iMedioPago
  bCheque = istrCondiciones = "CONTADO" And Not DatosPago Is Nothing
  If Not DatosPago Is Nothing Then
    strCodigoBanco = DatosPago.CodigoBanco
    strNumeroCheque = DatosPago.ReferenciaBanco
    dtFechaPresentacion = DatosPago.FechaEfectivo
  End If
  vmMontoPagado = ivmMontoPagado

  nDetalles = qDetalles
  Set colDetalles = New Collection
  Set ColSeriales = New Collection

ResumePoint:
  StartProcess = isOk
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "CProcesadorCompras::StartProcess"
  Set colDetalles = Nothing
  Set ColSeriales = Nothing
  isOk = False
  Resume ResumePoint

End Function

Public Function AddDetalle( _
    istrCodigoItem As String, _
    istrDescripcion As String, _
    istrUnidad As String, _
    ByVal dblCantidadFacturada As Double, _
    ByVal dblCantidadPromocion As Double, _
    ByVal vmPrecioUnitario As Currency, _
    SerialesRenglon As CSerialesRenglon) As Boolean
Dim pDetalle As clsDetallesCompra, isOk As Boolean

    On Error GoTo ErrHandler
    
    isOk = True

    Set pDetalle = New clsDetallesCompra
    With pDetalle
    .CodigoItem = istrCodigoItem
    .Descripcion = istrDescripcion
    .Presentacion = istrUnidad
    .CantidadFacturada = dblCantidadFacturada
    .CantidadPromocion = dblCantidadPromocion
    .PrecioNominal = vmPrecioUnitario   ' as ivmPrecio
    End With
    colDetalles.Add pDetalle
    Set pDetalle = Nothing
    ColSeriales.Add SerialesRenglon

ResumePoint:
    AddDetalle = isOk
    Exit Function
    
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "CProcesadorCompras::AddDetalle"
    isOk = False
    Resume ResumePoint

End Function

' ***********************
' * Eventos de la Clase *
' ***********************
Private Sub Class_Terminate()

    If Not fProgress Is Nothing Then
        If fProgress.Visible Then
          fProgress.Cerrar
        End If
        Unload fProgress
        Set fProgress = Nothing
    End If

    Set colOrdenes = Nothing
    Set colDetalles = Nothing
    Set ColSeriales = Nothing
    Set pComprobante = Nothing
    Set instRecibo = Nothing
    Set SerialesDocumento = Nothing

End Sub

