VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CProcesadorCobranza"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public pComprobante As clsBufferComprobante
Public Descripcion As String, FechaCobro As Date
Public PagoEfectivo As Boolean
Public ISLRPagado As Currency, DescuentosProntoPago As Currency, IvaRetenido As Currency, MontoPagoNeto As Currency
Public Detalles As Collection ' of DetalleCuentaEntidad ?
Public Conceptos As Collection
Public Cliente As clsClientes
Public ProcesadorCobro As clsProcesadorCobro
Public Banco As clsBancos
Public DiasDiferido As Integer, NumeroDeposito As String, MontoDeposito As Currency
Public CodigoVendedor As String, strDescripcionMB As String
Public Ingreso As CIngresoCaja

Private Sub Class_Initialize()
  Set Conceptos = New Collection
  ISLRPagado = 0: DescuentosProntoPago = 0: IvaRetenido = 0: MontoPagoNeto = 0
  Set ProcesadorCobro = New clsProcesadorCobro
End Sub

Private Sub Class_Terminate()
  Set ProcesadorCobro = Nothing
  Set Conceptos = Nothing
End Sub

Public Sub AddConcepto(Monto As Currency, NumeroDoc As Long)
Dim Doc As IngresoCaja.CDocsMovCaja, DocISPC As New clsDocumentosISPC
  Set Doc = New IngresoCaja.CDocsMovCaja
  If DocISPC.Load(NumeroDoc) Then
    With Doc
    .Debitos = Monto
    .Creditos = 0
    .NumeroDoc = DocISPC.NumeroDocumento
    .TipoDoc = DocISPC.TipoDocumento
    End With
    Conceptos.Add Doc
  End If
End Sub

Private Function IniciarProceso() As Boolean
  If Not SetGlobalLock("CProcesadorCobranza") Then
    IniciarProceso = False
    Exit Function
  End If
  StartTransaction ' << La transaccion y el lock global se manejan localmente
  IniciarProceso = True
End Function

Public Function IniciarProcesoEfectivo(iCliente As clsClientes, Fecha As Date, IngresoTotal As Currency, CIngreso As CIngresoCaja, iDescripcion As String, colDetalles As Collection, iCodVend As String) As Boolean
'->
  Set Cliente = iCliente
  Descripcion = iDescripcion
  FechaCobro = Fecha
  PagoEfectivo = True
  CodigoVendedor = iCodVend
  If Not IniciarProceso Then
    IniciarProcesoEfectivo = False
    Exit Function
  End If
  Set Ingreso = CIngreso
  On Error GoTo ErrHandler
  Set Detalles = colDetalles
  SesionActiva.IniciarProcesoCobranza Fecha, IngresoTotal, CIngreso.Efectivo, CIngreso.TCVisa, CIngreso.TCMaster, CIngreso.OtrasTC, CIngreso.TDebito, CIngreso.Cheques, CIngreso.TCAmex, CIngreso.OtrosMedios
  Set pComprobante = SesionActiva.pComprobante
  pComprobante.AddDetalle Empresa.CuentaCaja, Descripcion, IngresoTotal, 0
  IniciarProcesoEfectivo = True
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  AbortTransaction
  ReportarError False, nErrN, sErrD, "CProcesadorCobranza:IniciarProcesoEfectivo"
  IniciarProcesoEfectivo = False
End Function

Public Function IniciarProcesoDeposito(iCliente As clsClientes, iDescripcion As String, iCodVend As String, iBanco As clsBancos, _
        iNumeroDeposito As String, iDiasDiferido As Integer, iFecha As Date, iMontoDeposito As Currency, _
        DescripcionMB As String) As Boolean
'->
  If Not IniciarProceso Then
    IniciarProcesoDeposito = False
    Exit Function
  End If
  strDescripcionMB = DescripcionMB
  PagoEfectivo = False
  FechaCobro = iFecha
  Set Banco = iBanco
  NumeroDeposito = iNumeroDeposito
  MontoDeposito = iMontoDeposito
  DiasDiferido = iDiasDiferido
  Descripcion = iDescripcion
  Set Cliente = iCliente
  CodigoVendedor = iCodVend
  Set pComprobante = New clsBufferComprobante
  pComprobante.StartComprobante FechaCobro, Cliente.TipoEntidad & ":" & Cliente.Codigo, Descripcion
'  pComprobante.AddDetalle Banco.CGCuenta,Descripcion, MontoDeposito, 0
  IniciarProcesoDeposito = True
End Function

Public Function PasarDetalle(ByVal NumeroDocumento As Long, sTipoDocumento As String, ByVal montoPago As Currency, ByVal montoDescuento As Currency, ByVal MontoISLR As Currency, ByVal MontoIVARetenido As Currency) As Boolean
Dim retVal As Boolean

  On Error GoTo ErrHandler

  If PagoEfectivo Then
    retVal = SesionActiva.PasarCobro(Cliente.Codigo, NumeroDocumento, Descripcion, montoPago, montoDescuento, MontoISLR, MontoIVARetenido)
  Else
    retVal = ProcesadorCobro.PasarCobro(NumeroDocumento, Descripcion, montoPago, montoDescuento, MontoISLR, FechaCobro, pComprobante, MontoIVARetenido)
  End If
  
  If Not retVal Then
    Err.Raise 10001, "CProcesadorCobranza:PasarDetalle", "Error no interceptable desde 'PasarCobro'"
  End If
  
  ISLRPagado = ISLRPagado + MontoISLR
  DescuentosProntoPago = DescuentosProntoPago + montoDescuento
  IvaRetenido = IvaRetenido + MontoIVARetenido
  MontoPagoNeto = MontoPagoNeto + montoPago
  AddConcepto montoPago, NumeroDocumento

ResumePoint:
  PasarDetalle = retVal
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  AbortTransaction
  FreeGlobalLock
  If PagoEfectivo Then SesionActiva.AbortProcesoCobranza
  ReportarError False, nErrN, sErrD, "CProcesadorCobranza::PasarDetalle"
  retVal = False
  Resume ResumePoint
End Function

Public Function CerrarProceso() As Boolean
Dim bResult As Boolean
  
  On Error GoTo ErrHandler
  
  pComprobante.AddDetalle Empresa.CuentaISLRAnticipado, Descripcion, ISLRPagado, 0
  pComprobante.AddDetalle Empresa.CuentaDescuentosCobranza, "Descuentos a cliente " & Cliente.Codigo, DescuentosProntoPago, 0
  pComprobante.AddDetalle Empresa.CuentaImpuesto1, "IVA retenido por cliente " & Cliente.Codigo, IvaRetenido, 0
  
  If CodigoVendedor <> "" Then
    Dim pVendedor As clsVendedores
    Set pVendedor = AlmacenVendedores.Vendedor(CodigoVendedor)
    If pVendedor Is Nothing Then Err.Raise 10001, "CProcesadorCobranza:CerrarProceso", "Vendedor " & CodigoVendedor & " no localizado"
    If Not pVendedor.NoCobraComision Then
      Dim vmComisCobro As Currency
      vmComisCobro = MontoPagoNeto
      vmComisCobro = vmComisCobro * Empresa.ComisionCobranza(pVendedor.TipoComisionCobranza) / 100
      If vmComisCobro > 0.1 Then
        Dim cDetalle As clsDetalleCuentaEntidad
        Set cDetalle = New clsDetalleCuentaEntidad
        cDetalle.Add 0, pVendedor.Codigo, pVendedor.TipoEntidad, FechaCobro, "Comis.cobranza.clte.:" & Cliente.Codigo, -vmComisCobro, pComprobante
        pComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Comis.cobranza.clte.:" & Cliente.Codigo, vmComisCobro, 0
        Set cDetalle = Nothing
      End If
    End If
  End If
  
  If PagoEfectivo Then
    bResult = CerrarProcesoEfectivo
  Else
    bResult = CerrarProcesoDeposito
  End If

  CommitTransaction

ResumePoint:
  FreeGlobalLock
  CerrarProceso = bResult
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  AbortTransaction
  If PagoEfectivo Then SesionActiva.AbortProcesoCobranza
  ReportarError False, nErrN, sErrD, "CProcesadorCobranza::PasarDetalle"
  bResult = False
  Resume ResumePoint
End Function

Private Function CerrarProcesoEfectivo() As Boolean
Dim pDoc As IngresoCaja.CDocsMovCaja
  Ingreso.Save SesionActiva.SessionID, UsuarioActivo.Codigo, "", 0, Cliente.TipoEntidad, Cliente.Codigo, Descripcion, FechaCobro
  For Each pDoc In Conceptos
    Ingreso.AddConcepto pDoc.Debitos, pDoc.Creditos, pDoc.TipoDoc, pDoc.NumeroDoc
  Next
  SesionActiva.CerrarProcesoCobranza
  CerrarProcesoEfectivo = True
End Function
    
Private Function CerrarProcesoDeposito() As Boolean
  Banco.StartProcess
  Banco.RegistrarMovimiento _
      TMB_DEPOSITO, _
      FechaCobro, _
      strDescripcionMB, _
      "", _
      MontoDeposito, _
      NumeroDeposito, _
      FechaCobro + DiasDiferido, _
      pComprobante, _
      Conceptos

  If MontoDeposito > MontoPagoNeto Then
  Dim pNota As clsNotasDCCP
    Set pNota = New clsNotasDCCP
    pNota.StartProcess "CLT", Cliente.Codigo, FechaCobro, "Diferencia a su favor en pagos", MontoPagoNeto - MontoDeposito, False
    pNota.pComprobante.Transferir pComprobante
    pNota.pComprobante.SetError
    pNota.EndProcess
  End If
  Banco.EndProcess
  pComprobante.Procesar
  CerrarProcesoDeposito = True
End Function

