VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CMovimientoCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public TransID As Long ' Clave de referencia
Public Descripcion As String ' Descripcion o concepto del movimiento
Public Sesion As Long ' Identificacion de la sesion
Public Fecha As Date ' Fecha y hora de la operacion
Public Operador As String ' Codigo del Operador
Public Debitos As Currency ' Monto que Ingresa
Public Creditos As Currency ' Monto que Sale
Public TipoEntidad As String
Public CodigoEntidad As String
Public TipoDocumento As String
Public NumeroDocumento As Long

Public Function NombreEntidadRelacionada() As String
Dim p As Object, pInst As clsInstanciadorEntidad
Dim sRetVal As String

  Set pInst = New clsInstanciadorEntidad
  Set p = pInst.Entidad(TipoEntidad, CodigoEntidad)
  If p Is Nothing Then
    sRetVal = "N/A"
  Else
    sRetVal = p.Nombre
  End If
  Set p = Nothing
  Set pInst = Nothing
  NombreEntidadRelacionada = sRetVal

End Function

Private Sub LoadInstance(rs As Recordset, Optional pDest As CMovimientoCaja = Nothing)
Dim lpDest As CMovimientoCaja

  If pDest Is Nothing Then
    Set lpDest = Me
  Else
    Set lpDest = pDest
  End If

  With rs
  lpDest.TransID = GetNumeroFromVariant(.Fields("TransID"))
  lpDest.Descripcion = stGetStringFromVariant(.Fields("Descripcion"))
  lpDest.Sesion = GetNumeroFromVariant(.Fields("Sesion"))
  lpDest.Fecha = GetDateFromVariant(.Fields("Fecha"))
  lpDest.Operador = stGetStringFromVariant(.Fields("Operador"))
  lpDest.Debitos = GetNumeroFromVariant(.Fields("Debitos"))
  lpDest.Creditos = GetNumeroFromVariant(.Fields("Creditos"))
  lpDest.TipoEntidad = GetStringFromVariant(.Fields("TipoEntidad"))
  lpDest.CodigoEntidad = GetStringFromVariant(.Fields("CodigoEntidad"))
  lpDest.TipoDocumento = GetStringFromVariant(.Fields("TipoDocumento"))
  lpDest.NumeroDocumento = GetNumeroFromVariant(.Fields("NumeroDocumento"))
  lpDest.Descripcion = GetStringFromVariant(.Fields("Descripcion"))
  End With

End Sub

Public Function Load(iTransID As Long, Optional Destino As CMovimientoCaja = Nothing) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

  On Error GoTo ErrHandler

  sQuery = "SELECT * FROM MovimientosCaja WHERE TransID = " & NumeroDB(iTransID)
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    bRetVal = False
  Else
    bRetVal = True
    LoadInstance rs, Destino
  End If

ResumePoint:
  Set rs = Nothing
  Load = bRetVal
  Exit Function

ErrHandler:
  Err.Raise Err.Number, "CMovimientoCaja::Load", Err.Description
  bRetVal = False
  Err.Clear
  Resume ResumePoint

End Function

'---------------------------------------------------------------------------------------
' Function Save
' Fecha/Hora: 16/03/03 17:23
' Funcin   :
'---------------------------------------------------------------------------------------
'
Public Function Save(vmDebitos As Currency, vmCreditos As Currency, iTipoEntidad As String, iCodigoEntidad As String, iTipoDocumento As String, iNumeroDocumento As Long, iFecha As Date, Optional colDetalles As Collection = Nothing, Optional iDescripcion As String = "") As Boolean
Dim sQuery As String, bRetVal As Boolean, rs As Recordset
Dim pDetalle As CDetalleIngresoCaja

  On Error GoTo ErrHandler
  bRetVal = True
  sQuery = "INSERT INTO MovimientosCaja (Sesion, Fecha, Operador, Debitos, Creditos, TipoEntidad, CodigoEntidad, TipoDocumento, NumeroDocumento, Descripcion) VALUES ("
  sQuery = sQuery & NumeroDB(SesionActiva.SessionID) & ", "
  sQuery = sQuery & FechaDB(iFecha) & ", "
  sQuery = sQuery & StringDB(UsuarioActivo.Codigo) & ", "
  sQuery = sQuery & NumeroDB(vmDebitos) & ", "
  sQuery = sQuery & NumeroDB(vmCreditos) & ", "
  sQuery = sQuery & StringDB(iTipoEntidad) & ", "
  sQuery = sQuery & StringDB(iCodigoEntidad) & ", "
  sQuery = sQuery & StringDB(iTipoDocumento) & ", "
  sQuery = sQuery & NumeroDB(iNumeroDocumento) & ", "
  sQuery = sQuery & StringDB(iDescripcion) & ");"
  
  dbHandle.Execute sQuery

  sQuery = "SELECT @@IDENTITY As Numero FROM MovimientosCaja"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    rs.Close
    Set rs = Nothing
    Err.Raise 10001, "", "Falla obteniendo numero de insercion"
  Else
    Me.TransID = rs.Fields("Numero")
  End If
  rs.Close
  Set rs = Nothing
  
  If Not colDetalles Is Nothing Then
    For Each pDetalle In colDetalles
      sQuery = "INSERT INTO DetallesIngresoCaja (TransID, Medio, Emisor, Referencia, Clave, Monto) VALUES ("
      sQuery = sQuery & NumeroDB(Me.TransID) & ", "
      sQuery = sQuery & StringDB(pDetalle.Medio) & ", "
      sQuery = sQuery & StringDB(pDetalle.Emisor) & ", "
      sQuery = sQuery & StringDB(pDetalle.Referencia) & ", "
      sQuery = sQuery & StringDB(pDetalle.Clave) & ", "
      sQuery = sQuery & NumeroDB(pDetalle.Monto) & ");"
      dbHandle.Execute sQuery
    Next
  End If

ResumePoint:
  Save = bRetVal
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description
  ReportarError False, ErrN, ErrD, "CMovimientoCaja::Save"
  bRetVal = False
  Resume ResumePoint
End Function

'---------------------------------------------------------------------------------------
' Function AddConcepto
' Fecha/Hora: 27/03/03 10:24
' Funcin   : Los movimientos (ingresos) relacionados con varios documentos tienen
'             <TipoDocumento> en vbNullString y <NumeroDocumento> en 0.
'             Para poder establecer una relacin entre un movimiento de caja y varios
'             documentos, se agregan hoy los Conceptos, que establecen una relacin de
'             n<->n entre los documentos ISPC y los ingresos de caja.
'             Esta relacin se constituye en la clase CDocsMovCaja
'---------------------------------------------------------------------------------------
'
Public Function AddConcepto(vmDebitos As Currency, vmCreditos As Currency, TipoDoc As String, NumDoc As Long) As Boolean
Dim sQuery As String, bRetVal As Boolean

  On Error GoTo ErrHandler
  bRetVal = True
  sQuery = "INSERT INTO SubDocsMC (TransID, TipoDoc, NumDoc, Debitos, Creditos) VALUES ("
  sQuery = sQuery & NumeroDB(Me.TransID) & ", "
  sQuery = sQuery & StringDB(TipoDoc) & ", "
  sQuery = sQuery & NumeroDB(NumDoc) & ", "
  sQuery = sQuery & NumeroDB(vmDebitos) & ", "
  sQuery = sQuery & NumeroDB(vmCreditos) & ");"
  dbHandle.Execute sQuery

ResumePoint:
  AddConcepto = bRetVal
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description
  bRetVal = False
  ReportarError False, ErrN, ErrD, "CMovimientoCaja::AddConcepto"
  Resume ResumePoint

End Function

'---------------------------------------------------------------------------------------
' Function Conceptos
' Fecha/Hora: 27/03/03 10:41
' Funcin   : Devuelve los subconceptos asociados con un movimiento de caja.
'             si el movimiento no tiene subconceptos, devuelve los datos base del
'             propio movimiento.
'---------------------------------------------------------------------------------------
'
Public Function Conceptos() As Collection
Dim sQuery As String, rs As Recordset, retCol As Collection, pConcepto As CDocsMovCaja
  
  On Error GoTo ErrHandler
  sQuery = "SELECT * FROM subDocsMC WHERE TransID = " & NumeroDB(Me.TransID) & " ORDER BY ID"
  Set rs = dbHandle.Execute(sQuery)
  Set retCol = New Collection
  Do While Not rs.EOF
    Set pConcepto = New CDocsMovCaja
    With pConcepto
    .Creditos = GetNumeroFromVariant(rs.Fields("Creditos"))
    .Debitos = GetNumeroFromVariant(rs.Fields("Debitos"))
    .NumeroDoc = GetNumeroFromVariant(rs.Fields("NumDoc"))
    .TipoDoc = GetStringFromVariant(rs.Fields("TipoDoc"))
    .TransID = GetNumeroFromVariant(rs.Fields("TransID"))
    End With
    retCol.Add pConcepto
    rs.MoveNext
  Loop

  If retCol.Count = 0 Then
    Set pConcepto = New CDocsMovCaja
    With pConcepto
    .Creditos = Me.Creditos
    .Debitos = Me.Debitos
    .NumeroDoc = Me.NumeroDocumento
    .TipoDoc = Me.TipoDocumento
    .TransID = Me.TransID
    End With
    retCol.Add pConcepto
  End If
    
ResumePoint:
  Set pConcepto = Nothing
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  Set Conceptos = retCol
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description

  ReportarError False, ErrN, ErrD, "CMovimientoCaja::Conceptos"
  Set retCol = Nothing
  Resume ResumePoint

End Function

Public Function MediosPago() As Collection
Dim pDetalle As CDetalleIngresoCaja, rs As Recordset
Dim retCol As Collection

  Set rs = dbHandle.Execute("SELECT * FROM DetallesIngresoCaja WHERE TransID = " & NumeroDB(Me.TransID) & " ORDER BY Monto DESC")
  Set retCol = New Collection
  Do While Not rs.EOF
    Set pDetalle = New CDetalleIngresoCaja
    With pDetalle
    .TransID = GetNumeroFromVariant(rs!TransID)
    .Medio = GetStringFromVariant(rs!Medio)
    .Emisor = GetStringFromVariant(rs!Emisor)
    .Referencia = GetStringFromVariant(rs!Referencia)
    .Clave = GetStringFromVariant(rs!Clave)
    .Monto = GetNumeroFromVariant(rs!Monto)
    End With
    retCol.Add pDetalle
    rs.MoveNext
  Loop
  rs.Close
  Set rs = Nothing

  If retCol.Count = 0 Then
    If Me.Creditos > Me.Debitos Then
      Set pDetalle = New CDetalleIngresoCaja
      With pDetalle
      .TransID = Me.TransID
      .Medio = "EFE"
      .Emisor = ""
      .Referencia = ""
      .Clave = ""
      .Monto = Me.Debitos - Me.Creditos
      End With
      retCol.Add pDetalle
    End If
  End If

  Set MediosPago = retCol
  
End Function

