VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CMovimientoCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public TipoEntidad As String
Private Objeto As New CIngresoCaja

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Numero() As Long
  Numero = Objeto.TransID
End Function

Public Function Detalles() As Collection
  Set Detalles = Objeto.Detalles
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evMovCaja.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, pInstancer As clsInstanciadorEntidad, pAltInstance As Object
Dim sBuffer As String, vBuffer As Variant, pConcepto As CDocsMovCaja, pDocumento As Object

  With Objeto
    bRetVal = True
    Select Case UCase(Trim(sVarId))
    Case "NUMERO", "TRANSID"
      vRetBuffer = .TransID
      sRetString = Format(.TransID, "0000000")
    Case "DESCRIPCION", "CONCEPTO"
      vRetBuffer = .Descripcion
      sRetString = .Descripcion
    Case "FECHA"
      vRetBuffer = .Fecha
      sRetString = Format(vRetBuffer, "Short Date")
    Case "SESION", "IDESION", "SESSIONID"
      vRetBuffer = .Sesion
      sRetString = Format(.Sesion, "000000")
    Case "OPERADOR"
      vRetBuffer = .Operador
      sRetString = .Operador
    Case "DEBITOS", "INGRESO"
      vRetBuffer = .Debitos
      sRetString = Format(.Debitos, Empresa.MascaraMonetarios)
    Case "CREDITOS", "EGRESO"
      vRetBuffer = .Creditos
      sRetString = Format(.Creditos, Empresa.MascaraMonetarios)
    Case "MONTO", "VALOR"
      vRetBuffer = .Debitos - .Creditos
      sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
    Case "TIPOENTIDAD"
      vRetBuffer = .TipoEntidad
      sRetString = vRetBuffer
    Case "CODIGOENTIDAD"
      vRetBuffer = .CodigoEntidad
      sRetString = vRetBuffer
    Case "NOMBREENTIDAD"
      sRetString = .NombreEntidadRelacionada
      vRetBuffer = sRetString
    Case "DOCUMENTOS" ' Presentacion estndar.
      sRetString = ""
      For Each pConcepto In .Conceptos
  '     Referencia           Descripcion                                         Monto
  '     XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999.999,99
        If sRetString = "" Then
          ' "Encabezado"
          sRetString = String(78, "-") & vbCrLf
          sRetString = sRetString & "Referencia           Descripcion                                         Monto" & vbCrLf
          sRetString = sRetString & String(78, "-") & vbCrLf
        End If
        Set pDocumento = pConcepto.Documento
        If pDocumento Is Nothing Then
          sBuffer = stFullLength("N/A", 21) & stFullLength("No hay un documento relacionado", 41) & FormatNumero(pConcepto.Debitos - pConcepto.Creditos, Empresa.MascaraMonetarios, 16)
        Else
          sBuffer = stFullLength(pDocumento.Referencia, 21) & stFullLength(pDocumento.Concepto, 41) & FormatNumero(pConcepto.Debitos - pConcepto.Creditos, Empresa.MascaraMonetarios, 16)
        End If
        Set pDocumento = Nothing
        sRetString = sRetString & sBuffer & vbCrLf
      Next
      vRetBuffer = sRetString
    Case Else
      bRetVal = False
    End Select
  End With
  
  If Not bRetVal Then
    bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sRetString)
  End If

  If Not bRetVal Then
    Set pInstancer = New clsInstanciadorEntidad
    Set pAltInstance = pInstancer.Entidad(Objeto.TipoEntidad, Objeto.CodigoEntidad)
    If Not pAltInstance Is Nothing Then
      bRetVal = pAltInstance.EvalVar(sVarId, vBuffer, sBuffer)
      vRetBuffer = vBuffer
      sRetString = sBuffer
    End If
  End If

  If Not bRetVal Then
    Set pInstancer = New clsInstanciadorEntidad
    Set pAltInstance = pInstancer.EntidadDOCUMENTO(Objeto.TipoDocRel, Objeto.NumeroDocRel)
    If Not pAltInstance Is Nothing Then
      bRetVal = pAltInstance.EvalVar(sVarId, vBuffer, sBuffer)
      vRetBuffer = vBuffer
      sRetString = sBuffer
    End If
  End If

  Set pAltInstance = Nothing
  Set pInstancer = Nothing
  
  If Not bRetVal Then
    bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
  End If

  EvalVar = bRetVal

End Function

Public Function NombreArchivoFormato() As String
Dim s As String
  Select Case Objeto.TipoEntidad
  Case "CLT"
    If Objeto.NumeroDocRel = 0 Then
      s = "fmcCobros"
    Else
      If Objeto.Creditos > 0 Then
        s = "fmcPrestamoCLT"
      Else
        s = "fmcAdelantosCLT"
      End If
    End If
  Case "PRV"
    If Objeto.NumeroDocRel = 0 Then
      s = "fmcPagos"
    Else
      If Objeto.Creditos > 0 Then
        s = "fmcAdelantosPRV"
      Else
        s = "fmcPrestamoPRV"
      End If
    End If
  Case "VND"
    s = "fmcPagoVend"
  Case Else
    s = "fmcEgreso"
  End Select
  
  NombreArchivoFormato = DeterminarFormato("FormatoMovcaja", "FormatosMovscaja", BuildDataPath(s & ".txt", AppName), Me)
End Function

'---------------------------------------------------------------------------------------
' Function LoadFromDocumento
' Fecha/Hora: 12/04/03 21:21
' Funcin   : Permite cargar el documento de caja asociado con un documento.
'---------------------------------------------------------------------------------------
'
Public Function LoadFromDocumento(sTipoDoc As String, lNumeroDoc As Long) As Boolean
  LoadFromDocumento = Objeto.LoadFromDocumento(sTipoDoc, lNumeroDoc)
End Function

Public Function Load(iTransID As Long) As Boolean
  Load = Objeto.Load(iTransID)
End Function

'---------------------------------------------------------------------------------------
' Function Save
' Fecha/Hora: 16/03/03 17:23
' Funcin   :
'    >>>>>>>>>>>> Eliminada en revision del 20..6-2005 <<<<<<<<<<<<<<<<
'---------------------------------------------------------------------------------------
'---------------------------------------------------------------------------------------
' Function Conceptos
' Fecha/Hora: 27/03/03 10:41
' Funcin   : Devuelve los subconceptos asociados con un movimiento de caja.
'             si el movimiento no tiene subconceptos, devuelve los datos base del
'             propio movimiento.
'---------------------------------------------------------------------------------------
'
Public Function Conceptos() As Collection
  Set Conceptos = Objeto.Conceptos
End Function

Public Function MediosPago() As Collection
  Set MediosPago = Objeto.Detalles()
End Function

#If (Not IsNotMain) Or UsaMovsCaja Then
Public Sub Show()
Dim frmView As frmViewMovCaja

  Set frmView = New frmViewMovCaja
  frmView.SetItem Objeto
  ShowNonModal frmView
  Unload frmView
  Set frmView = Nothing

End Sub
#End If

Public Sub ViewPrint(Optional ByVal AutoPrint As Boolean = False)
Dim pFormater As CFormatoDocumento
  Set pFormater = New CFormatoDocumento
  pFormater.SetDocumento Me, Not AutoPrint
  Set pFormater = Nothing
End Sub

Private Sub Class_Initialize()
  TipoEntidad = "MVC"
End Sub
