VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CListaIvaRetProv"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Type Acumulador
  Exento As Currency
  Gravable1 As Currency
  IVA1 As Currency
  Gravable2 As Currency
  IVA2 As Currency
  Retenido As Currency
  Porcentaje1 As Double
  Porcentaje2 As Double
End Type

Private Type RegistroDatos
  NombreProveedor As String
  Fecha As Date
  NumeroFactura As String
  NumeroControl As Long
  NumeroRelacion As Currency
  Exento As Currency
  Gravable1 As Currency
  Tasa1 As Double
  IVA1 As Currency
  Gravable2 As Currency
  Tasa2 As Double
  IVA2 As Currency
  IvaRetenido As Currency
End Type

Private Const AnchoReporte = 104
Private Totales(1) As Acumulador, sTag As String, FechaInicio As Date, FechaFin As Date
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Private qRetenciones As Integer
Private Registro As RegistroDatos

' -----> Funciones generales <-----------
Private Sub CargarRegistro(rs As Recordset)
  With Registro
  .NombreProveedor = GetStringFromVariant(rs("NombreProveedor"))
  .NumeroFactura = GetStringFromVariant(rs("NumeroFactura"))
  .Fecha = GetDateFromVariant(rs("FechaCobro"))
  .NumeroControl = GetNumeroFromVariant(rs("NumeroControl"))
  .NumeroRelacion = GetNumeroFromVariant(rs("Relacionado"))
  .Exento = GetNumeroFromVariant(rs("MontoExento"))
  .Gravable1 = GetNumeroFromVariant(rs("MontoGravable1"))
  .Tasa1 = GetNumeroFromVariant(rs("Impuesto1"))
  .IVA1 = .Gravable1 / 100 * .Tasa1
  .Gravable2 = GetNumeroFromVariant(rs("MontoGravable2"))
  .Tasa2 = GetNumeroFromVariant(rs("Impuesto2"))
  .IVA2 = .Gravable2 / 100 * .Tasa2
  .IvaRetenido = GetNumeroFromVariant(rs("IvaRetenido"))
  End With
End Sub

Private Function LineasRequeridas() As Integer
Dim r As Integer
  If Registro.Exento <> 0 Then r = 1
  If Registro.Gravable1 <> 0 Then r = r + 1
  If Registro.Gravable2 <> 0 Then r = r + 1
  LineasRequeridas = r
End Function

Private Function LineasRequeridasTotal(index As Integer) As Integer
Dim r As Integer
  With Totales(index)
    If .Exento <> 0 Then r = r + 1
    If .Gravable1 <> 0 Then r = r + 1
    If .Gravable2 <> 0 Then r = r + 1
  End With
  LineasRequeridasTotal = r
End Function

' Encabezado POR PROVEEDOR
'--------------------------------------------------------------------------------------------------------
'Fecha      Factura       Control   Relacion No.            Monto  Tasa       Impuesto 1        Retencion
'--------------------------------------------------------------------------------------------------------
'99-99-9999 XXXXXXXXXXXX 99999999 99999999999999 9.999.999.999,99 99.99 9.999.999.999,99 9.999.999.999,99
'                                                9.999.999.999,99 99.99 9.999.999.999,99
'                                                --------------------------------------------------------
'TOTAL PROVEEDOR                                 9.999.999.999,99 99.99 9.999.999.999,99
'                                                9.999.999.999,99 99.99 9.999.999.999,99
'                                                --------------------------------------------------------
'                                                9.999.999.999,99       9.999.999.999.99 9.999.999.999,99

Private Sub EncabezadoProveedor()
Dim sOut As String

  If fView.Linea > 1 Then
    fView.PageBreak
  Else
    fView.SetReportWidth AnchoReporte
  End If

  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "Reporte de retenciones de IVA por proveedor", vbCenter
  fView.Add "Entre el " & Format(FechaInicio, "Short Date") & " y el " & Format(FechaFin, "Short Date"), vbCenter
  fView.Add ""
  fView.Add LineJustify(CLng(AnchoReporte), "Emision: " & Format(Now, "General Date"), "Operador: " & UsuarioActivo.Codigo & ".", "Pgina: " & Format(fView.Pagina, "0000"))
  fView.Add String(AnchoReporte, "-")
  fView.Add "Fecha      Factura       Control   Relacion No.            Monto  Tasa         Impuesto        Retencion"
  fView.Add String(AnchoReporte, "-")
  
End Sub

Private Sub TirarTotalProveedor(s As String)
Dim sOut As String
  If qRetenciones < 2 Then
    fView.Add ""
    Exit Sub
  End If
  Dim value As Currency, IVA As Currency, Percent As Double
  With Totales(0)
    If .Exento <> 0 Then
      sOut = stFullLength("TOTAL EXENTO", 48)
      value = .Exento
      Percent = 0
      IVA = 0
    ElseIf .Gravable1 <> 0 Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje1, "0.00"), 48)
      value = .Gravable1
      Percent = .Porcentaje1
      IVA = .IVA1
    Else
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje2, "0.00"), 48)
      value = .Gravable2
      Percent = .Porcentaje2
      IVA = .IVA2
    End If
    sOut = sOut & FormatNumero(value, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(Percent, "#0.00", 5) & " "
    sOut = sOut & FormatNumero(IVA, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
    If .Gravable1 <> 0 And .Exento <> 0 Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje1, "0.00"), 48)
      sOut = sOut & FormatNumero(.Gravable1, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(.Porcentaje1, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.IVA1, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    If .Gravable2 <> 0 And (.Exento <> 0 Or .Gravable1 <> 0) Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje2, "0.00"), 48)
      sOut = sOut & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(.Porcentaje2, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.IVA2, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    
    sOut = Space(48) & String(AnchoReporte - 48, "-")
    fView.Add sOut
    sOut = stFullLength(s, 48)
    sOut = sOut & FormatNumero(.Exento + .Gravable1 + .Gravable2, Empresa.MascaraMonetarios, 16) & "       "
    sOut = sOut & FormatNumero(.IVA1 + .IVA2, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(.Retenido, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
    fView.Add ""
  End With

End Sub

Private Sub TirarTotalGeneral()
Dim sOut As String
  Dim value As Currency, IVA As Currency, Percent As Double
  With Totales(1)
    If .Exento <> 0 Then
      sOut = stFullLength("TOTAL EXENTO", 48)
      value = .Exento
      Percent = 0
      IVA = 0
    ElseIf .Gravable1 <> 0 Then
      value = .Gravable1
      Percent = .Porcentaje1
      sOut = stFullLength("TOTAL GRAVABLE " & Format(Percent, "0.00"), 48)
      IVA = .IVA1
    Else
      value = .Gravable2
      Percent = .Porcentaje2
      sOut = stFullLength("TOTAL GRAVABLE " & Format(Percent, "0.00"), 48)
      IVA = .IVA2
    End If
    sOut = sOut & FormatNumero(value, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(Percent, "#0.00", 5) & " "
    sOut = sOut & FormatNumero(IVA, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
    If .Gravable1 <> 0 And .Exento <> 0 Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje1, "0.00"), 48)
      sOut = sOut & FormatNumero(.Gravable1, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(.Porcentaje1, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.IVA1, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    If .Gravable2 <> 0 And (.Exento <> 0 Or .Gravable1 <> 0) Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje1, "0.00"), 48)
      sOut = sOut & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(.Porcentaje2, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.IVA2, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    
    sOut = Space(48) & String(AnchoReporte - 48, "-")
    fView.Add sOut
    sOut = stFullLength("TOTALES GENERALES", 48)
    sOut = sOut & FormatNumero(.Exento + .Gravable1 + .Gravable2, Empresa.MascaraMonetarios, 16) & "       "
    sOut = sOut & FormatNumero(.IVA1 + .IVA2, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(.Retenido, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
  End With

End Sub

Private Sub ProcesarRuptura()
Dim sOut As String
  If sTag <> "" Then
    TirarTotalProveedor "TOTAL PROVEEDOR"
    With Totales(1)
      .Exento = .Exento + Totales(0).Exento: Totales(0).Exento = 0
      .Gravable1 = .Gravable1 + Totales(0).Gravable1: Totales(0).Gravable1 = 0
      .Gravable2 = .Gravable2 + Totales(0).Gravable2: Totales(0).Gravable2 = 0
      .IVA1 = .IVA1 + Totales(0).IVA1: Totales(0).IVA1 = 0
      .IVA2 = .IVA2 + Totales(0).IVA2: Totales(0).IVA2 = 0
      .Porcentaje1 = Totales(0).Porcentaje1
      .Porcentaje2 = Totales(0).Porcentaje2
      .Retenido = .Retenido + Totales(0).Retenido: Totales(0).Retenido = 0
      qRetenciones = 0
    End With
  End If
  sTag = Registro.NombreProveedor
  If sTag <> "" Then
    If fView.Linea > fView.LineasPagina - 4 Then
      EncabezadoProveedor
    End If
    fView.Add "PROVEEDOR: " & sTag
  End If
End Sub

Public Sub Generar(rs As Recordset, finic As Date, ffin As Date)
  sTag = "": FechaInicio = finic: FechaFin = ffin
  Set fView = New lfQuickView
  fView.SetNotify Me
  EncabezadoProveedor
  qRetenciones = 0
  Do While Not rs.EOF
    CargarRegistro rs
    rs.MoveNext
    With Registro
      If .NombreProveedor <> sTag Then
        ProcesarRuptura
      End If
      If LineasRequeridas + fView.Linea >= fView.LineasPagina Then
        TirarTotalProveedor "VAN"
        EncabezadoProveedor
        TirarTotalProveedor "VIENEN"
      End If
      ' Primera linea
      Dim sOut As String
      sOut = stFullLength(Format(.Fecha, "Short Date"), 10) & " "   ' 11
      sOut = sOut & stFullLength(.NumeroFactura, 12) & " "                 ' 13 = 24
      sOut = sOut & Format(.NumeroControl, "00000000") & " "        '  9 = 33
      sOut = sOut & IIf(.NumeroRelacion <> 0, Format(.NumeroRelacion, "00000000000000"), Space(14)) & " " ' 15 = 48
      Dim value As Currency, Percent As Double, IVA As Currency
      If .Exento <> 0 Then
        value = .Exento
        Percent = 0
        IVA = 0
      ElseIf .Gravable1 <> 0 Then
        value = .Gravable1
        Percent = .Tasa1
        IVA = .IVA1
      Else
        value = .Gravable2
        Percent = .Tasa2
        IVA = .IVA2
      End If
      sOut = sOut & FormatNumero(value, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(Percent, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(IVA, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(.IvaRetenido, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
      If .Gravable1 <> 0 And .Exento <> 0 Then
        sOut = Space(48)
        sOut = sOut & FormatNumero(.Gravable1, Empresa.MascaraMonetarios, 16) & " "
        sOut = sOut & FormatNumero(.Tasa1, "#0.00", 5) & " "
        sOut = sOut & FormatNumero(.IVA1, Empresa.MascaraMonetarios, 16)
        fView.Add sOut
      End If
      If .Gravable2 <> 0 And (.Exento <> 0 Or .Gravable1 <> 0) Then
        sOut = Space(48)
        sOut = sOut & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " "
        sOut = sOut & FormatNumero(.Tasa2, "#0.00", 5) & " "
        sOut = sOut & FormatNumero(.IVA2, Empresa.MascaraMonetarios, 16)
        fView.Add sOut
      End If

      With Totales(0)
        .Exento = .Exento + Registro.Exento
        .Gravable1 = .Gravable1 + Registro.Gravable1
        .Gravable2 = .Gravable2 + Registro.Gravable2
        .IVA1 = .IVA1 + Registro.IVA1
        .IVA2 = .IVA2 + Registro.IVA2
        .Porcentaje1 = Registro.Tasa1
        .Porcentaje2 = Registro.Tasa2
        .Retenido = .Retenido + Registro.IvaRetenido
        qRetenciones = qRetenciones + 1
      End With
    End With
  Loop
  Registro.NombreProveedor = ""
  ProcesarRuptura
  TirarTotalGeneral
  
  fView.Show
  
End Sub

Public Sub ReportClicked(ByVal strReportLine As String, ByVal nLinePos As Long)
Dim s As String, n As Currency, r As CRelacionIvaRetenido
  s = Mid(strReportLine, 35, 14)
  n = CCur(s)
  Set r = New CRelacionIvaRetenido
  If r.Load(n) Then r.ViewPrint False
End Sub
