VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CListaIvaRetCrono"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Type RegistroDatos
  NombreProveedor As String
  Fecha As Date
  NumeroFactura As String
  NumeroControl As Long
  NumeroRelacion As Currency
  Exento As Currency
  Gravable1 As Currency
  Tasa1 As Double
  IVA1 As Currency
  Gravable2 As Currency
  Tasa2 As Double
  IVA2 As Currency
  IvaRetenido As Currency
End Type

Private Type Acumulador
  Exento As Currency
  Gravable1 As Currency
  IVA1 As Currency
  Gravable2 As Currency
  IVA2 As Currency
  Retenido As Currency
  Porcentaje1 As Double
  Porcentaje2 As Double
End Type

Private Const AnchoReporte = 141
Private Totales As Acumulador, FechaInicio As Date, FechaFin As Date
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Private Registro As RegistroDatos

' -----> Funciones generales <-----------
Private Sub CargarRegistro(rs As Recordset)
  With Registro
  .NombreProveedor = GetStringFromVariant(rs("NombreProveedor"))
  .NumeroFactura = GetStringFromVariant(rs("NumeroFactura"))
  .Fecha = GetDateFromVariant(rs("FechaCobro"))
  .NumeroControl = GetNumeroFromVariant(rs("NumeroControl"))
  .NumeroRelacion = GetNumeroFromVariant(rs("Relacionado"))
  .Exento = GetNumeroFromVariant(rs("MontoExento"))
  .Gravable1 = GetNumeroFromVariant(rs("MontoGravable1"))
  .Tasa1 = GetNumeroFromVariant(rs("Impuesto1"))
  .IVA1 = .Gravable1 / 100 * .Tasa1
  .Gravable2 = GetNumeroFromVariant(rs("MontoGravable2"))
  .Tasa2 = GetNumeroFromVariant(rs("Impuesto2"))
  .IVA2 = .Gravable2 / 100 * .Tasa2
  .IvaRetenido = GetNumeroFromVariant(rs("IvaRetenido"))
  End With
End Sub


' ENCABEZADO Cronologico
'---------------------------------------------------------------------------------------------------------------------------------------------
'Proveedor                            Fecha      Factura       Control   Relacion No.            Monto  Tasa       Impuesto 1        Retencion
'---------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXX 99999999 99999999999999 9.999.999.999,99 99.99 9.999.999.999,99 9.999.999.999,99
'                                                                                     9.999.999.999,99 99.99 9.999.999.999,99 9.999.999.999,99
'                                                                                     --------------------------------------------------------
'TOTALES                                                                              9.999.999.999,99 99.99 9.999.999.999,99
'                                                                                     9.999.999.999,99 99.99 9.999.999.999,99
'                                                                                     --------------------------------------------------------
'                                                                                     9.999.999.999,99       9.999.999.999,99 9.999.999.999,99
Private Sub Encabezado()
  Dim sOut As String

  If fView.Linea > 1 Then
    fView.PageBreak
  End If

  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "Reporte cronologico de retenciones de IVA", vbCenter
  fView.Add "Entre el " & Format(FechaInicio, "Short Date") & " y el " & Format(FechaFin, "Short Date"), vbCenter
  fView.Add ""
  fView.Add LineJustify(CLng(AnchoReporte), "Emision: " & Format(Now, "General Date"), "Operador: " & UsuarioActivo.Codigo & ".", "Pgina: " & Format(fView.Pagina, "0000"))
  fView.Add String(AnchoReporte, "-")
  fView.Add "Proveedor                            Fecha      Factura       Control   Relacion No.            Monto  Tasa       Impuesto 1        Retencion"
  fView.Add String(AnchoReporte, "-")

End Sub

Private Sub TirarTotales()
Dim sOut As String
  Dim value As Currency, IVA As Currency, Percent As Double
  sOut = Space(85) & String(AnchoReporte - 85, "-")
  fView.Add sOut
  With Totales
    If .Exento <> 0 Then
      sOut = stFullLength("TOTAL EXENTO", 85)
      value = .Exento
      Percent = 0
      IVA = 0
    ElseIf .Gravable1 <> 0 Then
      value = .Gravable1
      Percent = .Porcentaje1
      sOut = stFullLength("TOTAL GRAVABLE " & Format(Percent, "0.00"), 85)
      IVA = .IVA1
    Else
      value = .Gravable2
      Percent = .Porcentaje2
      sOut = stFullLength("TOTAL GRAVABLE " & Format(Percent, "0.00"), 85)
      IVA = .IVA2
    End If
    sOut = sOut & FormatNumero(value, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(Percent, "#0.00", 5) & " "
    sOut = sOut & FormatNumero(IVA, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
    If .Gravable1 <> 0 And .Exento <> 0 Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje1, "0.00"), 85)
      sOut = sOut & FormatNumero(.Gravable1, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(.Porcentaje1, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.IVA1, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    If .Gravable2 <> 0 And (.Exento <> 0 Or .Gravable1 <> 0) Then
      sOut = stFullLength("TOTAL GRAVABLE " & Format(.Porcentaje1, "0.00"), 85)
      sOut = sOut & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " " & FormatNumero(.Porcentaje2, "#0.00", 5) & " "
      sOut = sOut & FormatNumero(.IVA2, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
    End If
    
    sOut = Space(85) & String(AnchoReporte - 85, "-")
    fView.Add sOut
    sOut = stFullLength("TOTALES GENERALES", 85)
    sOut = sOut & FormatNumero(.Exento + .Gravable1 + .Gravable2, Empresa.MascaraMonetarios, 16) & "       "
    sOut = sOut & FormatNumero(.IVA1 + .IVA2, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(.Retenido, Empresa.MascaraMonetarios, 16)
    fView.Add sOut
  End With

End Sub

Public Sub Generar(rs As Recordset, finic As Date, ffinal As Date)
  FechaInicio = finic: FechaFin = ffinal
  Set fView = New lfQuickView: fView.SetReportWidth AnchoReporte
  fView.SetNotify Me
  Encabezado
  Do While Not rs.EOF
    CargarRegistro rs
    rs.MoveNext
    If fView.Linea > fView.LineasPagina - 2 Then Encabezado
    Dim sOut As String
    sOut = stFullLength(Registro.NombreProveedor, 36) & " " ' 37
    sOut = sOut & stFullLength(Format(Registro.Fecha, "Short Date"), 10) & " "  ' + 11 = 48
    sOut = sOut & stFullLength(Registro.NumeroFactura, 12) & " "  ' + 13 = 61
    sOut = sOut & Format(Registro.NumeroControl, "00000000") & " " ' + 9 = 70
    sOut = sOut & IIf(Registro.NumeroRelacion <> 0, Format(Registro.NumeroRelacion, "00000000000000"), Space(14)) & " " ' + 15 = 85
    Dim value As Currency, Percent As Double, IVA As Currency
    With Registro
      If .Exento <> 0 Then
        value = .Exento
        Percent = 0
        IVA = 0
      ElseIf .Gravable1 <> 0 Then
        value = .Gravable1
        Percent = .Tasa1
        IVA = .IVA1
      Else
        value = .Gravable2
        Percent = .Tasa2
        IVA = .IVA2
      End If
      sOut = sOut & FormatNumero(value, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(Percent, "0.00", 5) & " "
      sOut = sOut & FormatNumero(IVA, Empresa.MascaraMonetarios, 16) & " "
      sOut = sOut & FormatNumero(Registro.IvaRetenido, Empresa.MascaraMonetarios, 16)
      fView.Add sOut
      
      If .Gravable1 <> 0 And .Exento <> 0 Then
        sOut = Space(85) & FormatNumero(.Gravable1, Empresa.MascaraMonetarios, 16) & " "
        sOut = sOut & FormatNumero(.Tasa1, "0.00", 5) & " "
        sOut = sOut & FormatNumero(.IVA1, Empresa.MascaraMonetarios, 16)
        fView.Add sOut
      End If
    
      If .Gravable2 <> 0 And (.Gravable1 <> 0 Or .Exento <> 0) Then
        sOut = Space(85) & FormatNumero(.Gravable2, Empresa.MascaraMonetarios, 16) & " "
        sOut = sOut & FormatNumero(.Tasa2, "0.00", 5) & " "
        sOut = sOut & FormatNumero(.IVA2, Empresa.MascaraMonetarios, 16)
        fView.Add sOut
      End If
      With Totales
        .Exento = .Exento + Registro.Exento
        .Gravable1 = .Gravable1 + Registro.Gravable1
        .Gravable2 = .Gravable2 + Registro.Gravable2
        .IVA1 = .IVA1 + Registro.IVA1
        .IVA2 = .IVA2 + Registro.IVA2
        .Porcentaje1 = Registro.Tasa1
        .Porcentaje2 = Registro.Tasa2
        .Retenido = .Retenido + Registro.IvaRetenido
      End With
    End With
  Loop
  TirarTotales
  fView.Show
End Sub

Public Sub ReportClicked(ByVal strReportLine As String, ByVal nLinePos As Long)
Dim s As String, n As Currency, r As CRelacionIvaRetenido
  s = Mid(strReportLine, 72, 14)
  n = CCur(s)
  Set r = New CRelacionIvaRetenido
  If r.Load(n) Then r.ViewPrint False
End Sub
