VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CListaIvaPagadoCE"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 78
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Private sCodigoCliente As String
Private sNombreCliente As String
Private stotBruto As Currency, sTotIVA As Currency, sTotRetenido As Currency
Private totBruto As Currency, TotIVA As Currency, totRetenido As Currency
Private finic As Date, ffinal As Date

Private Sub PasarLineaTotal(sTit As String, Bruto As Currency, IVA As Currency, Retenido As Currency)
Dim sOut As String
  sOut = stFullLength(sTit, 34) & FormatNumero(Bruto, Empresa.MascaraMonetarios, 14) & FormatNumero(IVA, Empresa.MascaraMonetarios, 15) & FormatNumero(Retenido, Empresa.MascaraMonetarios, 15)
  fView.Add sOut
End Sub

Private Sub Ruptura(sCodCli As String, sNombreCli As String)
  If sCodigoCliente <> "" Then
    PasarLineaTotal "TOTAL CLIENTE", stotBruto, sTotIVA, sTotRetenido
    totBruto = totBruto + stotBruto
    TotIVA = TotIVA + sTotIVA
    totRetenido = totRetenido + sTotRetenido
  End If
  
  stotBruto = 0: sTotIVA = 0: sTotRetenido = 0
  sCodigoCliente = sCodCli: sNombreCliente = sNombreCli
  
  If sCodCli <> "" Then
    If fView.Linea > fView.LineasPagina + 6 Then
      Encabezado
    End If
    
    fView.Add "Cliente: " & sNombreCliente & " (" & sCodigoCliente & ")"
  End If

End Sub

Private Sub PasarLinea(rs As Recordset)
Dim sOut As String

  If GetStringFromVariant(rs.Fields("CodigoCliente")) <> sCodigoCliente Then
    Ruptura GetStringFromVariant(rs.Fields("CodigoCliente")), GetStringFromVariant(rs.Fields("NombreCliente"))
  End If

  sOut = stFullLength(Format(GetDateFromVariant(rs.Fields("FechaCobro")), "Short Date"), 10) & " "
  sOut = sOut & stFullLength(GetStringFromVariant(rs.Fields("Serie")) & "-" & Format(GetNumeroFromVariant(rs.Fields("Correlativo")), "0000000"), 11) & " "
  sOut = sOut & stFullLength(Format(GetDateFromVariant(rs.Fields("FechaTransaccion")), "Short Date"), 10) & " "
  sOut = sOut & FormatNumero(GetNumeroFromVariant(rs.Fields("PrecioEfectivo")) + GetNumeroFromVariant(rs.Fields("Impuesto1")), Empresa.MascaraMonetarios, 14) & " "
  sOut = sOut & FormatNumero(GetNumeroFromVariant(rs.Fields("Impuesto1")), Empresa.MascaraMonetarios, 14) & " "
  sOut = sOut & FormatNumero(GetNumeroFromVariant(rs.Fields("MontoRetencion")), Empresa.MascaraMonetarios, 14) & " "
  
  If fView.Linea > fView.LineasPagina - 4 Then
    Encabezado
  End If

  fView.Add sOut
  stotBruto = stotBruto + GetNumeroFromVariant(rs.Fields("PrecioEfectivo")) + GetNumeroFromVariant(rs.Fields("Impuesto1"))
  sTotIVA = sTotIVA + GetNumeroFromVariant(rs.Fields("Impuesto1"))
  sTotRetenido = sTotRetenido + GetNumeroFromVariant(rs.Fields("MontoRetencion"))

End Sub

'Cliente: XXXXXXXXXXXXXXXXXXXX (xxxxxx)
'------------------------------------------------------------------------------
'Fecha Pago Factura     Fecha Fact    Monto Bruto         I.V.A. Monto Retenido
'------------------------------------------------------------------------------
'99-99-9999 xxx-0000000 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub Encabezado()

  If fView.Linea <> 1 Then
    If stotBruto > 0 Then
      PasarLineaTotal "VAN", stotBruto, sTotIVA, sTotRetenido
    End If
    fView.PageBreak
  End If
      
  fView.Add ""
  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "Relacin de IVA cancelado a Contribuyentes Especiales", vbCenter
  fView.Add "Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), vbCenter
  fView.Add ""

  fView.Add LineJustify(AnchoReporte, "Emision: " & Format(Now, "General Date"), "Operador: " & UsuarioActivo.Codigo & ".", "Pgina:" & Str(fView.Pagina))
  fView.Add String(AnchoReporte, "-")
  fView.Add "Fecha Pago Factura     Fecha Fact    Monto Bruto         I.V.A. Monto Retenido"
  fView.Add String(AnchoReporte, "-")
  
  If stotBruto <> 0 Then
    PasarLineaTotal "VIENEN", stotBruto, sTotIVA, sTotRetenido
    fView.Add "Cliente: " & sNombreCliente & " (" & sCodigoCliente & ") [continuacion]"
  End If
      
End Sub

Public Sub Go()
Dim f As frmFiltroFacturas, sQuery As String
Dim sFiltroClientes As String
  
  Set f = New frmFiltroFacturas
  f.DisableSelectSeries
  f.DisableSelectVendedor
  ShowNonModal f
  If f.Result = False Then
    Unload f
    Exit Sub
  End If

  sFiltroClientes = f.ucCriteriosCliente1.FiltroSQL("Clientes")
  finic = f.ucSelectRango1.FechaInicial
  ffinal = f.ucSelectRango1.FechaFinal
  Unload f

  sQuery = "SELECT R.CodigoCliente, R.NumFactura, R.FechaCobro, R.MontoRetencion, F.Serie, F.Correlativo, F.FechaTransaccion, F.PrecioEfectivo, F.Impuesto1, F.NombreCliente "
  sQuery = sQuery & "FROM RetencionesIVA R, Facturas F "
  sQuery = sQuery & "WHERE R.NumFactura = F.Numero "
  sQuery = sQuery & "AND R.FechaCobro BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " "
  If sFiltroClientes <> "" Then
    sQuery = sQuery & "AND R.CodigoCliente IN (SELECT Codigo FROM Clientes "
    sQuery = sQuery & "WHERE " & sFiltroClientes & ")"
  End If
  
  Dim rs As Recordset
  Set rs = dbHandle.Execute(sQuery)
  If Not rs.EOF Then
    Set fView = New lfQuickView
    fView.SetReportWidth AnchoReporte
    Encabezado
    sCodigoCliente = ""
    Do While Not rs.EOF
      PasarLinea rs
      rs.MoveNext
    Loop
    Ruptura "", ""
    PasarLineaTotal "TOTAL GENERAL", totBruto, TotIVA, totRetenido
    ShowNonModal fView
    Unload fView
  End If
  rs.Close

End Sub

