VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CInformeReciboMercancia"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Recibo As clsReciboMercancia
Private fView As lfQuickView
Const AnchoReporte = 129


'    Cliente...
'    Recepcion de Mercancias Numero 9999
'    Proveedor: XXXXXXXXXX. Factura: 9999999.  Fecha: 99-99-9999
'Emisi'on: xxxxxxxx   Operador: XXXXXXXXXX            P'agina: 999
'---------------------------------------------------------------------------------------------------------------------------------
'Codigo                   Cant. Descripcion                  Unid. IVA    Cantidad  Costo Unidad         Total       P.V.P. Margen
'---------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX #.###,### XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999 XXX 999.999,999 99.999.999,99  9.999.999,99 9.999.999,99 99.999
'7591084001012           10,000 BELMONT SUAVE 20                12 EXE     120,000    240.000,00      2.000,00     2.500,00 20,000

Private Sub Encabezado()

   fView.Add ""
   fView.Add Empresa.NombreEmpresa, vbCenter
   fView.Add "Recepcion de Mercancias", vbCenter
   fView.Add "Proveedor: " & Recibo.NombreProveedor & " (" & Recibo.CodigoProveedor & "). Factura No: " & Recibo.RefProveedor, vbCenter
   fView.Add "Numero " & Format(Recibo.Numero, "0000000"), vbCenter

   fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
  
   fView.Add String(fView.ReportWidth, "-")
   fView.Add "Codigo                   Cant. Descripcion                  Unid. IVA    Cantidad  Costo Unidad         Total       P.V.P. Margen"
   fView.Add String(fView.ReportWidth, "-")

End Sub

Private Sub AddLinea(pDetalle As clsDetallesCompra)
Dim pItemVenta As clsItemVenta, sOut As String
Dim Utilidad As Double

'Codigo                   Cant. Descripcion                  Unid. IVA    Cantidad Costo Unidad         Total       P.V.P. Margen
'--------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX #.###,### XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999 XXX 999.999,999 9.999.999,99 99.999.999,99 9.999.999,99 99.999
    Set pItemVenta = AlmacenItemsVenta.ItemVenta(pDetalle.CodigoItem)
    sOut = stFullLength(pDetalle.CodigoItem, 20) & " " & FormatNumero(pDetalle.Cantidad, Empresa.MascaraCantidades, 9) & " " & stFullLength(pDetalle.Descripcion, 30) & " "
    sOut = sOut & FormatNumero(pDetalle.FactorEmpaque, "##0", 3) & " "
    If pItemVenta Is Nothing Then
      sOut = sOut & stFullLength(" ", 3) & " "
    Else
      sOut = sOut & stFullLength(pItemVenta.TipoImpuesto1, 3) & " "
    End If
    
    sOut = sOut & FormatNumero(pDetalle.Cantidad * pDetalle.FactorEmpaque, Empresa.MascaraCantidades, 11) & " "
    sOut = sOut & FormatNumero(pDetalle.CostoUnitario, Empresa.MascaraPrecios, 13) & " "
    sOut = sOut & FormatNumero(pDetalle.CostoUnitario * pDetalle.Cantidad * pDetalle.FactorEmpaque, Empresa.MascaraMonetarios, 13) & " "
    If Not pItemVenta Is Nothing Then
      sOut = sOut & FormatNumero(pItemVenta.Precio(1), Empresa.MascaraPrecios, 12) & " "
      On Error Resume Next
      Utilidad = (pItemVenta.Precio1 - pDetalle.CostoUnitario) / pItemVenta.Precio1 * 100
      If Err.Number <> 0 Then
        Err.Clear
        Utilidad = 0
      End If
      sOut = sOut & FormatNumero(Utilidad, "##0.00", 6)
    End If
    
    Set pItemVenta = Nothing
    If fView.Linea > fView.LineasPagina - 2 Then Encabezado
    fView.Add sOut

End Sub

Public Sub SetRecibo(p As clsReciboMercancia)
Dim pDetalle As clsDetallesCompra, HayExtras As Boolean
  
  Set Recibo = p
  
  Set fView = New lfQuickView
  fView.SetReportWidth 129
  
  HayExtras = False
  
  Encabezado
  
  For Each pDetalle In p.Detalles
    If pDetalle.CodigoItem <> "" Then
      If left(pDetalle.CodigoItem, 1) <> "@" Then
        AddLinea pDetalle
      Else
        HayExtras = True
      End If
    End If
  Next
  
  If fView.Linea > fView.LineasPagina - 10 Then Encabezado
  
  fView.Add ""
  fView.Add "----------------------------------"
  fView.Add "Mercancia         : " & FormatNumero(Recibo.CostoMercancia, Empresa.MascaraMonetarios, 14)
  fView.Add "I.V.A.            : " & FormatNumero(Recibo.Impuesto1, Empresa.MascaraMonetarios, 14)
  If Recibo.MontoRecargo > 0 Then
  fView.Add "Costos adicionales: " & FormatNumero(Recibo.MontoRecargo * IIf(Recibo.bExcluirVarios, 1, (1 - ValorDescuentosSucesivos(Recibo.Descuento1, Recibo.Descuento2) / 100)), Empresa.MascaraMonetarios, 14)
  End If
  fView.Add "TOTAL             : " & FormatNumero(Recibo.CostoMercancia + Recibo.Impuesto1 + Recibo.MontoRecargo * IIf(Recibo.bExcluirVarios, 1, (1 - ValorDescuentosSucesivos(Recibo.Descuento1, Recibo.Descuento2) / 100)), Empresa.MascaraMonetarios, 14)
  fView.Add "----------------------------------"
  
  If HayExtras Then
    fView.Add "RECARGOS:"
  End If
  
  For Each pDetalle In Recibo.Detalles
    If left(pDetalle.CodigoItem, 1) = "@" Then
      pDetalle.CostoUnitario = pDetalle.PrecioEfectivo
      AddLinea pDetalle
    End If
  Next
  
  ShowNonModal fView
  
  Unload fView
  Set fView = Nothing


End Sub
