VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CImpresorFactPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Dim Lineas As Collection, nDetalles As Integer
Dim lPrinter As CLinePrinter
Dim pItemV As clsItemVenta

' -------------------------------------------------
' PasarDetalle: Acumula el producto en una de las
' lineas de salida.
' -------------------------------------------------
Sub PasarDetalle(sCodigoItem As String, vmPrecio As Currency, dCantidad As Double)
Dim i As Integer, pLinea As clsRenglonSesion

  If Val(GetSetting("ClearLight", "General", "ConsolidarDetallesFP", "1")) <> 0 Then
    For Each pLinea In Lineas
      If pLinea.CodigoItem = sCodigoItem And pLinea.PrecioUnitario = vmPrecio Then
        pLinea.Cantidad = pLinea.Cantidad + dCantidad
        Exit Sub
      End If
    Next
  End If

  Set pLinea = New clsRenglonSesion
  With pLinea
  If Not pItemV.Load(sCodigoItem) Then
    mAdvertencia "Desapareci el item codigo " & sCodigoItem
    Exit Sub
  Else
    .CodigoItem = sCodigoItem
    .Cantidad = dCantidad
    .PrecioUnitario = vmPrecio
    .PrecioTotal
    .PorcentajeImpuesto = pItemV.PorcentajeImpuesto(1)
  End If
  End With
  Lineas.Add pLinea
End Sub

Sub LPrint(s)
  lPrinter.LPrint s
End Sub

' ------------------------------------------------------
' Rutina principal...
' ------------------------------------------------------
Sub Go(Factura As clsFacturasPOS, bIsOnLine As Boolean, Impresora As CLinePrinter, pItemVenta As clsItemVenta)
Dim stOut As String, PrecioTotal As Currency, MontoImpuesto As Currency
Dim sParte1 As String, sParte2 As String, Total As Currency, vmPrecio As Currency
Dim pDetalle As clsRenglonSesion, n As Integer, colDetalles As Collection
Dim sDescripcion As String, vRetBuffer As Variant, dCantidad As Double

  Set pItemV = pItemVenta
  Set lPrinter = Impresora
  stOut = "": PrecioTotal = 0: sParte2 = ""
  MontoImpuesto = Factura.Impuesto
  Total = Factura.MontoVenta + MontoImpuesto + Factura.Servicio


  sParte1 = Empresa.NombreEmpresa
  If Len(sParte1) > 39 Then
    n = 20
    Do While Mid(sParte1, n, 1) <> " " And n < Len(sParte1)
      n = n + 1
    Loop
    If (n = Len(sParte1)) Then n = 20
    sParte2 = Trim(right(sParte1, Len(sParte1) - n))
    sParte1 = Trim(left(sParte1, n))
  End If

  Set Lineas = New Collection
  nDetalles = 0 ' Inicialmente, la matriz de Lineas() est vaca
  
    ' Comienzo del encabezado
  lPrinter.OpenLinePrinter
  LPrint ""
  LPrint stMidAlign(sParte1, 39)
  If sParte2 <> "" Then LPrint stMidAlign(sParte2, 39)
  LPrint "RIF " & Empresa.RIF
  LPrint "                  Factura: " & Impresora.Formatear(Factura.NumeroTicket, "000000")
  LPrint "                  " & Empresa.Ciudad & ", " & Impresora.Formatear(Factura.Hora, "Short Date")
  LPrint "---------------------------------------"
  LPrint "Descripcion              Cant.    Total"
  LPrint "---------------------------------------"
'           XXXXXXXXXXXXXXXXXXXXXXXXX 999 99.999,99

  Set colDetalles = Factura.Detalles
  For Each pDetalle In colDetalles
    sDescripcion = pDetalle.CodigoItem
    dCantidad = pDetalle.Cantidad
    vmPrecio = pDetalle.PrecioTotal
    vmPrecio = vmPrecio / dCantidad
    PasarDetalle sDescripcion, vmPrecio, dCantidad
  Next

  For Each pDetalle In Lineas
    stOut = stFullLength(pDetalle.Descripcion, 26)
    stOut = stOut & FormatNumero(pDetalle.Cantidad, "##0", 3) & " "
    stOut = stOut & FormatNumero(pDetalle.PrecioTotal, "##,##0.00", 9)
    LPrint stOut
  Next

  LPrint "---------------------------------------"
  LPrint "               TOTAL         " & FormatNumero(Factura.MontoVenta, "###,##0.00", 10)
  If Factura.Impuesto > 0 Then
    LPrint "               I.V.A.        " & FormatNumero(Factura.Impuesto, "###,##0.00", 10)
  End If

  If Factura.Servicio > 0 Then
    LPrint "               Servicio      " & FormatNumero(Factura.Servicio, "###,##0.00", 10)
  End If

  LPrint "               A pagar       " & FormatNumero(Total, "###,##0.00", 10)

  If bIsOnLine Then
    Factura.EvalVar "MontoRecibido", vRetBuffer, sParte2
    LPrint "         Gracias por su pago " & FormatNumero(CDbl(vRetBuffer), "###,##0.00", 10)
    Factura.EvalVar "Vuelto", vRetBuffer, sParte2
    LPrint "                      Vuelto " & FormatNumero(CDbl(vRetBuffer), "###,##0.00", 10)
  End If
  LPrint ""
  LPrint ""
  LPrint ""
  LPrint ""
  LPrint ""
  LPrint ""
  LPrint "-"
 
  lPrinter.CloseLinePrinter
  Set Lineas = Nothing
  Set lPrinter = Nothing
  Set pItemV = Nothing
  
End Sub

