VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CImportarVentasTexto"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Sub ImportarVentas(TextFileName As String, Optional sAlmacen As String = "GENERAL", Optional DeleteFile As Boolean = False)
Dim sKey As String, nFile As Integer
Dim MachineID As Long, usrID As String, Fecha As Date, StartTime As Date, FacturasRealizadas As Integer
Dim MontoFacturado As Currency, ImpuestoCobrado As Currency, EfectivoEnCaja As Currency, TTCVisa As Currency
Dim TTCMaster As Currency, TTCOtras As Currency, TDebito As Currency, ChequesEnCaja As Currency
Dim Anulaciones As Integer, MontoAnulaciones As Currency, ImpuestoAnulado As Currency, VentasACredito As Currency
Dim MontoEnCaja As Currency, TTCAmex As Currency, OtrosMedios As Currency
Dim sQuery As String, ProximaLinea As Integer

  On Error GoTo ErrHandler

  nFile = FreeFile
  On Error Resume Next
  Open TextFileName For Input As #nFile
  If Err.Number <> 0 Then
    mAdvertencia "ERROR (" & Err.Number & "): " & Err.Description & vbCrLf & _
                 "Abriendo archivo de entrada."
    Exit Sub
  End If
  
  If EOF(nFile) Then
    Close nFile
    mAdvertencia "ERROR: El archivo no tiene informacin"
    Exit Sub
  End If

  Dim pFactPos As Object
  Dim pSesion As Object
  Dim pComprobante As Object
  Dim pDetalle As Object
  Dim pItemVenta As Object

  Set pSesion = New clsSesionPOS
  Set pFactPos = New clsFacturasPOS
  Set pComprobante = New clsComprobanteAlmacen
  Set pDetalle = New clsRenglonSesion

  StartTransaction

  Input #nFile, sKey
  Do While Not EOF(nFile)
    Select Case UCase(sKey)
    Case "/SSN"
      Input #nFile, MachineID, usrID, Fecha, StartTime, FacturasRealizadas, MontoFacturado, ImpuestoCobrado, EfectivoEnCaja, TTCVisa, TTCMaster, TTCOtras, TDebito, ChequesEnCaja, Anulaciones, MontoAnulaciones, ImpuestoAnulado, VentasACredito, MontoEnCaja, TTCAmex, OtrosMedios, TTCOtras
      dbHandle.Execute "UPDATE SesionesPOS SET Cerrada = 1 WHERE MachineID = " & NumeroDB(MachineID)
      pSesion.CrearSesion MachineID, usrID
      Sesiones.LoadFromMachineID MachineID, pSesion
    
    Case "/DET"
    Dim detCodigoItem As String, detCantidad As Double, detPrecioUnitario As Currency, detPorcentajeImpuesto As Double
      With pDetalle
      Input #nFile, detCodigoItem, detCantidad, detPrecioUnitario, detPorcentajeImpuesto
      .CodigoItem = detCodigoItem: .Cantidad = detCantidad: .PrecioUnitario = detPrecioUnitario: .PorcentajeImpuesto = detPorcentajeImpuesto
      sQuery = "INSERT INTO RenglonesFacturaPOS (idMaquina, numeroTicket, numeroLinea, Producto, Cantidad, PrecioUnitario, PorcentajeImpuesto) VALUES ("
      sQuery = sQuery & NumeroDB(pFactPos.machID) & ", "
      sQuery = sQuery & NumeroDB(pFactPos.NumeroTicket) & ", "
      sQuery = sQuery & NumeroDB(ProximaLinea) & ", "
      sQuery = sQuery & StringDB(.CodigoItem) & ", "
      sQuery = sQuery & NumeroDB(.Cantidad) & ", "
      sQuery = sQuery & NumeroDB(.PrecioUnitario) & ", "
      sQuery = sQuery & NumeroDB(.PorcentajeImpuesto) & ");"
      dbHandle.Execute sQuery, dbFailOnError
      ProximaLinea = ProximaLinea + 1
      Dim pComponente As clsComponenteItemVenta
      Set pItemVenta = AlmacenItemsVenta.ItemVenta(.CodigoItem)
      If Not pItemVenta Is Nothing Then
        AlmacenDetallesItemVenta.AcumularVentaDocumento pSesion.SessionID, pSesion.TipoEntidad, _
          GetSetting(AppName, "General", "SeriePOS", "POS"), pSesion.Fecha, .CodigoItem, Empresa.CodigoClienteMostrador, UsuarioActivo.Codigo, pDetalle.PrecioUnitario, pDetalle.Cantidad, pItemVenta.CostoStandard
        For Each pComponente In pItemVenta.Composicion
        Dim pItemInventario As clsItemInventario
          Set pItemInventario = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
          If Not pItemInventario Is Nothing Then
            If pComprobante.AgregarMINV(pSesion.ComprobanteAlmacen, pComponente.CodigoItemInventario, -(pComponente.Cantidad * .Cantidad), pItemInventario.CostoUnitario, sAlmacen, pSesion.Fecha, pSesion.TipoEntidad, pSesion.SessionID, pSesion.Descripcion) <> 0 Then
              pSesion.SetComprobanteInventario pComprobante.Numero
            End If
            Set pItemInventario = Nothing
          End If
        Next
      End If
      End With
    
    Case "/FCT"
      Dim fctmachID As Long, fctNumeroTicket As Long, fctusrID As String, fctHora As String, fctMontoVenta As Currency, fctImpuesto As Currency, fctServicio As Currency, fctVendedor As String, fctPersonas As Integer, fctPropina As Currency
      With pFactPos
      Input #nFile, fctmachID, fctNumeroTicket, fctusrID, fctHora, fctMontoVenta, fctImpuesto, fctServicio, fctVendedor, fctPersonas, fctPropina
      .machID = fctmachID: .NumeroTicket = fctNumeroTicket: .usrID = fctusrID
      .Hora = CDate(fctHora): .MontoVenta = fctMontoVenta: .Impuesto = fctImpuesto
      .Servicio = fctServicio: .Vendedor = fctVendedor: .Personas = fctPersonas
'      .Propina = fctPropina
      sQuery = "INSERT INTO FacturasPOS (idMaquina, NumeroTicket, idSesion, idUsuario, Hora, MontoVenta, Impuesto, Servicio, Vendedor, Personas, Propina) VALUES ("
      sQuery = sQuery & NumeroDB(.machID) & ", "
      sQuery = sQuery & NumeroDB(.NumeroTicket) & ", "
      sQuery = sQuery & NumeroDB(pSesion.SessionID) & ", "
      sQuery = sQuery & StringDB(.usrID) & ", "
      sQuery = sQuery & TimeDateDB(.Hora) & ", "
      sQuery = sQuery & NumeroDB(.MontoVenta) & ", "
      sQuery = sQuery & NumeroDB(.Impuesto) & ", "
      sQuery = sQuery & NumeroDB(.Servicio) & ", "
      sQuery = sQuery & StringDB(.Vendedor) & ", "
      sQuery = sQuery & NumeroDB(.Personas) & ", "
      sQuery = sQuery & NumeroDB(fctPropina) & ");"
      dbHandle.Execute sQuery, dbFailOnError
      End With
      ProximaLinea = 1
    End Select
    
    If Not EOF(nFile) Then
      Input #nFile, sKey
    End If
  
  Loop
  
  dbHandle.Execute "UPDATE SesionesPOS SET Cerrada = 1 WHERE SessionID = " & NumeroDB(pSesion.SessionID)
  Close nFile
  CommitTransaction

  If DeleteFile Then
    Kill TextFileName
  End If

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  AbortTransaction
  ReportarError False, nErrN, sErrD, "frmImportVentas::cbAceptar_Click"
  Resume ResumePoint
End Sub
