VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CHistoriaScripts"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const sKeyWord = "Mru"

Private MaxEntries As Integer
Private sArray() As String
Private Level As Integer

Private Sub LoadOptions(sKey As String)
Dim s As String, i As Integer
  Level = 0
  ReDim sArray(0)
  For i = 1 To MaxEntries
    s = GetSetting("VSL", "MRU\" & sKey, sKeyWord & Format(i, "00"), "")
    If s <> "" Then
      Level = Level + 1
      ReDim Preserve sArray(Level)
      sArray(Level) = s
    End If
  Next
  
End Sub

Private Sub UpdateRegistry(sKey As String)
Dim i As Integer

  For i = 1 To Level
    If GetSetting("VSL", "MRU\" & sKey, sKeyWord & Format(i, "00"), "") <> "" Then
      DeleteSetting "VSL", "MRU\" & sKey, sKeyWord & Format(i, "00")
    End If
  Next

  For i = 1 To Level
    SaveSetting "VSL", "MRU\" & sKey, sKeyWord & Format(i, "00"), sArray(i)
  Next

End Sub

Public Function FileName(i As Integer) As String
  If i > Level Then
    FileName = ""
  Else
    FileName = sArray(i)
  End If
End Function

Public Sub Add(sFileName As String, sKey As String)
Dim i As Integer, j As Integer
  LoadOptions sKey
  For i = 1 To Level
    If sArray(i) = sFileName Then
      If i = 1 Then
        Exit Sub
      Else
        For j = i - 1 To 1 Step -1
          sArray(j + 1) = sArray(j)
        Next
        sArray(1) = sFileName
        UpdateRegistry sKey
        Exit Sub
      End If
    End If
  Next
  
  Level = Level + 1
  If Level = MaxEntries Then Level = MaxEntries - 1
  ReDim Preserve sArray(Level)
  For i = Level - 1 To 1 Step -1
    sArray(i + 1) = sArray(i)
  Next
  sArray(1) = sFileName
  UpdateRegistry sKey

End Sub

Public Function MRUList(sKey As String) As Variant
  LoadOptions sKey
  MRUList = sArray
End Function

Private Sub Class_Initialize()
  MaxEntries = Val(GetSetting("VSL", "MRU", "MaxMRU", "5"))
  If (MaxEntries < 1) Then MaxEntries = 5
  If MaxEntries > 18 Then MaxEntries = 18
  ReDim sArray(MaxEntries)
End Sub

Public Sub UpdateFromMRU(p As Object, K As String)
Dim v As Variant
Dim i As Integer, l As Integer

  v = MRUList(K)
  i = 1: l = p.Count - 1
  While i <= l
    Unload p(i)
    i = i + 1
  Wend
  
  i = 1
  Do While i <= UBound(v)
    Load p(i)
    p(i).Caption = v(i)
    i = i + 1
  Loop

End Sub

