VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CHistoriaPagosFactura"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Property Set Factura(arg As clsFacturas)
  MostrarPagos arg
End Property

Public Sub MostrarPagos(pFactura As clsFacturas)
Dim fView As lfView, pDocumento As clsDocumentosISPC
Dim colDet As Collection, pDetalle As clsDetalleCuentaEntidad
Dim totDeb As Currency, totCred As Currency
Dim sOut As String

  Set pDocumento = New clsDocumentosISPC
  If pDocumento.LoadFromDocumento(pFactura.TipoEntidad, pFactura.Numero) Then
    Set fView = New lfView
    fView.Caption = "Historia del pago de la factura " & pFactura.Referencia
    fView.Add stMidAlign(Empresa.NombreEmpresa, 85)
    fView.Add stMidAlign("Historia del pago de la factura " & pFactura.Referencia, 85)
    fView.Add stMidAlign("Cliente: " & pFactura.NombreCliente, 85)
    fView.Add stMidAlign("Emitida el " & Format(pFactura.FechaTransaccion, "Short Date"), 85)
    fView.Add ""
    fView.Add "Consulta: " & Format(Date, "General Date")
    fView.Add "-------------------------------------------------------------------------------------"
    fView.Add "Fecha      Descripcin                                       Dbitos         Crditos"
    fView.Add "-------------------------------------------------------------------------------------"
              '99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999.999,99 9.999.999.999,99
    Set colDet = pDocumento.Detalles
    totDeb = 0: totCred = 0
    For Each pDetalle In colDet
      sOut = stFullLength(Format(pDetalle.Fecha, "Short Date"), 10) & " "
      sOut = sOut & stFullLength(pDetalle.Descripcion, 40) & " "
      sOut = sOut & FormatNumero(pDetalle.Debe, "#,###,###,###,##0.00", 16) & " "
      sOut = sOut & FormatNumero(pDetalle.Haber, "#,###,###,###,##0.00", 16) & " "
      totDeb = totDeb + pDetalle.Debe
      totCred = totCred + pDetalle.Haber
      fView.Add sOut
    Next
    Set colDet = Nothing
    
    fView.Add "-------------------------------------------------------------------------------------"
    sOut = stFullLength(Format(Date, "Short Date"), 10) & " "
    sOut = sOut & stFullLength("Totales", 40) & " "
    sOut = sOut & FormatNumero(totDeb, "#,###,###,###,##0.00", 16) & " "
    sOut = sOut & FormatNumero(totCred, "#,###,###,###,##0.00", 16) & " "
    fView.Add sOut
    fView.Show
    
    While fView.Visible: DoEvents: Wend
    
    Unload fView
    Set fView = Nothing
  End If
  Set pDocumento = Nothing
  
End Sub
