VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CFactoria"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' CFactoria: Proveedor de objetos, referencias y servicios para
' componentes en VBScript

Public Sub ReportarError(isFatal As Boolean, numError As Long, sDescripcion As String, stLocus As String)
  mGlobalLock.ReportarError isFatal, numError, sDescripcion, stLocus
End Sub

Public Function SetGlobalLock(Optional s As String = "") As Boolean
  SetGlobalLock = mGlobalLock.SetGlobalLock(s)
End Function

Public Sub FreeGlobalLock()
  mGlobalLock.FreeGlobalLock
End Sub

Public Function StartTransaction() As Boolean
  StartTransaction = lmdbHandle.StartTransaction
End Function

Public Function CommitTransaction() As Boolean
  CommitTransaction = lmdbHandle.CommitTransaction
End Function

Public Function AbortTransaction() As Boolean
  AbortTransaction = lmdbHandle.AbortTransaction
End Function

Public Function FechaDB(Fecha) As String
  FechaDB = lmdbHandle.FechaDB(CDate(Fecha))
End Function

Public Function TimeDateDB(Fecha) As String
  TimeDateDB = lmdbHandle.TimeDateDB(CDate(Fecha))
End Function

Public Function StringDB(starg) As String
  StringDB = lmdbHandle.StringDB(CStr(starg))
End Function

Public Function NumeroDB(dblArg) As String
  NumeroDB = lmdbHandle.NumeroDB(CDbl(dblArg))
End Function

Public Function AppPath() As String
  AppPath = App.Path & "\"
End Function

Public Function DataPath() As String
  DataPath = BuildDataPath("", AppName)
End Function

Public Function Format(ByVal arg As Variant, ByVal Formato As Variant) As Variant
Dim vRetVal As Variant
    vRetVal = VBA.Format(arg, Formato)
    Format = vRetVal
End Function

Public Function VerificarUsuario(stArgCaption As String) As Integer
  VerificarUsuario = lmUsuarios.VerificarUsuario(stArgCaption)
End Function

Public Function NewForm(sFormName) As CFormEnvelope
Dim f As Form, Env As CFormEnvelope
  On Error GoTo ErrHandler
  Set f = Forms.Add(sFormName)
  Set Env = New CFormEnvelope
  Env.SetForm f
ResumePoint:
  Set NewForm = Env
Exit Function

ErrHandler:
  Set Env = Nothing
  Resume ResumePoint
End Function

Public Function FormByName(sFormName) As Form
Dim f
  For Each f In Forms
    If f.Name = sFormName Then
      Set FormByName = f
      Exit Function
    End If
  Next
  Set FormByName = Nothing
End Function

Public Function CrearObjeto(istrCodigoClase) As Object
Dim pRetObject As Object

  Select Case UCase(istrCodigoClase)
  Case "ALMACEN"
    Set pRetObject = New clsAlmacen
  Case "ALMACENITEMSVENTA"
    Set pRetObject = AlmacenItemsVenta
  Case "ALMACENITEMSINVENTARIO"
    Set pRetObject = AlmacenItemsInventario
  Case "ALMACENCLIENTES"
    Set pRetObject = AlmacenClientes
  Case "ALMACENPROVEEDORES"
    Set pRetObject = AlmacenProveedores
  Case "ALMACENCUENTAS"
    Set pRetObject = AlmacenCuentas
  Case "ALMACENVENDEDORES"
    Set pRetObject = AlmacenVendedores
  Case "ATRIBUTOS"
    Set pRetObject = New clsAtributoEntidad
  Case "BANCO"
    Set pRetObject = New clsBancos
  Case "BCOMPROBANTE"
    Set pRetObject = New clsBufferComprobante
  Case "CALCVENCIMIENTO"
    Set pRetObject = New CCalcFechaVencimiento
'  Case "CIERREFACTPOS"
'    Set pRetObject = New CCierreFactPos
  Case "CLIENTE"
    Set pRetObject = New clsClientes
  Case "COLECCION"
    Set pRetObject = New Collection
  Case "COMPROBANTE"
    Set pRetObject = New clsComprobante
  Case "CONDICIONES"
    Set pRetObject = Condiciones
  Case "CONTACTO"
    Set pRetObject = New clsContactos
  Case "CUENTA"
    Set pRetObject = New clsCuenta
  Case "DATABASE"
    Set pRetObject = dbHandle
  Case "DETALLECE"
    Set pRetObject = New clsDetalleCuentaEntidad
  Case "DETALLEMC"
    Set pRetObject = New CDetalleIngresoCaja
  Case "DEVOLUCIONVENTA"
    Set pRetObject = New clsDevolucionVenta
  Case "DOCUMENTOISPC"
    Set pRetObject = New clsDocumentosISPC
  Case "EMPRESA"
    Set pRetObject = Empresa
  Case "FACTURA"
    Set pRetObject = New clsFacturas
  Case "FACTURAPOS"
    Set pRetObject = New clsFacturasPOS
  Case "INSTANCIADOR"
    Set pRetObject = New clsInstanciadorEntidad
  Case "ITEMINVENTARIO"
    Set pRetObject = New clsItemInventario
  Case "ITEMVENTA"
    Set pRetObject = New clsItemVenta
  Case "LINEPRINTER"
    Set pRetObject = New CLinePrinter
'  Case "LOTE"
'    Set pRetObject = New CLote
  Case "MOVIMIENTOBANCO"
    Set pRetObject = New clsMovimientoBanco
  Case "MOVIMIENTOCAJA"
    Set pRetObject = New CMovimientoCaja
  Case "NOTAENTREGA"
    Set pRetObject = New clsNNEE
  Case "SUPLEMENTONOTAENTREGA"
    Set pRetObject = New clsNNEESuplemento
  Case "NOTADCPP", "NOTADCCP"
    Set pRetObject = New clsNotasDCCP
  Case "PRINTER"
    Set pRetObject = Printer
  Case "PRINTERS"
    Set pRetObject = Printers
  Case "PROCESADORFACTURAS"
    Set pRetObject = New CProcesadorFacturas
  Case "PROCESADORCOMPRAS"
    Set pRetObject = New CProcesadorCompras
  Case "PROVEEDOR"
    Set pRetObject = New clsProveedores
  Case "SESION"
    Set pRetObject = SesionActiva
  Case "TIPOSIMPUESTO"
    Set pRetObject = TiposImpuesto
  Case "USUARIO"
    Set pRetObject = New clsUsuario
    pRetObject.SetUsuario UsuarioActivo.Codigo
  Case "VSLIB"
    Set pRetObject = CreateObject("VSLIB.VSLRTLIB")
  Case "VENDEDOR"
    Set pRetObject = New clsVendedores
#If IsNotMain = 0 Then
  Case "AJUSTE"
    Set pRetObject = New clsAjuste
  Case "COTIZACION"
    Set pRetObject = New clsCotizacion
  Case "DEVOLUCIONCOMPRA"
    Set pRetObject = New clsDevolucionCompra
  Case "ORDENCOMPRA"
    Set pRetObject = New clsOrdenesCompra
  Case "PROCESADORORDEN"
    Set pRetObject = New CProcesadorOrden
  Case "RECIBOMERCANCIA"
    Set pRetObject = New clsReciboMercancia
  Case "SERIES"
    Set pRetObject = Series
  Case "TRANSFERENCIA"
    Set pRetObject = New clsTransferencia
  Case "LIBROCOMPRAS"
    Set pRetObject = New clsLibroCompras
  Case "LIBROVENTAS"
    Set pRetObject = New clsLibroVentas
  Case "MAINFORM"
    Set pRetObject = mainForm
  Case "COTSPP"
    Set pRetObject = New clsAlmacenCotsPP
#End If
  Case Else
    Set pRetObject = Nothing
  End Select

  Set CrearObjeto = pRetObject

End Function

