VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CExpEvalDocVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Function EvalVar(sVarId, vRetBuffer, sRetString, pDocumento As Object) As Boolean
Dim bRetVal As Boolean, vM1 As Currency, VM2 As Currency, DBL1 As Double, DBL2 As Double, lVar As Variant, lString As String
Dim pCliente As clsClientes

  bRetVal = True

  On Error GoTo ErrHandler

  Select Case sVarId
  
  Case "NUMERO"
    vRetBuffer = pDocumento.Referencia
    sRetString = pDocumento.Referencia
  
  Case "FECHA_REGISTRO"
    vRetBuffer = pDocumento.FechaRegistro
    sRetString = Format(pDocumento.FechaRegistro, "Short Date")
  
  Case "FECHA", "FECHA_FACTURA", "FECHA_EMISION"
    vRetBuffer = pDocumento.FechaTransaccion
    sRetString = Format(pDocumento.FechaTransaccion, "Short Date")
  
  Case "OPERADOR"
    vRetBuffer = pDocumento.Operador
    sRetString = pDocumento.Operador
  
  Case "SERIE"
    vRetBuffer = pDocumento.Serie
    sRetString = pDocumento.Serie
  
  Case "CORRELATIVO"
    vRetBuffer = pDocumento.Correlativo
    sRetString = Format(pDocumento.Correlativo, "0000000")
  
  Case "REFERENCIA", "EXT_REF"
    vRetBuffer = pDocumento.ExtRef
    sRetString = pDocumento.ExtRef
  
  Case "CODIGO_CLIENTE", "CODCLI"
    vRetBuffer = pDocumento.CodigoCliente
    sRetString = pDocumento.CodigoCliente
  
  Case "NOMBRE_CLIENTE", "NOMBRECLIENTE", "NOMBRECLI"
    vRetBuffer = pDocumento.NombreCliente
    sRetString = pDocumento.NombreCliente
  
  Case "CODIGO_VENDEDOR", "CODVEND", "VENDEDOR"
    vRetBuffer = pDocumento.CodigoVendedor
    sRetString = pDocumento.CodigoVendedor
  
  Case "NOMBRE_VENDEDOR", "NOMBREVENDEDOR", "NOMBREVEND"
    Dim pVendedor As clsVendedores
    Set pVendedor = New clsVendedores
    If Not pVendedor.Load(pDocumento.CodigoVendedor) Then
      vRetBuffer = "N/A"
      sRetString = "N/A"
    Else
      vRetBuffer = pVendedor.Nombre
      sRetString = pVendedor.Nombre
    End If
  
  Case "TELEFONO_CLIENTE"
    Set pCliente = New clsClientes
    If Not pCliente.Load(pDocumento.CodigoCliente) Then
      vRetBuffer = "N/A"
      sRetString = "N/A"
    Else
      sRetString = pCliente.Telefono
      vRetBuffer = sRetString
    End If
    Set pCliente = Nothing

  Case "DIRECCION_CLIENTE"
    Set pCliente = New clsClientes
    If Not pCliente.Load(pDocumento.CodigoCliente) Then
      vRetBuffer = "N/A"
      sRetString = "N/A"
    Else
      sRetString = pCliente.Direccion
      vRetBuffer = sRetString
    End If
    Set pCliente = Nothing

  Case "RIF_CLIENTE"
    Set pCliente = New clsClientes
    If Not pCliente.Load(pDocumento.CodigoCliente) Then
      vRetBuffer = "N/A"
      sRetString = "N/A"
    Else
      sRetString = pCliente.RIF
      vRetBuffer = sRetString
    End If
    Set pCliente = Nothing

  Case "NIT_CLIENTE"
    Set pCliente = New clsClientes
    If Not pCliente.Load(pDocumento.CodigoCliente) Then
      vRetBuffer = "N/A"
      sRetString = "N/A"
    Else
      sRetString = pCliente.NIT
      vRetBuffer = sRetString
    End If
    Set pCliente = Nothing

  Case "PRECIOLISTA", "PRECIO_LISTA"
    vRetBuffer = pDocumento.PrecioLista
    sRetString = Format(pDocumento.PrecioLista, Empresa.MascaraMonetarios)
  
  Case "PRECIOVENTA", "PRECIO_VENTA"
    vRetBuffer = pDocumento.PrecioVenta
    sRetString = Format(pDocumento.PrecioVenta, Empresa.MascaraMonetarios)
  
  Case "PRECIOEFECTIVO", "PRECIO_EFECTIVO", "PRECIO_FINAL", "PRECIOFINAL"
    vRetBuffer = pDocumento.PrecioEfectivo
    sRetString = Format(pDocumento.PrecioEfectivo, Empresa.MascaraMonetarios)
  
  Case "IMPUESTO1"
    vRetBuffer = pDocumento.Impuesto1
    sRetString = Format(pDocumento.Impuesto1, Empresa.MascaraMonetarios)
  
  Case "IMPUESTO2"
    vRetBuffer = pDocumento.Impuesto2
    sRetString = Format(pDocumento.Impuesto2, Empresa.MascaraMonetarios)
  
  Case "IMPUESTO"
    vRetBuffer = pDocumento.Impuesto1 + pDocumento.Impuesto2
    sRetString = Format(pDocumento.Impuesto1 + pDocumento.Impuesto2, Empresa.MascaraMonetarios)
  
  Case "T_APAGAR"
    vRetBuffer = pDocumento.PrecioEfectivo + pDocumento.Impuesto1 + pDocumento.Impuesto2
    sRetString = Format(pDocumento.PrecioEfectivo + pDocumento.Impuesto1 + pDocumento.Impuesto2, Empresa.MascaraMonetarios)
  
  Case "TIPO_PREF"
    vRetBuffer = Empresa.TituloPrecio(pDocumento.IndiceReferencia)
    sRetString = Empresa.TituloPrecio(pDocumento.IndiceReferencia)
  
  Case "TIPO_PVENTA"
    vRetBuffer = Empresa.TituloPrecio(pDocumento.IndiceVenta)
    sRetString = Empresa.TituloPrecio(pDocumento.IndiceVenta)
  
  Case "PDESC1"
    vRetBuffer = pDocumento.Descuento1
    sRetString = Format(pDocumento.Descuento1, "##0.00")
  
  Case "PDESC2"
    vRetBuffer = pDocumento.Descuento2
    sRetString = Format(pDocumento.Descuento2, "##0.00")
  
  Case "VDESC1", "MDESC1"
    vM1 = pDocumento.PrecioVenta * (pDocumento.Descuento1 / 100#)
    vRetBuffer = vM1
    sRetString = Format(vM1, Empresa.MascaraMonetarios)
  
  Case "SDESC1"
    vM1 = pDocumento.PrecioVenta * (1# - pDocumento.Descuento1 / 100#)
    vRetBuffer = vM1
    sRetString = Format(vM1, Empresa.MascaraMonetarios)

  Case "VDESC2", "MDESC2"
    vM1 = pDocumento.PrecioVenta * (1# - pDocumento.Descuento1 / 100#)
    vM1 = vM1 * (pDocumento.Descuento2 / 100#)
    vRetBuffer = vM1
    sRetString = Format(vM1, Empresa.MascaraMonetarios)
  
  Case "SDESC2"
    vRetBuffer = pDocumento.PrecioEfectivo
    sRetString = Format(pDocumento.PrecioEfectivo, Empresa.MascaraMonetarios)
      
  Case "VDESCABS", "VDESCUENTOABSOLUTO"
    vM1 = pDocumento.PrecioLista - pDocumento.PrecioEfectivo
    vRetBuffer = vM1
    sRetString = Format(vM1, Empresa.MascaraMonetarios)
  
  Case "PDESCABS"
    vM1 = pDocumento.PrecioLista - pDocumento.PrecioEfectivo
    VM2 = vM1 * 100 / pDocumento.PrecioLista
    vRetBuffer = VM2
    sRetString = FormatNumero(VM2, "###,00", 6)

  Case "PDESCGENERAL", "PDESC12"
    DBL1 = pDocumento.Descuento1 + (pDocumento.Descuento2 * (100 - pDocumento.Descuento1)) / 100
    vRetBuffer = DBL1
    sRetString = Format(DBL1, "##0.00")
  
  Case "MDESC12"
    DBL1 = pDocumento.Descuento1 + (pDocumento.Descuento2 * (100 - pDocumento.Descuento1) / 100)
    vM1 = pDocumento.PrecioVenta * DBL1 / 100#
    vRetBuffer = vM1
    sRetString = Format(vM1, Empresa.MascaraMonetarios)
  
  Case "CODIGO_CONDICION"
    vRetBuffer = pDocumento.Condicion
    sRetString = pDocumento.Condicion
  
  Case "NOMBRE_CONDICION"
    If pDocumento.Condicion = "CONTADO" Then
      sRetString = "CONTADO"
    Else
      sRetString = Condiciones.Item(pDocumento.Condicion).Descripcion
    End If
    vRetBuffer = sRetString

  Case "DIRECCION_ENTREGA"
    sRetString = pDocumento.DireccionEntrega
    vRetBuffer = pDocumento.DireccionEntrega
  
  Case "NOTAS"
    sRetString = pDocumento.Notas
    vRetBuffer = sRetString
  
  Case Else
      
    bRetVal = False

  End Select
  
ResumePoint:

  If Not bRetVal Then
    Dim pDocISPC As clsDocumentosISPC
    Set pDocISPC = New clsDocumentosISPC
    If pDocISPC.LoadFromDocumento(pDocumento.TipoEntidad, pDocumento.Numero) Then
      bRetVal = pDocISPC.EvalVar(sVarId, vRetBuffer, sRetString)
    Else    ' Parche para facturas de contado
      bRetVal = True
      Select Case sVarId
      Case "NCUOTAS"
        vRetBuffer = 1
        sRetString = "1"
      Case "FECHA_VENCIMIENTO"
        vRetBuffer = pDocumento.FechaTransaccion
        sRetString = Format(pDocumento.FechaTransaccion, "Short Date")
      Case "VENCIMIENTOS"
        vRetBuffer = "CONTADO"
        sRetString = vRetBuffer
      Case Else
        bRetVal = False
      End Select
    End If

    Set pDocISPC = Nothing

  End If
  
  If Not bRetVal Then
    bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sRetString)
  End If

  If Not bRetVal Then
    bRetVal = pDocumento.ExtendEval(sVarId, lVar, lString)
    If bRetVal Then
      sRetString = lString
      vRetBuffer = lVar
    End If
  End If
  
  EvalVar = bRetVal

  Exit Function

ErrHandler:

  bRetVal = False
  Resume ResumePoint

End Function

