VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CExpEvalDocCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Function EvalVar(sVarId, v, s, pDocumento As Object)
Dim bRetVal As Boolean, pProveedor As clsProveedores

    bRetVal = True

    Select Case sVarId

    Case "NUMERO"
        v = pDocumento.Numero
        s = Format(pDocumento.Numero, "0000000")

    Case "FECHA"
        v = pDocumento.FechaTransaccion
        s = Format(pDocumento.FechaTransaccion, "Short Date")

    Case "FECHA_REQUERIDA", "FECHA_REQUERIDO"
    ' Solo para Ordenes de Compra
        If TypeName(pDocumento) = "clsOrdenesCompra" Then
            v = pDocumento.FechaRequerido
            s = Format(pDocumento.FechaRequerido, "Short Date")
        Else
            bRetVal = False
        End If
    Case "OPERADOR"
        v = pDocumento.Operador
        s = pDocumento.Operador

    Case "CODIGOPROVEEDOR", "PROVEEDOR"
        v = pDocumento.CodigoProveedor
        s = pDocumento.CodigoProveedor

    Case "FACTURA", "REFERENCIAPROVEEDOR", "REFPROVEEDOR"
        v = pDocumento.RefProveedor
        s = pDocumento.RefProveedor

    Case "NOMBREPROVEEDOR"
        v = pDocumento.NombreProveedor
        s = pDocumento.NombreProveedor

    Case "COSTO", "COSTOMERCANCIA", "VALOR"
        v = pDocumento.CostoMercancia
        s = FormatNumero(pDocumento.CostoMercancia, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "DESCUENTO1"
        v = pDocumento.Descuento1
        s = FormatNumero(pDocumento.Descuento1, "##0.00", 6)

    Case "DESCUENTO2"
        v = pDocumento.Descuento2
        s = FormatNumero(pDocumento.Descuento2, "##0.00", 6)

    Case "DESCUENTOS"
        v = lmProporciones.ValorDescuentosSucesivos(pDocumento.Descuento1, pDocumento.Descuento2)
        s = FormatNumero(v, "##0.00", 6)

    Case "COSTODETALLES"
        v = lmProporciones.ValorDescuentosSucesivos(pDocumento.Descuento1, pDocumento.Descuento2)
        v = pDocumento.CostoMercancia / (1# - v / 100#)
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "IMPUESTO"
        v = pDocumento.Impuesto1 + pDocumento.Impuesto2
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "IMPUESTO1"
        v = pDocumento.Impuesto1
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "IMPUESTO2"
        v = pDocumento.Impuesto2
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "ALMACEN"
        v = pDocumento.Almacen
        s = pDocumento.Almacen

    Case "CONDICION"
        v = pDocumento.Condicion
        s = pDocumento.Condicion

    Case "NOTAS"
        v = pDocumento.Notas
        s = pDocumento.Notas

    Case "SALDO"
        v = pDocumento.Saldo
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "MONTOTOTAL"
        v = pDocumento.CostoMercancia + pDocumento.Impuesto1 + pDocumento.Impuesto2
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case Else

        Set pProveedor = New clsProveedores
        If pProveedor.Load(pDocumento.CodigoProveedor) Then
            bRetVal = pProveedor.EvalVar(sVarId, v, s)
        Else
            bRetVal = Empresa.EvalVar(sVarId, v, s)
        End If
        Set pProveedor = Nothing

    End Select

ResumePoint:

    If Not bRetVal Then
        Dim pDocISPC As clsDocumentosISPC
        Set pDocISPC = New clsDocumentosISPC
        If pDocISPC.LoadFromDocumento(pDocumento.TipoEntidad, pDocumento.Numero) Then
            bRetVal = pDocISPC.EvalVar(sVarId, v, s)
        Else    ' Parche para facturas de contado
            bRetVal = True
            Select Case sVarId
            Case "NCUOTAS"
                v = 1
                s = "1"
            Case "FECHA_VENCIMIENTO"
                v = pDocumento.FechaTransaccion
                s = Format(pDocumento.FechaTransaccion, "Short Date")
            Case "VENCIMIENTOS"
                v = "CONTADO"
                s = v
            Case Else
                bRetVal = False
            End Select
        End If

        Set pDocISPC = Nothing

    End If

    If Not bRetVal Then
        bRetVal = Empresa.EvalVar(sVarId, v, s)
    End If

    EvalVar = bRetVal

    Exit Function

ErrHandler:

    bRetVal = False
    On Error GoTo 0
    Resume ResumePoint

End Function


