VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CEditorSeriales"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Function Editar(pColSeriales As CSerialesDocumento, inTipoOp As Integer, istrTipoItem As String, istrCodigoItem As String, ByVal idblCantidad, ByVal ilngNumDoc As Long, istrTipoDoc As String, istrIdRenglon As String) As String
Dim pInstancer As clsInstanciadorEntidad, _
    pItem As Object
Dim pSerialesR As CSerialesRenglon, _
    f As frmLecturaSeriales
Dim sRetVal As String

    If idblCantidad = 0 Then
        Editar = ""
        Exit Function
    End If

    Set pInstancer = New clsInstanciadorEntidad
    Set pItem = pInstancer.EntidadITEM(istrTipoItem, istrCodigoItem)
    Set pInstancer = Nothing

    If pItem Is Nothing Then
        Editar = ""
        Exit Function
    End If

    If pItem.UsaSeriales = 0 Then
        If istrIdRenglon <> "" Then
            On Error Resume Next    ' Por si acaso no estaba...
            pColSeriales.mSerialesRenglon.Remove istrIdRenglon
        End If
        Editar = ""
        Set pItem = Nothing
        Exit Function
    End If

    Set pSerialesR = pColSeriales.SerialesRenglon(istrIdRenglon)
    
    If Not pSerialesR Is Nothing Then
        If pSerialesR.CodigoItem <> istrCodigoItem Then ' El item cambio... condicion invlida
            On Error Resume Next    ' Aunque de repente es peligroso... podra estar "tapndose" un error
            pColSeriales.mSerialesRenglon.Remove istrIdRenglon
            Set pSerialesR = Nothing
        End If
    End If

    Set f = New frmLecturaSeriales
    f.Activar istrCodigoItem, istrTipoItem, inTipoOp, idblCantidad, ilngNumDoc, istrTipoDoc, pSerialesR

    ShowNonModal f

    If Not f.retCol Is Nothing Then
        If pSerialesR Is Nothing Then
            pColSeriales.Add f.retCol
            f.retCol.CodigoItem = istrCodigoItem
                ' Como CodigoItem es necesario para la validacin, y se crea por aqu (solamente),
                ' esto debe ser suficiente para segurarse de que CodigoItem contiene el cdigo para el
                ' cual se definieron los seriales.
            sRetVal = f.retCol.idRenglon
        Else
            pColSeriales.Update istrIdRenglon, f.retCol
            sRetVal = istrIdRenglon
        End If
    Else
        sRetVal = istrIdRenglon
    End If
           
    Unload f
    Set f = Nothing
    
    Editar = sRetVal

End Function

Public Function Validar(pSerialesD As CSerialesDocumento, istrCodigoItem As String, istrTipoItem As String, istrIdRenglon As String, ByVal idblCantidad As Double, ostrIdRenglon As String) As Boolean
Dim pInstancer As clsInstanciadorEntidad, _
    pItem As Object
Dim pSerialesR As CSerialesRenglon

    Set pInstancer = New clsInstanciadorEntidad
    Set pItem = pInstancer.EntidadITEM(istrTipoItem, istrCodigoItem)
    Set pInstancer = Nothing

    If pItem Is Nothing Then
        Validar = True
        pSerialesD.RemoveRenglon istrIdRenglon
        ostrIdRenglon = ""
        Exit Function
    End If

    If pItem.UsaSeriales = 0 Then
        Validar = True
        pSerialesD.RemoveRenglon istrIdRenglon
        ostrIdRenglon = ""
        Exit Function
    End If
    
    Set pSerialesR = pSerialesD.SerialesRenglon(istrIdRenglon)
    If pSerialesR Is Nothing Then
        mAdvertencia "Debe definir los seriales"
        Validar = False
        Exit Function
    End If

    If pSerialesR.CodigoItem <> istrCodigoItem Then
        mAdvertencia "Debe definir los seriales"
        pSerialesD.RemoveRenglon istrIdRenglon
        Validar = False
        Exit Function
    End If
            
    If Not pSerialesR.Validar(istrCodigoItem, istrTipoItem, idblCantidad) Then
        mAdvertencia "Los seriales estan incompletos"
        Validar = False
        Exit Function
    End If

    ostrIdRenglon = istrIdRenglon
    Validar = True

End Function
