VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CDisplay"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private pDisplay As Object
Private isAvailable As Boolean

Private Sub Class_Initialize()
  On Error GoTo ErrHandler
  isAvailable = True
  Set pDisplay = CreateObject("PoleDisplay.CDisplay")
  pDisplay.SetIdle
  Exit Sub

ErrHandler:
  Err.Clear
  isAvailable = False
End Sub

Public Sub Send(ByVal sText As String)
  If isAvailable Then pDisplay.Send sText
End Sub

Public Sub PasarProducto(ByVal sDescripcion As String, ByVal vmPrecio As Currency, ByVal dCantidad As Double, ByVal dPorcentajeIVA As Double, ByVal sTipoImpuesto As String)
  If isAvailable Then pDisplay.PasarProducto sDescripcion, vmPrecio, dCantidad, dPorcentajeIVA, sTipoImpuesto
End Sub

Public Sub PasarTotal(ByVal vmTotalMercancia As Currency, ByVal vmTotalImpuesto As Currency, ByVal vmTotalServicio As Currency)
  If isAvailable Then pDisplay.PasarTotal vmTotalMercancia, vmTotalImpuesto, vmTotalServicio
End Sub

Public Sub PasarVuelto(ByVal vmTotalAPagar As Currency, ByVal vmRecibido As Currency, ByVal vmVuelto As Currency)
  If isAvailable Then pDisplay.PasarVuelto vmTotalAPagar, vmRecibido, vmVuelto
End Sub

Public Sub SetIdle()
  If isAvailable Then pDisplay.SetIdle
End Sub

Private Sub Class_Terminate()
  Set pDisplay = Nothing
End Sub
