VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDetalleIngresoCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public TransID As Long
Public Sesion As Long
Public Medio As String
Public Emisor As String
Public Referencia As String
Public Clave As String
Public Monto As Currency

Public Sub Fill(sClave As String, sEmisor As String, sReferencia As String, sMedio As String, vmMonto As Currency)
  Clave = sClave
  Emisor = sEmisor
  Referencia = sReferencia
  Medio = sMedio
  Monto = vmMonto
End Sub

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleIngCaja.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, sRetString, vRetBuffer) As Boolean
Dim bRetVal As Boolean, pInstancer As clsInstanciadorEntidad, pAltInstance As Object
Dim sBuffer As String, vBuffer As Variant

  bRetVal = True
  Select Case UCase(Trim(sVarId))
  Case "NUMERO", "TRANSID"
    vRetBuffer = Me.TransID
    sRetString = Format(TransID, "0000000")
  Case "SESION", "IDESION", "SESSIONID"
    vRetBuffer = Me.Sesion
    sRetString = Format(Sesion, "000000")
  Case "MEDIO"
    vRetBuffer = Medio
    sRetString = Medio
  Case "EMISOR"
    vRetBuffer = Emisor
    sRetString = Emisor
  Case "CLAVE"
    vRetBuffer = Clave
    sRetString = Clave
  Case "REFERENCIA"
    vRetBuffer = Referencia
    sRetString = Referencia
  Case "DEBITOS", "INGRESO"
    If Monto < 0 Then
      vRetBuffer = 0
    Else
      vRetBuffer = Monto
    End If
    sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
  Case "CREDITOS", "EGRESO"
    If Monto > 0 Then
      vRetBuffer = 0
    Else
      vRetBuffer = Monto
    End If
    sRetString = Format(-vRetBuffer, Empresa.MascaraMonetarios)
  Case "MONTO", "VALOR"
    vRetBuffer = Monto
    sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
  Case Else
    bRetVal = False
  End Select

  If Not bRetVal Then
    bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
  End If

  EvalVar = bRetVal
End Function

'---------------------------------------------------------------------------------------
' Function SalvarDetalle
' Fecha/Hora: 16/03/03 11:45
' Funcin   :
'---------------------------------------------------------------------------------------
'
Public Function SalvarDetalle(idTrans As Long, iSesion As Long, iMedio As String, iEmisor As String, iReferencia As String, iClave As String, iMonto As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

  On Error GoTo ErrHandler
  bRetVal = True
  If iMedio = "EFE" Then
    sQuery = "INSERT INTO DetallesIngresoCaja (TransID, Sesion, Medio, Monto) VALUES ("
    sQuery = sQuery & NumeroDB(idTrans) & ", "
    sQuery = sQuery & NumeroDB(iSesion) & ", "
    sQuery = sQuery & StringDB(iMedio) & ", "
    sQuery = sQuery & NumeroDB(iMonto) & ");"
  Else
    sQuery = "INSERT INTO DetallesIngresoCaja (TransID, Sesion, Medio, Emisor, Referencia, Clave, Monto) VALUES ("
    sQuery = sQuery & NumeroDB(idTrans) & ", "
    sQuery = sQuery & NumeroDB(iSesion) & ", "
    sQuery = sQuery & StringDB(iMedio) & ", "
    sQuery = sQuery & StringDB(iEmisor) & ", "
    sQuery = sQuery & StringDB(iReferencia) & ", "
    sQuery = sQuery & StringDB(iClave) & ", "
    sQuery = sQuery & NumeroDB(iMonto) & ");"
  End If
  
  dbHandle.Execute sQuery

ResumePoint:
  SalvarDetalle = bRetVal
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description

  ReportarError False, ErrN, ErrD, "clsNotasDCCP::StartProcess"
  bRetVal = False
  Resume ResumePoint
End Function


Public Sub FillComboEmisor(istrMedio As String, cbxDest As ComboBox)
Dim rs As Recordset, sOrgText As String, sList As String, sNext As String

  sOrgText = cbxDest.Text
  cbxDest.Clear
  sList = GetSetting(AppName, "fIngCaja", istrMedio, "")
  If sList <> "" Then
    sNext = strtok(sList, ",")
    Do While sNext <> ""
      cbxDest.AddItem UCase(Trim(sNext))
      sNext = strtok("", ",")
    Loop
  End If
  Set rs = dbHandle.Execute("SELECT DISTINCT Emisor FROM DetallesIngresoCaja WHERE Medio = " & StringDB(istrMedio) & " ORDER BY Emisor")
  Do While Not rs.EOF
    If lmCbxUtils.cbxKeyIndex(cbxDest, rs.Fields("Emisor")) < 0 Then
      cbxDest.AddItem rs.Fields("Emisor")
    End If
    rs.MoveNext
  Loop
  cbxDest.Text = sOrgText
  rs.Close
  Set rs = Nothing

End Sub

Public Function ExisteEmisor(istrMedio As String, istrEmisor As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean

  Set rs = dbHandle.Execute("SELECT Count(*) As Q FROM DetallesIngresoCaja WHERE Medio = " & StringDB(istrMedio) & " AND Emisor = " & StringDB(istrEmisor))
  If rs.EOF Then
    bRetVal = False
  Else
    bRetVal = (GetNumeroFromVariant(rs.Fields("Q")) <> 0)
  End If
  rs.Close
  Set rs = Nothing
  
  ExisteEmisor = bRetVal
End Function

