VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDetalleAjusteTemporal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroAjuste As Long
Public NumeroRenglon As Integer
Public CodigoItem As String
Public Cantidad As Double
Public Unidad As String

Public DireccionAjuste As Integer  ' 1: Ajuste de entrada, -1 ajuste de salida
Private CostoUnitario As Currency

Public Property Get Entradas() As Double
Dim q As Double
  q = Cantidad * DireccionAjuste
  If q < 0 Then
    q = 0
  Else
    Dim itv As clsItemInventario
    Set itv = AlmacenItemsInventario.itemInventario(Me.CodigoItem)
    If itv Is Nothing Then
      q = 0
    Else
      CostoUnitario = itv.CostoUnitario
      q = q * itv.FactorPresentacion(Me.Unidad)
      Set itv = Nothing
    End If
  End If
  Entradas = q
End Property

Public Property Get Salidas() As Double
Dim q As Double
  q = Cantidad * DireccionAjuste
  If q > 0 Then
    q = 0
  Else
    Dim itv As clsItemInventario
    Set itv = AlmacenItemsInventario.itemInventario(Me.CodigoItem)
    If itv Is Nothing Then
      q = 0
    Else
      CostoUnitario = itv.CostoUnitario
      q = q * itv.FactorPresentacion(Me.Unidad) * -1
      Set itv = Nothing
    End If
  End If
  Salidas = q
End Property


Public Sub LoadInstance(rs As Recordset, Factor As Integer)
  NumeroAjuste = rs.Fields(0)
  NumeroRenglon = rs.Fields(1)
  CodigoItem = rs.Fields(2)
  Cantidad = rs.Fields(3)
  Unidad = rs.Fields(4)
  DireccionAjuste = Factor
End Sub

Public Function RenglonesAjuste(N As Long, DireccionAjuste As Integer) As Collection
Dim retCol As New Collection
  Dim rs As Recordset
  Dim Orden As String
  If GetSetting("ClearLight", "General", "OrdenDetallesAjTemp", "0") <> "0" Then Orden = "codigoItem" Else Orden = "NumeroRenglon"
  Set rs = dbHandle.Execute("SELECT * FROM DetallesTA WHERE NumeroAjuste = " & NumeroDB(N) & " ORDER BY " & Orden)
  Do While Not rs.EOF
    Dim Detalle As CDetalleAjusteTemporal
    Set Detalle = New CDetalleAjusteTemporal
    Detalle.LoadInstance rs, DireccionAjuste
    retCol.Add Detalle
    rs.MoveNext
  Loop
  rs.Close
  Set RenglonesAjuste = retCol
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evMINV.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetBuffer) As Boolean
Dim bRetVal As Boolean, itv As clsItemInventario

  bRetVal = True
  
  Select Case sVarId
  Case "CODIGO", "CODIGOARTICULO", "CODIGOITEM"
    vRetBuffer = Me.CodigoItem
    sRetBuffer = Me.CodigoItem
  Case "ENTRADAS"
    vRetBuffer = Me.Entradas
    sRetBuffer = FormatNumero(vRetBuffer, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
  Case "SALIDAS"
    vRetBuffer = Me.Salidas
    sRetBuffer = FormatNumero(vRetBuffer, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
  Case "CANTIDAD"
    vRetBuffer = Me.Cantidad * Me.DireccionAjuste
    sRetBuffer = FormatNumero(Me.Cantidad, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
  Case "RENGLON"
    vRetBuffer = Me.NumeroRenglon
    sRetBuffer = Str(Me.NumeroRenglon)
  Case "COSTO"
    Set itv = AlmacenItemsInventario.itemInventario(Me.CodigoItem)
    If itv Is Nothing Then
      vRetBuffer = 0
    Else
      vRetBuffer = itv.CostoUnitario
    End If
    sRetBuffer = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
  Case "VALOR"
    Set itv = AlmacenItemsInventario.itemInventario(Me.CodigoItem)
    If itv Is Nothing Then
      vRetBuffer = 0
    Else
      vRetBuffer = itv.CostoUnitario
    End If
    sRetBuffer = FormatNumero(vRetBuffer * Cantidad * Me.DireccionAjuste, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  Case "VALORENTRADAS"
    vRetBuffer = Entradas * CostoUnitario
    sRetBuffer = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  Case "VALORSALIDAS"
    vRetBuffer = Salidas * CostoUnitario
    sRetBuffer = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  Case "DESCRIPCION"
    Set itv = AlmacenItemsInventario.itemInventario(Me.CodigoItem)
    If itv Is Nothing Then
      vRetBuffer = "ARTICULO NO ENCONTRADO"
    Else
      vRetBuffer = itv.Descripcion
    End If
    sRetBuffer = vRetBuffer
  Case Else
    bRetVal = ExtendEval(sVarId, vRetBuffer, sRetBuffer)
  End Select
  
  EvalVar = bRetVal
    
End Function

