VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDataSet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public ID As Long
Public sDescripcion As String
Public sConnect As String
Public sDataDir As String

'---------------------------------------------------------------------------------------
' Procedure : Add
' DateTime  : 08/08/2004 23:25
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Public Function Add(Descripcion As String, Connect As String, DataDir As String) As Boolean
  Dim DataSet As CDataSet, col As Collection
  Dim retVal As Boolean, sFileName As String
  
  retVal = True
  On Error GoTo ErrHandler
  Set col = Me.DataSets
  Me.ID = 0
  For Each DataSet In col
    If DataSet.ID > Me.ID Then
      Me.ID = DataSet.ID
    End If
  Next
  Me.ID = Me.ID + 1
  
  Dim f As Integer
  If right(DataDir, 1) = "\" Then DataDir = left(DataDir, Len(DataDir) - 1)
  f = FreeFile
  sFileName = GetSetting(AppName, "General", "CatalogoEmpresas", "<NIL>")
  Open sFileName For Append As #f
  Write #f, Me.ID, Descripcion, Connect, DataDir
  Close #f

ResumePoint:
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  retVal = False
  ReportarError False, nErrN, sErrD, "CDataSet::Add"
  Resume ResumePoint
End Function

'---------------------------------------------------------------------------------------
' Procedure : DefinirCatalogo
' DateTime  : 08/08/2004 12:14
' Author    : Leonardo Azpurua
' Purpose   : Determinar la ubicacion del catlogo de empresas
'---------------------------------------------------------------------------------------
'
Public Function DefinirCatalogo() As String

  On Error GoTo ErrHandler
  Dim s As String
  
  s = BrowseForPath("Ubicacin del catalogo de empresas")
  If s = "" Then
    DefinirCatalogo = "<NIL>"
    Exit Function
  End If
  If right(s, 1) <> "\" Then s = s & "\"
  s = s & "Empresas.Catalogo"
  If Dir(s) = "" Then
    Dim f As Integer
    f = FreeFile
    Open s For Output As #f
    Close f
  End If
  SaveSetting "ClearLight", "General", "CatalogoEmpresas", s
  DefinirCatalogo = s

ResumePoint:
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  ReportarError False, nErrN, sErrD, "CDataSet::DefinirCatalogo"
  DefinirCatalogo = "<NIL>"
  Resume ResumePoint

End Function

'---------------------------------------------------------------------------------------
' Procedure : DataSets
' DateTime  : 11/08/03 08:42
' Author    : Leonardo Azpurua
' Purpose   :  Carga los datasets disponibles en una coleccion
'---------------------------------------------------------------------------------------
'
Public Function DataSets() As Collection
Dim sCatalog As String
Dim f As Integer, _
    num As Long, _
    Descripcion As String, _
    connString As String, _
    DataDir As String
Dim pInstance As CDataSet, retCol As Collection

  On Error GoTo ErrHandler
  Set retCol = New Collection
  sCatalog = GetSetting("ClearLight", "General", "CatalogoEmpresas", "<NIL>")
  
  If sCatalog = "<NIL>" Then
    sCatalog = DefinirCatalogo
  ElseIf Dir(sCatalog) = "" Then
    sCatalog = DefinirCatalogo
  End If

  If sCatalog = "<NIL>" Then
    Err.Raise 10001, "DataSets", "No esta definida la ubicacion del Catalogo de Empresas"
    Set DataSets = Nothing
    Exit Function
  End If
  f = FreeFile
  Open sCatalog For Input As #f
  Do While Not EOF(f)
    Input #f, num, Descripcion, connString, DataDir
    Set pInstance = New CDataSet
    With pInstance
    .ID = num
    .sDescripcion = Descripcion
    .sDataDir = DataDir
    .sConnect = connString
    End With
    retCol.Add pInstance
  Loop

ResumePoint:
  On Error Resume Next
  Close f
  Set DataSets = retCol
  Exit Function

ErrHandler:
  Resume ResumePoint
End Function

Public Function item(nNumero As Long) As CDataSet
Dim pDataSet As CDataSet

  For Each pDataSet In Me.DataSets
    If pDataSet.ID = nNumero Then
      Set item = pDataSet
      Exit Function
    End If
  Next
  Set item = Nothing
End Function

