VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CContadores"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const qDocs = 10

Private docType As Variant
Private ColNames As Variant
Private Values(qDocs) As Long
Private nClave As Long
Private dtInstallTM As Date
Private vmStatus As Currency
Private rs As Recordset
Private lOrgClave As Long

Public Sub AddRecord(nNNEE As Long, nDev As Long, nCOT As Long, nOC As Long)
Dim i As Integer, sQuery As String

  For i = 0 To qDocs - 1
    Values(i) = 1
  Next
  Values(1) = nNNEE
  Values(2) = nCOT
  Values(3) = nDev
  Values(5) = nOC
  dtInstallTM = Now
  nClave = 0
  vmStatus = 0

  sQuery = "INSERT INTO contadores (NotaEntrega, Cotizacion, DevolucionVenta, OrdenCompra, Apertura, Clave, Status) SELECT "
  sQuery = sQuery & NumeroDB(nNNEE) & ", " & NumeroDB(nCOT) & ", " & NumeroDB(nDev) & ", " & NumeroDB(nOC) & ", "
  sQuery = sQuery & TimeDateDB(dtInstallTM) & ", " & NumeroDB(nClave) & ", " & NumeroDB(vmStatus)
  
  dbHandle.Execute sQuery

End Sub

Private Sub LoadContadores(Optional ByVal doIncrement As Boolean = False)
Dim i As Integer

  On Error GoTo ErrHandler
  Set rs = New Recordset
  rs.CursorLocation = adUseServer
  rs.Open "SELECT * FROM Contadores", dbHandle, adOpenStatic, adLockPessimistic, adCmdText
  If rs.EOF Then
    Exit Sub
  End If
  For i = 0 To qDocs - 1
    Values(i) = rs.Fields(i).value
  Next
  dtInstallTM = GetDateFromVariant(rs!Apertura)
  nClave = GetNumeroFromVariant(rs!Clave)
  vmStatus = GetNumeroFromVariant(rs!Status)
  If Date + 1 < dtInstallTM Then
    mAdvertencia "La fecha de su sistema no puede ser anterior al " & Format(dtInstallTM, "Short Date")
    End
  End If

  If Not doIncrement Then
    rs.Close
    Set rs = Nothing
  Else
    rs.Fields("Operacion").value = rs.Fields("Operacion").value + 1
  End If

  Exit Sub

ErrHandler:
  Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Raise nErrN, "CContadores::LoadContadores", sErrD
End Sub

Public Sub RegistrarEmisionDocumento(istrTipoDoc As String, ilngNumero As Long)
Dim i As Integer

  i = DocIndex(istrTipoDoc)
  If (i < 0) Then
    Err.Raise 10001, "CContadores::Documento", "Tipo de documento invlido: " & istrTipoDoc
    Exit Sub
  End If

  On Error GoTo ErrHandler

  LoadContadores True
  If Values(i) <= ilngNumero Then
    Values(i) = ilngNumero + 1
    vmStatus = 1
    rs.Fields(i).value = Values(i)
    rs.Fields("Status") = vmStatus
    rs.Update
    rs.Close
    Set rs = Nothing
  End If

  Exit Sub

ErrHandler:
  Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  On Error GoTo 0
  Err.Raise nErrN, "CContadores::RegistrarEmisionDocumento", sErrD
End Sub

Public Function NumeroProximoDocumento(strDocType As String, Optional doIncrement As Boolean = False) As Long
Dim i As Integer, retVal As Long

    i = DocIndex(strDocType)
    If (i < 0) Then
      Err.Raise 10001, "CContadores::Documento", "Tipo de documento invlido: " & strDocType
      NumeroProximoDocumento = -1
      Exit Function
    End If
    
    If Not SetGlobalLock("Contadores") Then
      Err.Raise 10001, "CContadores::Documento", "Imposible obtener numero del documento"
      NumeroProximoDocumento = -1
      Exit Function
    End If

    On Error GoTo ErrHandler
    LoadContadores doIncrement

    retVal = Values(i)
    
    If doIncrement Then
'      rs.Edit
      retVal = Values(i)
      Values(i) = Values(i) + 1
      vmStatus = 1
      rs.Fields(i).value = Values(i)
      rs.Fields("Status") = vmStatus
      rs.Update
      rs.Close
      Set rs = Nothing
    End If
    
    FreeGlobalLock

    NumeroProximoDocumento = retVal

    Exit Function

ErrHandler:
  Dim sErrD As String, nErrN As Long, sErrS As String
  sErrD = Err.Description: nErrN = Err.Number: sErrS = Err.Source
  FreeGlobalLock
  Err.Raise nErrN, sErrS, sErrD

End Function

Public Function DocIndex(istrDocID As String) As Integer
Dim i As Integer, strDocID As String

    strDocID = UCase(Trim(istrDocID))
    For i = 0 To qDocs - 1
        If docType(i) = strDocID Then
            DocIndex = i
            Exit Function
        End If
    Next
    
    DocIndex = -1

End Function

Private Sub Class_Initialize()
    docType = Array("FCT", "NDE", "COT", "DVV", "RCM", "ODC", "DVC", "AJU", "TRI", "NDC")
    ColNames = Array("Factura", "NotaEntrega", "Cotizacion", "DevolucionVenta", "Compra", "OrdenCompra", "DevolucionCompra", "Ajuste", "Transferencia", "NotaDBCR")
    LoadContadores
End Sub

