VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CAjusteTemporal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long
Public Fecha As Date
Public refAjuste As String
Public Tipo As Boolean
Public Descripcion As String
Public Notas As String
Public Contrapartida As String
Public Almacen As String

Private ProximoDetalle As Integer

' ******************************
' ISDOC
' ******************************

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public Property Get TipoEntidad() As String              ' Identificacin para ISDOC
  TipoEntidad = "AJT"
End Property

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Referencia() As String
  Referencia = "AJT" & Format(Numero, "000000")
End Function

Public Function Concepto() As String
  Concepto = Descripcion
End Function

Public Function NombreArchivoFormato() As String
Dim sKey As String
  sKey = BuildDataPath("FormatoAjusteTemporal.txt", AppName)
  NombreArchivoFormato = DeterminarFormato("FormatoAjusteTemporal", "FormatosAjustesTemporales", sKey, Me)
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant
  bRetVal = mScriptExecute.ExtendEval(Me, "evAjusteTemporal.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal
End Function

Public Property Get Valor() As Currency
  Dim det As CDetalleAjusteTemporal, v As Currency
  Dim itv As New clsItemInventario
  Dim factor As Integer
  
  If Me.Tipo Then
    factor = -1
  Else
    factor = 1
  End If
  
  For Each det In Me.Detalles
    Set itv = AlmacenItemsInventario.itemInventario(det.CodigoItem)
    If Not (itv Is Nothing) Then
      v = v + (itv.CostoUnitario * det.Cantidad * factor)
    End If
  Next
  
  Valor = v
End Property

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean
  
  bRetVal = True
  
  Select Case sVarId
  
  Case "NUMERO"
    vRetBuffer = Me.Referencia
    sRetString = Me.Referencia
  
  Case "FECHA_REGISTRO"
    vRetBuffer = Fecha
    sRetString = Format(Fecha, "Short Date")
  
  Case "FECHA", "FECHA_AJUSTE", "FECHA_EMISION"
    vRetBuffer = Me.Fecha
    sRetString = Format(Fecha, "Short Date")
  
  Case "OPERADOR"
    vRetBuffer = UsuarioActivo.Codigo
    sRetString = UsuarioActivo.Codigo
  
  Case "DESCRIPCION"
    vRetBuffer = Descripcion
    sRetString = Descripcion
  
  Case "REFERENCIA", "REFAJUSTE"
    vRetBuffer = refAjuste
    sRetString = refAjuste
  
  Case "TIPO"
    sRetString = IIf(Me.Tipo, "SALIDA", "ENTRADA")
    vRetBuffer = sRetString
  
  Case "NOTAS"
    sRetString = Notas
    vRetBuffer = Notas
  
  Case "CONTRAPARTIDA"
    sRetString = Contrapartida
    vRetBuffer = Contrapartida
  
  Case "ALMACEN"
    sRetString = Almacen
    vRetBuffer = Almacen
  
  Case "NOMBRE_ALMACEN"
    sRetString = Almacenes.NombreAlmacen(Almacen)
    vRetBuffer = sRetString
  
  Case "VALOR"
    vRetBuffer = Valor
    sRetString = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  
  Case Else
    bRetVal = False
  
  End Select
  
  If Not bRetVal Then
    bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sRetString)
  End If
  
  If Not bRetVal Then
    bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
  End If
  
  EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

' LoadByRef recibe una "referencia" completa a un documento ISDOC,
' y carga los datos correspondientes en <Me>
' Devuelve True si existe una factura con la referencia recibida
Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lng As Long, retVal As Boolean
  If Len(sRef) < 4 Then
    retVal = False
  Else
    lng = Val(Mid(sRef, 3))
    retVal = Me.Load(lng)
  End If
  LoadByReferenciaISDOC = retVal
End Function

' Show (ISDOC) causa que el documento se presente en una forma de
' consulta...
Public Sub Show()
  ViewPrint False
End Sub

' Se presenta y/o imprime el documento
Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

' ****************************************
' End ISDOC
' ****************************************

Public Sub BeginProcess(iNumero As Long, _
                      iRefAjuste As String, _
                      iTipo As Boolean, _
                      iDescripcion As String, _
                      iNotas As String, _
                      iContrapartida As String, _
                      iAlmacen As String)
  Dim sQuery As String

  lmdbHandle.StartTransaction
  With Me
    .Numero = iNumero
    .Tipo = iTipo
    .refAjuste = iRefAjuste
    .Descripcion = iDescripcion
    .Notas = iNotas
    .Contrapartida = iContrapartida
    .Almacen = iAlmacen
  End With
  
  On Error GoTo ErrHandler
  If iNumero Then
    RemoveDetalles iNumero
    Me.Numero = iNumero
    dbHandle.Execute "DELETE FROM DetallesTA WHERE NumeroAjuste = " & NumeroDB(iNumero)
    sQuery = "UPDATE TempAjustes SET refAjuste = " & StringDB(iRefAjuste) & ", "
    sQuery = sQuery & "Fecha = " & FechaDB(Date) & ", "
    sQuery = sQuery & "Tipo = " & NumeroDB(iTipo) & ", "
    sQuery = sQuery & "Descripcion = " & StringDB(iDescripcion) & ", "
    sQuery = sQuery & "Notas = " & StringDB(iNotas) & ", "
    sQuery = sQuery & "Contrapartida = " & StringDB(iContrapartida) & ", "
    sQuery = sQuery & "Almacen = " & StringDB(iAlmacen) & " "
    sQuery = sQuery & "WHERE Numero = " & NumeroDB(iNumero)
  Else
    sQuery = "INSERT INTO tempajustes (refAjuste, Tipo, Descripcion, Notas, Contrapartida, Almacen, Fecha) "
    sQuery = sQuery & "VALUES (" & StringDB(iRefAjuste) & ", "
    sQuery = sQuery & NumeroDB(iTipo) & ", "
    sQuery = sQuery & StringDB(iDescripcion) & ", "
    sQuery = sQuery & StringDB(iNotas) & ", "
    sQuery = sQuery & StringDB(iContrapartida) & ", "
    sQuery = sQuery & StringDB(iAlmacen) & ", "
    sQuery = sQuery & FechaDB(Now) & ");"
  End If
  
  dbHandle.Execute sQuery
  If iNumero = 0 Then
    Dim rs As Recordset
    Set rs = dbHandle.Execute("SELECT @@IDENTITY")
    Me.Numero = rs.Fields(0)
    rs.Close
  End If
  
  ProximoDetalle = 1
  
  Exit Sub

ErrHandler:
  Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  lmdbHandle.AbortTransaction
  Err.Raise nErrN, "CAjusteTemporal::BeginProcess", sErrD & " (en cAjusteTemporal.BeginProcess)"
End Sub

Public Sub AddDetalle(iCodigoItem As String, iCantidad As Double, iUnidad As String)
Dim sQuery As String, ra As Long
  
  If iCantidad = 0 Then Exit Sub
  On Error GoTo ErrHandler
  sQuery = "INSERT INTO DetallesTA (NumeroAjuste, NumeroRenglon, CodigoItem, Cantidad, Unidad) VALUES ("
  sQuery = sQuery & NumeroDB(Me.Numero) & ", "
  sQuery = sQuery & NumeroDB(ProximoDetalle) & ", "
  sQuery = sQuery & StringDB(iCodigoItem) & ", "
  sQuery = sQuery & NumeroDB(iCantidad) & ", "
  sQuery = sQuery & StringDB(iUnidad) & ");"
  dbHandle.Execute sQuery
  ProximoDetalle = ProximoDetalle + 1

  Dim itv As clsItemInventario
  Set itv = AlmacenItemsInventario.itemInventario(iCodigoItem)
  If Not itv Is Nothing Then
    Dim FactorDireccion As Integer, FactorCantidad As Double
    FactorDireccion = IIf(Tipo, 1, -1)
    FactorCantidad = itv.FactorPresentacion(iUnidad)
    
    Dim s As String
    s = "UPDATE itemsInventario SET Asignadas = Asignadas + (" & NumeroDB(iCantidad * FactorDireccion * FactorCantidad) & ") WHERE Codigo = " & StringDB(itv.Codigo)
    dbHandle.Execute s
    
    s = "UPDATE ExistenciaUbicacion SET Asignadas = Asignadas + (" & NumeroDB(iCantidad * FactorDireccion * FactorCantidad) & ") WHERE CodigoItem = " & StringDB(itv.Codigo) & " AND Almacen = " & StringDB(Almacen)
    dbHandle.Execute s, ra
    If ra < 1 Then
      s = "INSERT INTO ExistenciaUbicacion (CodigoItem, Almacen, Asignadas) VALUES ("
      s = s & StringDB(iCodigoItem) & ", "
      s = s & StringDB(Me.Almacen) & ", "
      s = s & NumeroDB(iCantidad * FactorDireccion * FactorCantidad) & ")"
      dbHandle.Execute s
    End If
  Else
    Err.Raise 10001, "AddDetalle", "Referencia a articulo " & iCodigoItem & " no registrado."
  End If

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  lmdbHandle.AbortTransaction
  Err.Raise nErrN, "CAjusteTemporal::AddDetalle", sErrD & " (en CAjusteTemporal::AddDetalle)"
End Sub

Public Sub EndProcess()
  lmdbHandle.CommitTransaction
End Sub

Public Function Load(Numero As Long) As Boolean
  Dim rs As Recordset, b As Boolean
  Set rs = dbHandle.Execute("SELECT * FROM TempAjustes WHERE Numero = " & NumeroDB(Numero))
  If rs.EOF Then
    b = False
  Else
    With Me
      .Numero = rs!Numero
      .Fecha = rs!Fecha
      .refAjuste = rs!refAjuste
      .Tipo = rs!Tipo
      .Descripcion = rs!Descripcion
      .Notas = rs!Notas
      .Contrapartida = rs!Contrapartida
      .Almacen = rs!Almacen
    End With
    b = True
  End If
  rs.Close
  Load = b
End Function

Public Function Detalles() As Collection
Dim p As New CDetalleAjusteTemporal
  Set Detalles = p.RenglonesAjuste(Me.Numero, IIf(Me.Tipo, -1, 1))
End Function

Private Function RemoveDetalles(n As Long)
Dim a As New CAjusteTemporal, d As CDetalleAjusteTemporal

  If Not a.Load(n) Then Exit Function
  For Each d In a.Detalles
    Dim itv As clsItemInventario
    Set itv = AlmacenItemsInventario.itemInventario(d.CodigoItem)
    If Not itv Is Nothing Then
      Dim FactorDireccion As Integer, FactorCantidad As Double
      FactorDireccion = IIf(a.Tipo, -1, 1)
      FactorCantidad = itv.FactorPresentacion(d.Unidad)
      Dim s As String
      s = "UPDATE itemsInventario SET Asignadas = Asignadas + (" & NumeroDB(d.Cantidad * FactorDireccion * FactorCantidad) & ") WHERE Codigo = " & StringDB(itv.Codigo)
      dbHandle.Execute s
      Dim ra As Long
      s = "UPDATE ExistenciaUbicacion SET Asignadas = Asignadas + (" & NumeroDB(d.Cantidad * FactorDireccion * FactorCantidad) & ") WHERE CodigoItem = " & StringDB(itv.Codigo) & " AND Almacen = " & StringDB(a.Almacen)
      dbHandle.Execute s, ra
      If ra < 1 Then
        s = "INSERT INTO ExistenciaUbicacion (CodigoItem, Almacen, Asignadas) VALUES ("
        s = s & StringDB(itv.Codigo) & ", "
        s = s & StringDB(Me.Almacen) & ", "
        s = s & NumeroDB(d.Cantidad * FactorDireccion * FactorCantidad) & ")"
        dbHandle.Execute s
      End If
    End If
  Next

End Function

Public Function EliminarAjuste(n As Long)
  RemoveDetalles (n)
  dbHandle.Execute "DELETE FROM TempAjustes WHERE Numero = " & NumeroDB(n)
  dbHandle.Execute "DELETE FROM DetallesTA WHERE NumeroAjuste = " & NumeroDB(n)
  
End Function

Public Function AjustesPendientes() As Collection
  Dim retCol As New Collection
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT * FROM TempAjustes ORDER BY Numero")
  Do While Not rs.EOF
    Dim Ajuste As CAjusteTemporal
    Set Ajuste = New CAjusteTemporal
    With Ajuste
      .Numero = rs!Numero
      .Fecha = rs!Fecha
      .refAjuste = rs!refAjuste
      .Tipo = rs!Tipo
      .Descripcion = rs!Descripcion
      .Notas = rs!Notas
      .Contrapartida = rs!Contrapartida
      .Almacen = rs!Almacen
    End With
    retCol.Add Ajuste
    rs.MoveNext
  Loop
  rs.Close
  Set AjustesPendientes = retCol
End Function
